/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.MergedObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelMergerUtil {
    @Nullable
    public static <T> T getFirstImplementation(T t) {
        T cur = t;
        while (cur instanceof MergedObject) {
            List implementations = ((MergedObject)cur).getImplementations();
            cur = implementations.isEmpty() ? null : implementations.get(0);
        }
        return cur;
    }

    @Nullable
    public static <T, V> V getImplementation(Class<V> clazz, Collection<T> elements) {
        for (T element : elements) {
            V implementation = ModelMergerUtil.getImplementation(element, clazz);
            if (implementation == null) continue;
            return implementation;
        }
        return null;
    }

    @Nullable
    public static <T, V> V getImplementation(Class<V> clazz, T ... elements) {
        return ModelMergerUtil.getImplementation(clazz, Arrays.asList(elements));
    }

    @Nullable
    public static <T, V> V getImplementation(T element, final Class<V> clazz) {
        if (element == null) {
            return null;
        }
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor<T>(){

            public boolean process(T t) {
                return !ReflectionUtil.isAssignable((Class)clazz, t.getClass()) || super.process(t);
            }
        };
        new ImplementationProcessor<T>(processor, true).process(element);
        return (V)processor.getFoundValue();
    }

    @NotNull
    public static <T, V> Collection<V> getImplementations(T element, final Class<V> clazz) {
        if (element == null) {
            List list = Collections.emptyList();
            if (list == null) {
                ModelMergerUtil.$$$reportNull$$$0(0);
            }
            return list;
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor<T>(){

            public boolean process(T t) {
                return !ReflectionUtil.isAssignable((Class)clazz, t.getClass()) || super.process(t);
            }
        };
        new ImplementationProcessor<T>(processor, true).process(element);
        Collection collection = processor.getResults();
        if (collection == null) {
            ModelMergerUtil.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public static <T> List<T> getImplementations(T element) {
        if (element instanceof MergedObject) {
            MergedObject mergedObject = (MergedObject)element;
            List list = mergedObject.getImplementations();
            if (list == null) {
                ModelMergerUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (element != null) {
            List<T> list = Collections.singletonList(element);
            if (list == null) {
                ModelMergerUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            ModelMergerUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static <T> List<T> getFilteredImplementations(T element) {
        if (element == null) {
            List list = Collections.emptyList();
            if (list == null) {
                ModelMergerUtil.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList result2 = new ArrayList();
        Processor processor = Processors.cancelableCollectProcessor(result2);
        new ImplementationProcessor(processor, false).process(element);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ModelMergerUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public static <T> Processor<T> createFilteringProcessor(Processor<T> processor) {
        ImplementationProcessor<T> implementationProcessor = new ImplementationProcessor<T>(processor, false);
        if (implementationProcessor == null) {
            ModelMergerUtil.$$$reportNull$$$0(7);
        }
        return implementationProcessor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/xml/ModelMergerUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementations";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredImplementations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilteringProcessor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class ImplementationProcessor<T>
    implements Processor<T> {
        private final Processor<T> myProcessor;
        private final boolean myProcessMerged;

        public ImplementationProcessor(Processor<T> processor, boolean processMerged) {
            this.myProcessor = processor;
            this.myProcessMerged = processMerged;
        }

        public boolean process(T t) {
            boolean merged = t instanceof MergedObject;
            if (!(merged && !this.myProcessMerged || this.myProcessor.process(t))) {
                return false;
            }
            return !merged || ContainerUtil.process(((MergedObject)t).getImplementations(), (Processor)this);
        }
    }
}

