/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListRenderer;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowser;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.issueLinks.AbstractBaseTagMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableViewSpeedSearch;
import com.intellij.ui.table.TableView;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.integrate.MergeCalculatorTask;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.MoreAction;
import org.jetbrains.idea.svn.integrate.QuantitySelection;
import org.jetbrains.idea.svn.mergeinfo.ListMergeStatus;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;

public class ToBeMergedDialog
extends DialogWrapper {
    public static final int MERGE_ALL_CODE = 222;
    private final JPanel myPanel;
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final ListTableModel<SvnChangeList> myRevisionsModel;
    private TableView<SvnChangeList> myRevisionsList;
    private CommittedChangesBrowser myRepositoryChangesBrowser;
    private Splitter mySplitter;
    private final QuantitySelection<Long> myWiseSelection;
    private final Set<Change> myAlreadyMerged;
    private final MergeChecker myMergeChecker;
    private final boolean myAllStatusesCalculated;
    private volatile boolean myAllListsLoaded;
    private final Map<Long, ListMergeStatus> myStatusMap;
    private MoreXAction myMore100Action;
    private MoreXAction myMore500Action;
    private boolean myDisposed;
    private static final ColumnInfo FAKE_COLUMN = new ColumnInfo<SvnChangeList, SvnChangeList>("fake column"){

        public SvnChangeList valueOf(SvnChangeList changeList) {
            return changeList;
        }
    };

    public ToBeMergedDialog(@NotNull MergeContext mergeContext, @NotNull List<SvnChangeList> changeLists, String title, @NotNull MergeChecker mergeChecker, boolean allStatusesCalculated, boolean allListsLoaded) {
        if (mergeContext == null) {
            ToBeMergedDialog.$$$reportNull$$$0(0);
        }
        if (changeLists == null) {
            ToBeMergedDialog.$$$reportNull$$$0(1);
        }
        if (mergeChecker == null) {
            ToBeMergedDialog.$$$reportNull$$$0(2);
        }
        super(mergeContext.getProject(), true);
        this.myMergeContext = mergeContext;
        this.myAllListsLoaded = allListsLoaded;
        this.myStatusMap = Collections.synchronizedMap(ContainerUtil.newHashMap());
        this.myMergeChecker = mergeChecker;
        this.myAllStatusesCalculated = allStatusesCalculated;
        this.setTitle(title);
        this.myRevisionsModel = new ListTableModel(new ColumnInfo[]{FAKE_COLUMN}, changeLists);
        this.myPanel = new JPanel(new BorderLayout());
        this.myWiseSelection = new QuantitySelection(allStatusesCalculated);
        this.myAlreadyMerged = ContainerUtilRt.newHashSet();
        this.setOKButtonText("Merge Selected");
        this.initUI();
        this.init();
        this.enableLoadButtons();
        if (!this.myAllStatusesCalculated) {
            this.refreshListStatus(changeLists);
        }
    }

    private void enableLoadButtons() {
        this.myMore100Action.setVisible(!this.myAllListsLoaded);
        this.myMore500Action.setVisible(!this.myAllListsLoaded);
        this.myMore100Action.setEnabled(!this.myAllListsLoaded);
        this.myMore500Action.setEnabled(!this.myAllListsLoaded);
    }

    public void setAllListsLoaded() {
        this.myAllListsLoaded = true;
        this.enableLoadButtons();
    }

    public long getLastNumber() {
        int totalRows = this.myRevisionsModel.getRowCount();
        return totalRows > 0 ? ((SvnChangeList)this.myRevisionsModel.getItem(totalRows - 1)).getNumber() : 0L;
    }

    public void addMoreLists(@NotNull List<SvnChangeList> changeLists) {
        if (changeLists == null) {
            ToBeMergedDialog.$$$reportNull$$$0(3);
        }
        this.myRevisionsModel.addRows(changeLists);
        this.myRevisionsList.revalidate();
        this.myRevisionsList.repaint();
        this.myMore100Action.setEnabled(true);
        this.myMore500Action.setEnabled(true);
        this.myMore500Action.setVisible(true);
        this.refreshListStatus(changeLists);
    }

    protected void dispose() {
        super.dispose();
        this.myDisposed = true;
    }

    private void refreshListStatus(@NotNull List<SvnChangeList> changeLists) {
        if (changeLists == null) {
            ToBeMergedDialog.$$$reportNull$$$0(4);
        }
        if (this.myDisposed) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (changeLists == null) {
                ToBeMergedDialog.$$$reportNull$$$0(14);
            }
            int cnt = 10;
            for (SvnChangeList list : changeLists) {
                this.myStatusMap.put(list.getNumber(), ToBeMergedDialog.toListMergeStatus(this.myMergeChecker.checkList(list)));
                if (--cnt > 0) continue;
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myRevisionsList.revalidate();
                    this.myRevisionsList.repaint();
                });
                cnt = 10;
            }
            this.myRevisionsList.revalidate();
            this.myRevisionsList.repaint();
        });
    }

    @NotNull
    private static ListMergeStatus toListMergeStatus(@NotNull SvnMergeInfoCache.MergeCheckResult mergeCheckResult) {
        ListMergeStatus result;
        if (mergeCheckResult == null) {
            ToBeMergedDialog.$$$reportNull$$$0(5);
        }
        switch (mergeCheckResult) {
            case MERGED: {
                result = ListMergeStatus.MERGED;
                break;
            }
            case NOT_EXISTS: {
                result = ListMergeStatus.ALIEN;
                break;
            }
            default: {
                result = ListMergeStatus.REFRESHING;
            }
        }
        ListMergeStatus listMergeStatus = result;
        if (listMergeStatus == null) {
            ToBeMergedDialog.$$$reportNull$$$0(6);
        }
        return listMergeStatus;
    }

    @NotNull
    protected Action[] createActions() {
        if (this.myAllStatusesCalculated) {
            Action[] actionArray = new Action[]{this.getOKAction(), new DialogWrapper.DialogWrapperAction("Merge All"){

                protected void doAction(ActionEvent e) {
                    ToBeMergedDialog.this.close(222);
                }
            }, this.getCancelAction()};
            if (actionArray == null) {
                ToBeMergedDialog.$$$reportNull$$$0(7);
            }
            return actionArray;
        }
        Action[] actionArray = super.createActions();
        if (actionArray == null) {
            ToBeMergedDialog.$$$reportNull$$$0(8);
        }
        return actionArray;
    }

    @NotNull
    public List<SvnChangeList> getSelected() {
        Set<Long> selected = this.myWiseSelection.getSelected();
        Set<Long> unselected = this.myWiseSelection.getUnselected();
        Condition filter = this.myWiseSelection.areAllSelected() ? list -> !unselected.contains(list.getNumber()) : list -> selected.contains(list.getNumber());
        List list2 = ContainerUtil.filter((Collection)this.myRevisionsModel.getItems(), (Condition)filter);
        if (list2 == null) {
            ToBeMergedDialog.$$$reportNull$$$0(9);
        }
        return list2;
    }

    protected String getDimensionServiceKey() {
        return "org.jetbrains.idea.svn.dialogs.ToBeMergedDialog";
    }

    private void initUI() {
        final ListSelectionListener selectionListener = e -> {
            List changeLists = this.myRevisionsList.getSelectedObjects();
            this.myAlreadyMerged.clear();
            for (SvnChangeList changeList : changeLists) {
                this.myAlreadyMerged.addAll(this.getAlreadyMergedPaths(changeList));
            }
            this.myRepositoryChangesBrowser.setChangesToDisplay((Collection)CommittedChangesTreeBrowser.collectChanges((List)changeLists, (boolean)false));
            this.mySplitter.doLayout();
            this.myRepositoryChangesBrowser.repaint();
        };
        final MyListCellRenderer listCellRenderer = new MyListCellRenderer();
        this.myRevisionsList = new TableView<SvnChangeList>(){

            public TableCellRenderer getCellRenderer(int row, int column) {
                return listCellRenderer;
            }

            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                selectionListener.valueChanged(e);
            }
        };
        this.myRevisionsList.setExpandableItemsEnabled(false);
        new TableViewSpeedSearch<SvnChangeList>(this.myRevisionsList){

            protected String getItemText(@NotNull SvnChangeList element) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                return element.getComment();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/svn/integrate/ToBeMergedDialog$3", "getItemText"));
            }
        };
        this.myRevisionsList.setModelAndUpdateColumns(this.myRevisionsModel);
        this.myRevisionsList.setTableHeader(null);
        this.myRevisionsList.setShowGrid(false);
        AbstractBaseTagMouseListener mouseListener = new AbstractBaseTagMouseListener(){

            public Object getTagAt(@NotNull MouseEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                JTable table = (JTable)e.getSource();
                int row = table.rowAtPoint(e.getPoint());
                int column = table.columnAtPoint(e.getPoint());
                if (row == -1 || column == -1) {
                    return null;
                }
                listCellRenderer.customizeCellRenderer(table, table.getValueAt(row, column), table.isRowSelected(row));
                return listCellRenderer.myRenderer.getFragmentTagAt(e.getPoint().x - table.getCellRect((int)row, (int)column, (boolean)false).x);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/integrate/ToBeMergedDialog$4", "getTagAt"));
            }
        };
        mouseListener.installOn(this.myRevisionsList);
        this.myMore100Action = new MoreXAction(100);
        this.myMore500Action = new MoreXAction(500);
        BorderLayoutPanel panel = JBUI.Panels.simplePanel().addToCenter((Component)ScrollPaneFactory.createScrollPane(this.myRevisionsList)).addToTop((Component)this.createToolbar().getComponent());
        this.mySplitter = new Splitter(false, 0.7f);
        this.mySplitter.setFirstComponent((JComponent)panel);
        this.myRepositoryChangesBrowser = new CommittedChangesBrowser(this.myMergeContext.getProject());
        this.myRepositoryChangesBrowser.getDiffAction().registerCustomShortcutSet(this.myRevisionsList, null);
        this.myRepositoryChangesBrowser.setChangeNodeDecorator(this.createChangesDecorator());
        this.mySplitter.setSecondComponent((JComponent)this.myRepositoryChangesBrowser);
        this.mySplitter.setDividerWidth(2);
        this.addRevisionListListeners();
        this.myPanel.add((Component)this.mySplitter, "Center");
    }

    @NotNull
    private ActionToolbar createToolbar() {
        DefaultActionGroup actions = new DefaultActionGroup(new AnAction[]{new MySelectAll(), new MyUnselectAll(), this.myMore100Action, this.myMore500Action});
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("SvnToBeMerged", (ActionGroup)actions, true);
        if (actionToolbar == null) {
            ToBeMergedDialog.$$$reportNull$$$0(10);
        }
        return actionToolbar;
    }

    @NotNull
    private List<Change> getAlreadyMergedPaths(@NotNull SvnChangeList svnChangeList) {
        Collection<String> notMerged;
        if (svnChangeList == null) {
            ToBeMergedDialog.$$$reportNull$$$0(11);
        }
        List list = ContainerUtil.isEmpty(notMerged = this.myMergeChecker.getNotMergedPaths(svnChangeList)) ? ContainerUtilRt.emptyList() : svnChangeList.getAffectedPaths().stream().filter(path -> !notMerged.contains(path)).map(svnChangeList::getByPath).collect(Collectors.toList());
        if (list == null) {
            ToBeMergedDialog.$$$reportNull$$$0(12);
        }
        return list;
    }

    private ChangeNodeDecorator createChangesDecorator() {
        return new ChangeNodeDecorator(){

            public void decorate(Change change, SimpleColoredComponent component, boolean isShowFlatten) {
            }

            public void preDecorate(Change change, ChangesBrowserNodeRenderer renderer, boolean showFlatten) {
                if (ToBeMergedDialog.this.myAlreadyMerged.contains(change)) {
                    renderer.append(" [already merged] ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                }
            }
        };
    }

    private void addRevisionListListeners() {
        final int checkboxWidth = new JCheckBox().getPreferredSize().width;
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                int idx;
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                if ((idx = ToBeMergedDialog.this.myRevisionsList.rowAtPoint(e.getPoint())) >= 0) {
                    Rectangle baseRect = ToBeMergedDialog.this.myRevisionsList.getCellRect(idx, 0, false);
                    baseRect.setSize(checkboxWidth, baseRect.height);
                    if (baseRect.contains(e.getPoint())) {
                        ToBeMergedDialog.this.toggleInclusion((SvnChangeList)ToBeMergedDialog.this.myRevisionsModel.getRowValue(idx));
                        ToBeMergedDialog.this.myRevisionsList.repaint(baseRect);
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/integrate/ToBeMergedDialog$6", "onClick"));
            }
        }.installOn(this.myRevisionsList);
        this.myRevisionsList.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                List selected;
                if (32 == e.getKeyCode() && !(selected = ToBeMergedDialog.this.myRevisionsList.getSelectedObjects()).isEmpty()) {
                    selected.forEach(x$0 -> ToBeMergedDialog.this.toggleInclusion(x$0));
                    ToBeMergedDialog.this.myRevisionsList.repaint();
                    e.consume();
                }
            }
        });
    }

    private void toggleInclusion(@NotNull SvnChangeList list) {
        long number;
        if (list == null) {
            ToBeMergedDialog.$$$reportNull$$$0(13);
        }
        if (this.myWiseSelection.isSelected(number = list.getNumber())) {
            this.myWiseSelection.remove(number);
        } else {
            this.myWiseSelection.add(number);
        }
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeContext";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeLists";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeChecker";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeCheckResult";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/integrate/ToBeMergedDialog";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "svnChangeList";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/integrate/ToBeMergedDialog";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toListMergeStatus";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelected";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlreadyMergedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addMoreLists";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshListStatus";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toListMergeStatus";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAlreadyMergedPaths";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "toggleInclusion";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$refreshListStatus$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyListCellRenderer
    implements TableCellRenderer {
        private final JPanel myPanel = new JPanel(new BorderLayout());
        private final CommittedChangeListRenderer myRenderer;
        private final JCheckBox myCheckBox = new JCheckBox();

        private MyListCellRenderer() {
            this.myCheckBox.setEnabled(true);
            this.myCheckBox.setSelected(true);
            this.myRenderer = new CommittedChangeListRenderer(ToBeMergedDialog.this.myMergeContext.getProject(), Collections.singletonList(list -> {
                ListMergeStatus status = ToBeMergedDialog.this.myAllStatusesCalculated ? ListMergeStatus.NOT_MERGED : (ListMergeStatus)((Object)((Object)ObjectUtils.notNull(ToBeMergedDialog.this.myStatusMap.get(list.getNumber()), (Object)((Object)ListMergeStatus.REFRESHING))));
                return status.getIcon();
            }));
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected) {
            this.myPanel.removeAll();
            this.myPanel.setBackground(null);
            this.myRenderer.clear();
            this.myRenderer.setBackground(null);
            if (value instanceof SvnChangeList) {
                SvnChangeList changeList = (SvnChangeList)value;
                this.myRenderer.renderChangeList((JComponent)table, (CommittedChangeList)changeList);
                Color bg = selected ? UIUtil.getTableSelectionBackground() : UIUtil.getTableBackground();
                Color fg = selected ? UIUtil.getTableSelectionForeground() : UIUtil.getTableForeground();
                this.myRenderer.setBackground(bg);
                this.myRenderer.setForeground(fg);
                this.myCheckBox.setBackground(bg);
                this.myCheckBox.setForeground(fg);
                this.myPanel.setBackground(bg);
                this.myPanel.setForeground(fg);
                this.myCheckBox.setSelected(ToBeMergedDialog.this.myWiseSelection.isSelected(changeList.getNumber()));
                this.myPanel.add((Component)this.myCheckBox, "West");
                this.myPanel.add((Component)this.myRenderer, "Center");
            }
        }

        @Override
        public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.customizeCellRenderer(table, value, isSelected);
            return this.myPanel;
        }
    }

    private class LoadChangeListsTask
    extends Task.Backgroundable {
        private final long myStartNumber;
        private final int myQuantity;
        private List<SvnChangeList> myLists;
        private boolean myIsLastListLoaded;

        public LoadChangeListsTask(long startNumber, int quantity) {
            super(ToBeMergedDialog.this.myMergeContext.getProject(), "Loading recent " + ToBeMergedDialog.this.myMergeContext.getBranchName() + " revisions", true);
            this.myStartNumber = startNumber;
            this.myQuantity = quantity;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                LoadChangeListsTask.$$$reportNull$$$0(0);
            }
            try {
                Pair<List<SvnChangeList>, Boolean> loadResult = MergeCalculatorTask.loadChangeLists(ToBeMergedDialog.this.myMergeContext, this.myStartNumber, MergeCalculatorTask.getBunchSize(this.myQuantity));
                this.myLists = (List)loadResult.first;
                this.myIsLastListLoaded = (Boolean)loadResult.second;
            }
            catch (VcsException e) {
                this.setEmptyData();
                PopupUtil.showBalloonForActiveComponent((String)e.getMessage(), (MessageType)MessageType.ERROR);
            }
        }

        public void onCancel() {
            this.setEmptyData();
            this.updateDialog();
        }

        public void onSuccess() {
            this.updateDialog();
        }

        private void setEmptyData() {
            this.myLists = ContainerUtilRt.emptyList();
            this.myIsLastListLoaded = false;
        }

        private void updateDialog() {
            ToBeMergedDialog.this.addMoreLists(this.myLists);
            if (this.myIsLastListLoaded) {
                ToBeMergedDialog.this.setAllListsLoaded();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/svn/integrate/ToBeMergedDialog$LoadChangeListsTask", "run"));
        }
    }

    private class MyUnselectAll
    extends DumbAwareAction {
        private MyUnselectAll() {
            super("Unselect All", "Unselect All", AllIcons.Actions.Unselectall);
        }

        public void actionPerformed(AnActionEvent e) {
            ToBeMergedDialog.this.myWiseSelection.clearAll();
            ToBeMergedDialog.this.myRevisionsList.repaint();
        }
    }

    private class MySelectAll
    extends DumbAwareAction {
        private MySelectAll() {
            super("Select All", "Select All", AllIcons.Actions.Selectall);
        }

        public void actionPerformed(AnActionEvent e) {
            ToBeMergedDialog.this.myWiseSelection.setAll();
            ToBeMergedDialog.this.myRevisionsList.repaint();
        }
    }

    private class MoreXAction
    extends MoreAction {
        private final int myQuantity;

        private MoreXAction(int quantity) {
            super("Load +" + quantity);
            this.myQuantity = quantity;
        }

        public void actionPerformed(AnActionEvent e) {
            ToBeMergedDialog.this.myMore500Action.setVisible(false);
            ToBeMergedDialog.this.myMore100Action.setEnabled(false);
            ToBeMergedDialog.this.myMore500Action.setEnabled(false);
            new LoadChangeListsTask(ToBeMergedDialog.this.getLastNumber(), this.myQuantity).queue();
        }
    }
}

