/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.formatter;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.YAMLTextUtil;

public class YAMLCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        int lineNumber;
        int lineStartOffset;
        if (file.getLanguage() != YAMLLanguage.INSTANCE) {
            String string = text;
            if (string == null) {
                YAMLCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        CaretModel caretModel = editor.getCaretModel();
        SelectionModel selectionModel = editor.getSelectionModel();
        Document document = editor.getDocument();
        int caretOffset = selectionModel.getSelectionStart() != selectionModel.getSelectionEnd() ? selectionModel.getSelectionStart() : caretModel.getOffset();
        int indent = caretOffset - (lineStartOffset = YAMLTextUtil.getLineStartSafeOffset(document, lineNumber = document.getLineNumber(caretOffset)));
        if (indent == 0) {
            String string = text;
            if (string == null) {
                YAMLCopyPasteProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = YAMLCopyPasteProcessor.indentText(text, StringUtil.repeatSymbol((char)' ', (int)indent));
        if (string == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String indentText(@NotNull String text, @NotNull String curLineIndent) {
        List lines;
        if (text == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(3);
        }
        if (curLineIndent == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(4);
        }
        if ((lines = LineTokenizer.tokenizeIntoList((CharSequence)text, (boolean)false, (boolean)false)).isEmpty()) {
            Logger.getInstance(YAMLCopyPasteProcessor.class).error(text.isEmpty() ? "Pasted empty text" : "Text '" + text + "' was converted into empty line list");
            String string = text;
            if (string == null) {
                YAMLCopyPasteProcessor.$$$reportNull$$$0(5);
            }
            return string;
        }
        int minIndent = YAMLCopyPasteProcessor.calculateMinBlockIndent(lines);
        String firstLine = (String)lines.iterator().next();
        if (lines.size() == 1) {
            String string = firstLine;
            if (string == null) {
                YAMLCopyPasteProcessor.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = firstLine.substring(YAMLTextUtil.getStartIndentSize(firstLine)) + "\n" + lines.stream().skip(1L).map(line -> {
            if (curLineIndent == null) {
                YAMLCopyPasteProcessor.$$$reportNull$$$0(10);
            }
            if (YAMLCopyPasteProcessor.isEmptyLine(line)) {
                return curLineIndent + line.substring(minIndent);
            }
            return "";
        }).reduce((left, right) -> left + "\n" + right).orElse("");
        if (string == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static int calculateMinBlockIndent(@NotNull List<String> list) {
        if (list == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(8);
        }
        Iterator<String> it = list.iterator();
        String str = "";
        while (it.hasNext() && !YAMLCopyPasteProcessor.isEmptyLine(str = it.next())) {
        }
        if (!it.hasNext()) {
            return 0;
        }
        int minIndent = YAMLTextUtil.getStartIndentSize(str);
        while (it.hasNext()) {
            str = it.next();
            if (!YAMLCopyPasteProcessor.isEmptyLine(str)) continue;
            minIndent = Math.min(minIndent, YAMLTextUtil.getStartIndentSize(str));
        }
        return minIndent;
    }

    private static boolean isEmptyLine(@NotNull String str) {
        if (str == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(9);
        }
        return YAMLTextUtil.getStartIndentSize(str) < str.length();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/formatter/YAMLCopyPasteProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curLineIndent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/formatter/YAMLCopyPasteProcessor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "indentText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "indentText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calculateMinBlockIndent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyLine";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$indentText$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

