/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.lang.folding.NamedFoldingDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingUpdate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.FoldingUpdate");
    static final Key<ParameterizedCachedValue<Runnable, Boolean>> CODE_FOLDING_KEY = Key.create((String)"code folding");
    private static final Key<String> CODE_FOLDING_FILE_EXTENSION_KEY = Key.create((String)"code folding file extension");
    private static final Key<Object> LAST_UPDATE_INJECTED_STAMP_KEY = Key.create((String)"LAST_UPDATE_INJECTED_STAMP_KEY");

    private FoldingUpdate() {
    }

    @Nullable
    static Runnable updateFoldRegions(@NotNull Editor editor, @NotNull PsiFile file2, boolean applyDefaultState, boolean quick) {
        String oldExtension;
        ParameterizedCachedValue value;
        if (editor == null) {
            FoldingUpdate.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            FoldingUpdate.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project = file2.getProject();
        Document document = editor.getDocument();
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)project).isUncommited(document));
        String currentFileExtension = null;
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile != null) {
            currentFileExtension = virtualFile.getExtension();
        }
        if ((value = (ParameterizedCachedValue)editor.getUserData(CODE_FOLDING_KEY)) != null && ((oldExtension = (String)editor.getUserData(CODE_FOLDING_FILE_EXTENSION_KEY)) == null ? currentFileExtension != null : !oldExtension.equals(currentFileExtension))) {
            value = null;
            editor.putUserData(CODE_FOLDING_KEY, null);
        }
        editor.putUserData(CODE_FOLDING_FILE_EXTENSION_KEY, (Object)currentFileExtension);
        if (value != null && value.hasUpToDateValue() && !applyDefaultState) {
            return (Runnable)value.getValue(null);
        }
        if (quick) {
            return (Runnable)FoldingUpdate.getUpdateResult(file2, document, true, project, editor, applyDefaultState).getValue();
        }
        return (Runnable)CachedValuesManager.getManager((Project)project).getParameterizedCachedValue((UserDataHolder)editor, CODE_FOLDING_KEY, param -> {
            if (editor == null) {
                FoldingUpdate.$$$reportNull$$$0(17);
            }
            Document document1 = editor.getDocument();
            PsiFile file1 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document1);
            return FoldingUpdate.getUpdateResult(file1, document1, false, project, editor, param);
        }, false, (Object)applyDefaultState);
    }

    private static CachedValueProvider.Result<Runnable> getUpdateResult(PsiFile file2, @NotNull Document document, boolean quick, Project project, Editor editor, boolean applyDefaultState) {
        if (document == null) {
            FoldingUpdate.$$$reportNull$$$0(2);
        }
        List<RegionInfo> elementsToFold = FoldingUpdate.getFoldingsFor(file2, document, quick);
        UpdateFoldRegionsOperation operation = new UpdateFoldRegionsOperation(project, editor, file2, elementsToFold, FoldingUpdate.applyDefaultStateMode(applyDefaultState), !applyDefaultState, false);
        long documentTimestamp = document.getModificationStamp();
        int documentLength = document.getTextLength();
        AtomicBoolean alreadyExecuted = new AtomicBoolean();
        Runnable runnable2 = () -> {
            if (alreadyExecuted.compareAndSet(false, true)) {
                if (documentTimestamp != editor.getDocument().getModificationStamp()) {
                    LOG.error("Document has changed since fold regions were calculated");
                } else if (documentLength != editor.getDocument().getTextLength()) {
                    LOG.error("Document length has changed since fold regions were calculated");
                }
                editor.getFoldingModel().runBatchFoldingOperationDoNotCollapseCaret((Runnable)operation);
            }
        };
        HashSet<Object> dependencies = new HashSet<Object>();
        dependencies.add(document);
        dependencies.add(editor.getFoldingModel());
        for (RegionInfo info : elementsToFold) {
            dependencies.addAll(info.descriptor.getDependencies());
        }
        return CachedValueProvider.Result.create((Object)runnable2, (Object[])ArrayUtil.toObjectArray(dependencies));
    }

    @NotNull
    private static UpdateFoldRegionsOperation.ApplyDefaultStateMode applyDefaultStateMode(boolean applyDefaultState) {
        UpdateFoldRegionsOperation.ApplyDefaultStateMode applyDefaultStateMode = applyDefaultState ? UpdateFoldRegionsOperation.ApplyDefaultStateMode.EXCEPT_CARET_REGION : UpdateFoldRegionsOperation.ApplyDefaultStateMode.NO;
        if (applyDefaultStateMode == null) {
            FoldingUpdate.$$$reportNull$$$0(3);
        }
        return applyDefaultStateMode;
    }

    @Nullable
    public static Runnable updateInjectedFoldRegions(@NotNull Editor editor, @NotNull PsiFile file2, boolean applyDefaultState) {
        if (editor == null) {
            FoldingUpdate.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            FoldingUpdate.$$$reportNull$$$0(5);
        }
        if (file2 instanceof PsiCompiledElement) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project = file2.getProject();
        Document document = editor.getDocument();
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)project).isUncommited(document));
        FoldingModel foldingModel = editor.getFoldingModel();
        long timeStamp = document.getModificationStamp();
        Object lastTimeStamp = editor.getUserData(LAST_UPDATE_INJECTED_STAMP_KEY);
        if (lastTimeStamp instanceof Long && (Long)lastTimeStamp == timeStamp) {
            return null;
        }
        List injectedDocuments = InjectedLanguageManager.getInstance((Project)project).getCachedInjectedDocumentsInRange(file2, file2.getTextRange());
        if (injectedDocuments.isEmpty()) {
            return null;
        }
        ArrayList injectedEditors = new ArrayList();
        ArrayList injectedFiles = new ArrayList();
        ArrayList lists = new ArrayList();
        for (DocumentWindow injectedDocument : injectedDocuments) {
            if (!injectedDocument.isValid()) continue;
            InjectedLanguageUtil.enumerate(injectedDocument, file2, (injectedFile, places) -> {
                if (editor == null) {
                    FoldingUpdate.$$$reportNull$$$0(16);
                }
                if (!injectedFile.isValid()) {
                    return;
                }
                Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
                if (!(injectedEditor instanceof EditorWindow)) {
                    return;
                }
                injectedEditors.add((EditorWindow)injectedEditor);
                injectedFiles.add(injectedFile);
                ArrayList map2 = new ArrayList();
                lists.add(map2);
                FoldingUpdate.getFoldingsFor(injectedFile, injectedEditor.getDocument(), map2, false);
            });
        }
        return () -> {
            if (editor == null) {
                FoldingUpdate.$$$reportNull$$$0(15);
            }
            ArrayList<UpdateFoldRegionsOperation> updateOperations = new ArrayList<UpdateFoldRegionsOperation>(injectedEditors.size());
            for (int i = 0; i < injectedEditors.size(); ++i) {
                EditorWindow injectedEditor = (EditorWindow)injectedEditors.get(i);
                PsiFile injectedFile = (PsiFile)injectedFiles.get(i);
                if (!injectedEditor.getDocument().isValid()) continue;
                List list2 = (List)lists.get(i);
                updateOperations.add(new UpdateFoldRegionsOperation(project, injectedEditor, injectedFile, list2, FoldingUpdate.applyDefaultStateMode(applyDefaultState), !applyDefaultState, true));
            }
            foldingModel.runBatchFoldingOperation(() -> {
                for (Runnable operation : updateOperations) {
                    operation.run();
                }
            });
            editor.putUserData(LAST_UPDATE_INJECTED_STAMP_KEY, (Object)timeStamp);
        };
    }

    public static boolean supportsDumbModeFolding(@NotNull Editor editor) {
        PsiFile file2;
        Project project;
        if (editor == null) {
            FoldingUpdate.$$$reportNull$$$0(6);
        }
        if ((project = editor.getProject()) != null && (file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null) {
            return FoldingUpdate.supportsDumbModeFolding(file2);
        }
        return true;
    }

    private static boolean supportsDumbModeFolding(@NotNull PsiFile file2) {
        if (file2 == null) {
            FoldingUpdate.$$$reportNull$$$0(7);
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        for (Language language : viewProvider.getLanguages()) {
            FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
            if (foldingBuilder == null || DumbService.isDumbAware((Object)foldingBuilder)) continue;
            return false;
        }
        return true;
    }

    static List<RegionInfo> getFoldingsFor(@NotNull PsiFile file2, @NotNull Document document, boolean quick) {
        if (file2 == null) {
            FoldingUpdate.$$$reportNull$$$0(8);
        }
        if (document == null) {
            FoldingUpdate.$$$reportNull$$$0(9);
        }
        if (file2 instanceof PsiCompiledFile) {
            file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile();
        }
        ArrayList<RegionInfo> foldingMap = new ArrayList<RegionInfo>();
        FoldingUpdate.getFoldingsFor(file2, document, foldingMap, quick);
        return foldingMap;
    }

    private static void getFoldingsFor(@NotNull PsiFile file2, @NotNull Document document, @NotNull List<? super RegionInfo> elementsToFold, boolean quick) {
        if (file2 == null) {
            FoldingUpdate.$$$reportNull$$$0(10);
        }
        if (document == null) {
            FoldingUpdate.$$$reportNull$$$0(11);
        }
        if (elementsToFold == null) {
            FoldingUpdate.$$$reportNull$$$0(12);
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        TextRange docRange = TextRange.from((int)0, (int)document.getTextLength());
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psi = viewProvider.getPsi(language);
            FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
            if (psi == null || foldingBuilder == null) continue;
            for (FoldingDescriptor descriptor2 : LanguageFolding.buildFoldingDescriptors((FoldingBuilder)foldingBuilder, (PsiElement)psi, (Document)document, (boolean)quick)) {
                PsiElement psiElement = descriptor2.getElement().getPsi();
                if (psiElement == null) {
                    LOG.error("No PSI for folding descriptor " + descriptor2);
                    continue;
                }
                if (!docRange.contains(descriptor2.getRange())) {
                    FoldingUpdate.diagnoseIncorrectRange(psi, document, language, foldingBuilder, descriptor2, psiElement);
                    continue;
                }
                RegionInfo regionInfo = new RegionInfo(descriptor2, psiElement, foldingBuilder);
                elementsToFold.add(regionInfo);
            }
        }
    }

    private static void diagnoseIncorrectRange(@NotNull PsiFile file2, @NotNull Document document, Language language, FoldingBuilder foldingBuilder, FoldingDescriptor descriptor2, PsiElement psiElement) {
        Attachment[] attachmentArray;
        if (file2 == null) {
            FoldingUpdate.$$$reportNull$$$0(13);
        }
        if (document == null) {
            FoldingUpdate.$$$reportNull$$$0(14);
        }
        String message = "Folding descriptor " + descriptor2 + " made by " + foldingBuilder + " for " + language + " is outside document range, PSI element: " + psiElement + ", PSI element range: " + psiElement.getTextRange() + "; " + DebugUtil.diagnosePsiDocumentInconsistency(psiElement, document);
        if (ApplicationManager.getApplication().isInternal()) {
            Attachment[] attachmentArray2 = new Attachment[2];
            attachmentArray2[0] = AttachmentFactory.createAttachment(document);
            attachmentArray = attachmentArray2;
            attachmentArray2[1] = new Attachment("psiTree.txt", DebugUtil.psiToString((PsiElement)file2, false, true));
        } else {
            attachmentArray = Attachment.EMPTY_ARRAY;
        }
        LOG.error(message, attachmentArray);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/FoldingUpdate";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToFold";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/FoldingUpdate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "applyDefaultStateMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateFoldRegions";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUpdateResult";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateInjectedFoldRegions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "supportsDumbModeFolding";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingsFor";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "diagnoseIncorrectRange";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateInjectedFoldRegions$4";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateInjectedFoldRegions$2";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateFoldRegions$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class RegionInfo {
        @NotNull
        final FoldingDescriptor descriptor;
        final PsiElement element;
        final String signature;
        final boolean collapsedByDefault;

        private RegionInfo(@NotNull FoldingDescriptor descriptor2, @NotNull PsiElement psiElement, @NotNull FoldingBuilder foldingBuilder) {
            if (descriptor2 == null) {
                RegionInfo.$$$reportNull$$$0(0);
            }
            if (psiElement == null) {
                RegionInfo.$$$reportNull$$$0(1);
            }
            if (foldingBuilder == null) {
                RegionInfo.$$$reportNull$$$0(2);
            }
            this.descriptor = descriptor2;
            this.element = psiElement;
            Boolean hardCoded = descriptor2 instanceof NamedFoldingDescriptor ? ((NamedFoldingDescriptor)descriptor2).isCollapsedByDefault() : null;
            this.collapsedByDefault = hardCoded == null ? FoldingPolicy.isCollapsedByDefault(psiElement, foldingBuilder) : hardCoded;
            this.signature = RegionInfo.createSignature(psiElement);
        }

        private static String createSignature(@NotNull PsiElement element) {
            PsiFile containingFile;
            PsiElement restoredElement;
            String signature;
            if (element == null) {
                RegionInfo.$$$reportNull$$$0(3);
            }
            if ((signature = FoldingPolicy.getSignature(element)) != null && Registry.is((String)"folding.signature.validation") && !element.equals(restoredElement = FoldingPolicy.restoreBySignature(containingFile = element.getContainingFile(), signature))) {
                StringBuilder trace = new StringBuilder();
                PsiElement restoredAgain = FoldingPolicy.restoreBySignature(containingFile, signature, trace);
                LOG.error("element: " + element + "(" + element.getText() + "); restoredElement: " + restoredElement + "; signature: '" + signature + "'; file: " + containingFile + "; injected: " + InjectedLanguageManager.getInstance((Project)element.getProject()).isInjectedFragment(containingFile) + "; languages: " + containingFile.getViewProvider().getLanguages() + "; restored again: " + restoredAgain + "; restore produces same results: " + (restoredAgain == restoredElement) + "; trace:\n" + trace);
            }
            return signature;
        }

        public String toString() {
            return this.descriptor + ", collapsedByDefault=" + this.collapsedByDefault;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foldingBuilder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/folding/impl/FoldingUpdate$RegionInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createSignature";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

