/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.settings;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.Option;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.SwingActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jdesktop.swingx.combobox.ListComboBoxModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterNameHintsConfigurable
extends DialogWrapper {
    private static final String LAST_EDITED_LANGUAGE_ID_KEY = "param.hints.settings.last.edited.language";
    private JPanel myConfigurable;
    private ComboBox<Language> myCurrentLanguageCombo;
    private Map<Language, EditorTextField> myEditors;
    private Map<Language, Boolean> myIsValidPatterns;
    private Map<Option, JBCheckBox> myOptions;
    private JPanel myPanel;
    private CardLayout myCardLayout;

    public ParameterNameHintsConfigurable() {
        this(null, null);
    }

    public ParameterNameHintsConfigurable(@Nullable Language selectedLanguage, @Nullable String newPreselectedPattern) {
        super(null);
        this.$$$setupUI$$$();
        this.setTitle("Configure Parameter Name Hints");
        this.init();
        if (selectedLanguage != null) {
            this.showLanguagePanel(selectedLanguage);
            this.myCurrentLanguageCombo.setSelectedItem((Object)selectedLanguage);
            if (newPreselectedPattern != null) {
                this.addSelectedText(selectedLanguage, newPreselectedPattern);
            }
        }
    }

    private void addSelectedText(@NotNull Language language, @NotNull String newPreselectedPattern) {
        if (language == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(0);
        }
        if (newPreselectedPattern == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(1);
        }
        EditorTextField textField2 = this.myEditors.get(language);
        String text2 = textField2.getText();
        int startOffset = text2.length();
        text2 = text2 + "\n" + newPreselectedPattern;
        int endOffset = text2.length();
        textField2.setText(text2);
        textField2.addSettingsProvider(editor -> {
            SelectionModel model = editor.getSelectionModel();
            model.setSelection(startOffset + 1, endOffset);
        });
    }

    private void updateOkEnabled(@NotNull Language language, @NotNull EditorTextField editorTextField) {
        if (language == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(2);
        }
        if (editorTextField == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(3);
        }
        String text2 = editorTextField.getText();
        List<Integer> invalidLines = HintUtilsKt.getBlackListInvalidLineNumbers(text2);
        this.myIsValidPatterns.put(language, invalidLines.isEmpty());
        boolean isEveryOneValid = !this.myIsValidPatterns.containsValue(false);
        this.getOKAction().setEnabled(isEveryOneValid);
        Editor editor = editorTextField.getEditor();
        if (editor != null) {
            ParameterNameHintsConfigurable.highlightErrorLines(invalidLines, editor);
        }
    }

    private static void highlightErrorLines(@NotNull List<Integer> lines2, @NotNull Editor editor) {
        if (lines2 == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(5);
        }
        TextAttributes attributes = editor.getColorsScheme().getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES);
        Document document = editor.getDocument();
        int totalLines = document.getLineCount();
        MarkupModel model = editor.getMarkupModel();
        model.removeAllHighlighters();
        lines2.stream().filter(current -> current < totalLines).forEach(line -> model.addLineHighlighter(line.intValue(), 5000, attributes));
    }

    protected void doOKAction() {
        this.myEditors.forEach((language, editor) -> {
            String blacklist = editor.getText();
            ParameterNameHintsConfigurable.storeBlackListDiff(language, blacklist);
        });
        this.myOptions.forEach((option, checkBox2) -> option.set(checkBox2.isSelected()));
        this.saveLastEditedLanguage();
        ParameterHintsPassFactory.forceHintsUpdateOnNextPass();
        super.doOKAction();
    }

    public void doCancelAction() {
        this.saveLastEditedLanguage();
        super.doCancelAction();
    }

    private void saveLastEditedLanguage() {
        Arrays.stream(this.myPanel.getComponents()).filter(Component::isVisible).findFirst().ifPresent(component -> ParameterNameHintsConfigurable.saveLastEditedLanguage(component.getName()));
    }

    private static void storeBlackListDiff(@NotNull Language language, @NotNull String text2) {
        if (language == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(6);
        }
        if (text2 == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(7);
        }
        Set updatedBlackList = StringUtil.split((String)text2, (String)"\n").stream().filter(e -> !e.trim().isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        Set defaultBlackList = provider.getDefaultBlackList();
        Diff diff = Diff.Builder.build(defaultBlackList, updatedBlackList);
        ParameterNameHintsSettings.getInstance().setBlackListDiff(language, diff);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myConfigurable;
    }

    private void createUIComponents() {
        this.myOptions = ContainerUtil.newHashMap();
        this.myEditors = ContainerUtil.newHashMap();
        this.myIsValidPatterns = ContainerUtil.newHashMap();
        List<Language> allLanguages = ParameterNameHintsConfigurable.getBaseLanguagesWithProviders();
        Language lastEditedLanguage = ParameterNameHintsConfigurable.lastEditedLanguage();
        Language selected = lastEditedLanguage != null ? lastEditedLanguage : allLanguages.get(0);
        this.initLanguageCombo(selected, allLanguages);
        this.myCardLayout = new CardLayout();
        this.myPanel = new JPanel(this.myCardLayout);
        allLanguages.forEach(language -> {
            JPanel panel2 = this.createLanguagePanel((Language)language);
            panel2.setName(language.getID());
            this.myPanel.add((Component)panel2, language.getID());
        });
        this.myCardLayout.show(this.myPanel, selected.getID());
    }

    @Nullable
    private static Language lastEditedLanguage() {
        String id = PropertiesComponent.getInstance().getValue(LAST_EDITED_LANGUAGE_ID_KEY);
        if (id == null) {
            return null;
        }
        return Language.findLanguageByID((String)id);
    }

    private static void saveLastEditedLanguage(@NotNull String id) {
        if (id == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(8);
        }
        PropertiesComponent.getInstance().setValue(LAST_EDITED_LANGUAGE_ID_KEY, id);
    }

    @NotNull
    private JPanel createLanguagePanel(@NotNull Language language) {
        if (language == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(9);
        }
        JPanel blacklistPanel = this.createBlacklistPanel(language);
        JPanel optionsPanel = this.createOptionsPanel(language);
        JPanel panel2 = new JPanel();
        BoxLayout layout = new BoxLayout(panel2, 1);
        panel2.setLayout(layout);
        if (blacklistPanel != null) {
            panel2.add(blacklistPanel);
        }
        if (optionsPanel != null) {
            panel2.add(optionsPanel);
        }
        JPanel jPanel = panel2;
        if (jPanel == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(10);
        }
        return jPanel;
    }

    @Nullable
    private JPanel createBlacklistPanel(final @NotNull Language language) {
        InlayParameterHintsProvider provider;
        if (language == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(11);
        }
        if (!(provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language)).isBlackListSupported()) {
            return null;
        }
        String blackList = ParameterNameHintsConfigurable.getLanguageBlackList(language);
        final EditorTextField editorTextField = ParameterNameHintsConfigurable.createBlacklistEditorField(blackList);
        editorTextField.addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                ParameterNameHintsConfigurable.this.updateOkEnabled(language, editorTextField);
            }
        });
        this.updateOkEnabled(language, editorTextField);
        this.myEditors.put(language, editorTextField);
        JPanel blacklistPanel = new JPanel();
        BoxLayout layout = new BoxLayout(blacklistPanel, 1);
        blacklistPanel.setLayout(layout);
        blacklistPanel.setBorder(IdeBorderFactory.createTitledBorder((String)"Blacklist"));
        JBLabel explanation = new JBLabel(ParameterNameHintsConfigurable.getBlacklistExplanationHTML(language));
        explanation.setAlignmentX(0.0f);
        blacklistPanel.add((Component)explanation);
        JComponent resetPanel = this.createResetPanel(language);
        resetPanel.setAlignmentX(0.0f);
        blacklistPanel.add(resetPanel);
        editorTextField.setAlignmentX(0.0f);
        blacklistPanel.add((Component)((Object)editorTextField));
        JBLabel label2 = ParameterNameHintsConfigurable.blacklistDependencyInfoLabel(language);
        if (label2 != null) {
            label2.setAlignmentX(0.0f);
            blacklistPanel.add((Component)label2);
        }
        return blacklistPanel;
    }

    @Nullable
    private static JBLabel blacklistDependencyInfoLabel(@NotNull Language language) {
        InlayParameterHintsProvider provider;
        Language dependencyLanguage;
        if (language == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(12);
        }
        if ((dependencyLanguage = (provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language)).getBlackListDependencyLanguage()) == null) {
            return null;
        }
        return new JBLabel("<html>Additionally <b>" + dependencyLanguage.getDisplayName() + "</b> language blacklist will be applied.</html>");
    }

    @NotNull
    private JComponent createResetPanel(final @NotNull Language language) {
        if (language == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(13);
        }
        SwingActionLink link = new SwingActionLink((Action)new AbstractAction("Reset"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterNameHintsConfigurable.this.setLanguageBlacklistToDefault(language);
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add((Component)link);
        Box box2 = box;
        if (box2 == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(14);
        }
        return box2;
    }

    private void setLanguageBlacklistToDefault(Language language) {
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        Set defaultBlacklist = provider.getDefaultBlackList();
        EditorTextField editor = this.myEditors.get(language);
        editor.setText(StringUtil.join((Collection)defaultBlacklist, (String)"\n"));
    }

    @NotNull
    private static String getBlacklistExplanationHTML(Language language) {
        InlayParameterHintsProvider hintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (hintsProvider == null) {
            String string = CodeInsightBundle.message((String)"inlay.hints.blacklist.pattern.explanation", (Object[])new Object[0]);
            if (string == null) {
                ParameterNameHintsConfigurable.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = hintsProvider.getBlacklistExplanationHTML();
        if (string == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    private JPanel createOptionsPanel(@NotNull Language language) {
        List<Option> options;
        if (language == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(17);
        }
        if ((options = ParameterNameHintsConfigurable.getOptions(language)).isEmpty()) {
            return null;
        }
        JPanel languageOptionsPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(languageOptionsPanel, 1);
        languageOptionsPanel.setLayout(boxLayout);
        if (!options.isEmpty()) {
            languageOptionsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)"Options"));
        }
        for (Option option : options) {
            JBCheckBox box = new JBCheckBox(option.getName(), option.get());
            this.myOptions.put(option, box);
            languageOptionsPanel.add((Component)box);
        }
        return languageOptionsPanel;
    }

    private void initLanguageCombo(Language selected, List<Language> languages) {
        ListComboBoxModel model = new ListComboBoxModel(languages);
        this.myCurrentLanguageCombo = new ComboBox((ComboBoxModel)model);
        this.myCurrentLanguageCombo.setSelectedItem((Object)selected);
        this.myCurrentLanguageCombo.setRenderer((ListCellRenderer)new ListCellRendererWrapper<Language>(){

            public void customize(JList list2, Language value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getDisplayName());
            }
        });
        this.myCurrentLanguageCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Language language = (Language)e.getItem();
                if (e.getStateChange() == 1) {
                    ParameterNameHintsConfigurable.this.showLanguagePanel(language);
                }
            }
        });
    }

    private void showLanguagePanel(@NotNull Language language) {
        if (language == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(18);
        }
        this.myCardLayout.show(this.myPanel, language.getID());
    }

    private static List<Option> getOptions(Language language) {
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (provider != null) {
            return provider.getSupportedOptions();
        }
        return ContainerUtil.emptyList();
    }

    @NotNull
    private static String getLanguageBlackList(@NotNull Language language) {
        InlayParameterHintsProvider hintsProvider;
        if (language == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(19);
        }
        if ((hintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language)) == null) {
            if ("" == null) {
                ParameterNameHintsConfigurable.$$$reportNull$$$0(20);
            }
            return "";
        }
        Diff diff = ParameterNameHintsSettings.getInstance().getBlackListDiff(language);
        Set blackList = diff.applyOn(hintsProvider.getDefaultBlackList());
        String string = StringUtil.join((Collection)blackList, (String)"\n");
        if (string == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private static List<Language> getBaseLanguagesWithProviders() {
        List<Language> list2 = HintUtilsKt.getHintProviders().stream().map(langWithImplementation -> (Language)langWithImplementation.getFirst()).sorted(Comparator.comparing(l -> l.getDisplayName())).collect(Collectors.toList());
        if (list2 == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(22);
        }
        return list2;
    }

    @NotNull
    private static EditorTextField createBlacklistEditorField(@NotNull String text2) {
        if (text2 == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(23);
        }
        Document document = EditorFactory.getInstance().createDocument((CharSequence)text2);
        EditorTextField field = new EditorTextField(document, null, (FileType)FileTypes.PLAIN_TEXT, false, false);
        field.setPreferredSize(new Dimension(200, 350));
        field.addSettingsProvider(editor -> {
            if (text2 == null) {
                ParameterNameHintsConfigurable.$$$reportNull$$$0(25);
            }
            editor.setVerticalScrollbarVisible(true);
            editor.setHorizontalScrollbarVisible(true);
            editor.getSettings().setAdditionalLinesCount(2);
            ParameterNameHintsConfigurable.highlightErrorLines(HintUtilsKt.getBlackListInvalidLineNumbers(text2), editor);
        });
        EditorTextField editorTextField = field;
        if (editorTextField == null) {
            ParameterNameHintsConfigurable.$$$reportNull$$$0(24);
        }
        return editorTextField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPreselectedPattern";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorTextField";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hints/settings/ParameterNameHintsConfigurable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createLanguagePanel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createResetPanel";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlacklistExplanationHTML";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageBlackList";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguagesWithProviders";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createBlacklistEditorField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addSelectedText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateOkEnabled";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "highlightErrorLines";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "storeBlackListDiff";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "saveLastEditedLanguage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createLanguagePanel";
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createBlacklistPanel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "blacklistDependencyInfoLabel";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createResetPanel";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createOptionsPanel";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showLanguagePanel";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageBlackList";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createBlacklistEditorField";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createBlacklistEditorField$10";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myConfigurable = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = this.myPanel;
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        ComboBox<Language> comboBox = this.myCurrentLanguageCombo;
        jPanel4.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Language:");
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myConfigurable;
    }
}

