/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.util.SequentialTask;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PerformFixesModalTask
implements SequentialTask {
    @NotNull
    protected final Project myProject;
    private final List<CommonProblemDescriptor[]> myDescriptorPacks;
    private final PsiDocumentManager myDocumentManager;
    private final PostprocessReformattingAspect myReformattingAspect;
    private final int myLength;
    private int myProcessed;
    private int myPackIdx;
    private int myDescriptorIdx;

    protected PerformFixesModalTask(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors) {
        if (project == null) {
            PerformFixesModalTask.$$$reportNull$$$0(0);
        }
        if (descriptors == null) {
            PerformFixesModalTask.$$$reportNull$$$0(1);
        }
        this(project, Collections.singletonList(descriptors));
    }

    protected PerformFixesModalTask(@NotNull Project project, @NotNull List<CommonProblemDescriptor[]> descriptorPacks) {
        if (project == null) {
            PerformFixesModalTask.$$$reportNull$$$0(2);
        }
        if (descriptorPacks == null) {
            PerformFixesModalTask.$$$reportNull$$$0(3);
        }
        this.myProcessed = 0;
        this.myPackIdx = 0;
        this.myDescriptorIdx = 0;
        this.myProject = project;
        this.myDescriptorPacks = descriptorPacks;
        this.myLength = descriptorPacks.stream().mapToInt(ds -> ((CommonProblemDescriptor[])ds).length).sum();
        this.myDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        this.myReformattingAspect = PostprocessReformattingAspect.getInstance(this.myProject);
    }

    public void prepare() {
    }

    public boolean isDone() {
        return this.myPackIdx > this.myDescriptorPacks.size() - 1;
    }

    public boolean iteration() {
        return true;
    }

    public void doRun(ProgressIndicator indicator) {
        indicator.setIndeterminate(false);
        while (!this.isDone() && !indicator.isCanceled()) {
            this.iteration(indicator);
        }
    }

    public boolean iteration(ProgressIndicator indicator) {
        Pair<CommonProblemDescriptor, Boolean> pair = this.nextDescriptor();
        CommonProblemDescriptor descriptor2 = (CommonProblemDescriptor)pair.getFirst();
        boolean shouldDoPostponedOperations = (Boolean)pair.getSecond();
        if (indicator != null) {
            PsiElement psiElement;
            indicator.setFraction((double)this.myProcessed++ / (double)this.myLength);
            String presentableText2 = "usages";
            if (descriptor2 instanceof ProblemDescriptor && (psiElement = ((ProblemDescriptor)descriptor2).getPsiElement()) != null) {
                presentableText2 = SymbolPresentationUtil.getSymbolPresentableText(psiElement);
            }
            indicator.setText("Processing " + presentableText2);
        }
        boolean[] runInReadAction = new boolean[]{false};
        QuickFix[] fixes = descriptor2.getFixes();
        if (fixes != null) {
            for (QuickFix fix : fixes) {
                if (fix.startInWriteAction()) {
                    runInReadAction[0] = false;
                    break;
                }
                runInReadAction[0] = true;
            }
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.myDocumentManager.commitAllDocuments();
            if (!runInReadAction[0]) {
                this.applyFix(this.myProject, descriptor2);
                if (shouldDoPostponedOperations) {
                    this.myReformattingAspect.doPostponedFormatting();
                }
            }
        });
        if (runInReadAction[0]) {
            this.applyFix(this.myProject, descriptor2);
        }
        return this.isDone();
    }

    public void stop() {
    }

    protected abstract void applyFix(Project var1, CommonProblemDescriptor var2);

    private Pair<CommonProblemDescriptor, Boolean> nextDescriptor() {
        CommonProblemDescriptor[] descriptors = this.myDescriptorPacks.get(this.myPackIdx);
        CommonProblemDescriptor descriptor2 = descriptors[this.myDescriptorIdx++];
        boolean shouldDoPostponedOperations = false;
        if (this.myDescriptorIdx == descriptors.length) {
            shouldDoPostponedOperations = true;
            ++this.myPackIdx;
            this.myDescriptorIdx = 0;
        }
        return Pair.create((Object)descriptor2, (Object)shouldDoPostponedOperations);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptorPacks";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/ex/PerformFixesModalTask";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

