/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.EditXmxVMOptionDialog;
import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.featureStatistics.fusCollectors.AppLifecycleUsageTriggerCollector;
import com.intellij.ide.IdeBundle;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.FUSApplicationUsageTrigger;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.util.LowMemoryWatcher;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class LowMemoryNotifier
implements ApplicationComponent {
    private final LowMemoryWatcher myWatcher = LowMemoryWatcher.register(this::onLowMemorySignalReceived, (LowMemoryWatcher.LowMemoryWatcherType)LowMemoryWatcher.LowMemoryWatcherType.ONLY_AFTER_GC);
    private final AtomicBoolean myNotificationShown = new AtomicBoolean();

    public void initComponent() {
        IdePerformanceListener.Adapter handler2 = new IdePerformanceListener.Adapter(){

            public void uiFreezeFinished(int lengthInSeconds) {
                FUSApplicationUsageTrigger.getInstance().trigger(AppLifecycleUsageTriggerCollector.class, "ide.freeze." + lengthInSeconds);
                FeatureUsageLogger.INSTANCE.log("lifecycle", "ide.freeze", Collections.singletonMap("durationSeconds", lengthInSeconds));
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(IdePerformanceListener.TOPIC, (Object)handler2);
    }

    private void onLowMemorySignalReceived() {
        if (this.myNotificationShown.compareAndSet(false, true)) {
            Notification notification2 = new Notification(IdeBundle.message((String)"low.memory.notification.title", (Object[])new Object[0]), IdeBundle.message((String)"low.memory.notification.title", (Object[])new Object[0]), IdeBundle.message((String)"low.memory.notification.content", (Object[])new Object[0]), NotificationType.WARNING);
            notification2.addAction((AnAction)new NotificationAction(IdeBundle.message((String)"low.memory.notification.action", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (notification2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    Runtime rt = Runtime.getRuntime();
                    new EditXmxVMOptionDialog(rt.freeMemory(), rt.maxMemory()).show();
                    notification2.expire();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/diagnostic/LowMemoryNotifier$2";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            Notifications.Bus.notify((Notification)notification2);
        }
    }

    public void disposeComponent() {
        this.myWatcher.stop();
    }
}

