/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.DiffExtension;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffTool;
import com.intellij.diff.FocusableContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.actions.impl.NextChangeAction;
import com.intellij.diff.actions.impl.NextDifferenceAction;
import com.intellij.diff.actions.impl.OpenInEditorAction;
import com.intellij.diff.actions.impl.PrevChangeAction;
import com.intellij.diff.actions.impl.PrevDifferenceAction;
import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.impl.DiffViewerWrapper;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.tools.ErrorDiffTool;
import com.intellij.diff.tools.external.ExternalDiffTool;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.mac.UpdatableDefaultActionGroup;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffRequestProcessor
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DiffRequestProcessor.class);
    private boolean myDisposed;
    @Nullable
    private final Project myProject;
    @NotNull
    private final DiffContext myContext;
    @NotNull
    private final DiffSettingsHolder.DiffSettings mySettings;
    @NotNull
    private final List<DiffTool> myAvailableTools;
    @NotNull
    private final List<DiffTool> myToolOrder;
    @Nullable
    private final DiffTool myForcedDiffTool;
    @NotNull
    private final DefaultActionGroup myToolbarGroup;
    @NotNull
    private final DefaultActionGroup myPopupActionGroup;
    @NotNull
    private final UpdatableDefaultActionGroup myTouchbarActionGroup;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final MyPanel myMainPanel;
    @NotNull
    protected final Wrapper myContentPanel;
    @NotNull
    private final ActionToolbar myToolbar;
    @NotNull
    protected final Wrapper myToolbarWrapper;
    @NotNull
    private final Wrapper myToolbarStatusPanel;
    @NotNull
    private final MyProgressBar myProgressBar;
    @NotNull
    private DiffRequest myActiveRequest;
    @NotNull
    private ViewerState myState;
    @Nullable
    private ApplyData myQueuedApplyRequest;
    @NotNull
    private IterationState myIterationState;

    public DiffRequestProcessor(@Nullable Project project) {
        this(project, (UserDataHolder)new UserDataHolderBase());
    }

    public DiffRequestProcessor(@Nullable Project project, @NotNull String place) {
        if (place == null) {
            DiffRequestProcessor.$$$reportNull$$$0(0);
        }
        this(project, (UserDataHolder)DiffUtil.createUserDataHolder(DiffUserDataKeys.PLACE, place));
    }

    public DiffRequestProcessor(@Nullable Project project, @NotNull UserDataHolder context) {
        if (context == null) {
            DiffRequestProcessor.$$$reportNull$$$0(1);
        }
        this.myIterationState = IterationState.NONE;
        this.myProject = project;
        this.myContext = new MyDiffContext(context);
        this.myActiveRequest = new LoadingDiffRequest();
        this.mySettings = DiffSettingsHolder.DiffSettings.getSettings((String)this.myContext.getUserData(DiffUserDataKeys.PLACE));
        this.myForcedDiffTool = (DiffTool)this.myContext.getUserData(DiffUserDataKeysEx.FORCE_DIFF_TOOL);
        this.myAvailableTools = DiffManagerEx.getInstance().getDiffTools();
        this.myToolOrder = new ArrayList<DiffTool>(this.getToolOrderFromSettings(this.myAvailableTools));
        this.myToolbarGroup = new DefaultActionGroup();
        this.myPopupActionGroup = new DefaultActionGroup();
        this.myTouchbarActionGroup = new UpdatableDefaultActionGroup();
        TouchbarDataKeys.putActionDescriptor((AnAction)this.myTouchbarActionGroup).setReplaceEsc(false);
        this.myMainPanel = new MyPanel();
        this.myContentPanel = new Wrapper();
        this.myToolbarStatusPanel = new Wrapper();
        this.myProgressBar = new MyProgressBar();
        this.myToolbar = ActionManager.getInstance().createActionToolbar("DiffToolbar", (ActionGroup)this.myToolbarGroup, true);
        this.myToolbar.setTargetComponent((JComponent)((Object)this.myMainPanel));
        this.myToolbarWrapper = new Wrapper(this.myToolbar.getComponent());
        this.myPanel = JBUI.Panels.simplePanel((Component)((Object)this.myMainPanel));
        BorderLayoutPanel statusPanel = JBUI.Panels.simplePanel((Component)this.myToolbarStatusPanel).addToLeft((Component)this.myProgressBar);
        BorderLayoutPanel topPanel = JBUI.Panels.simplePanel((Component)this.myToolbarWrapper).addToRight((Component)statusPanel);
        JBSplitter bottomContentSplitter = new JBSplitter(true, "DiffRequestProcessor.BottomComponentSplitter", 0.8f);
        bottomContentSplitter.setFirstComponent((JComponent)this.myContentPanel);
        this.myMainPanel.add((Component)topPanel, "North");
        this.myMainPanel.add((Component)bottomContentSplitter, "Center");
        this.myMainPanel.setFocusTraversalPolicyProvider(true);
        this.myMainPanel.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        JComponent bottomPanel = (JComponent)this.myContext.getUserData(DiffUserDataKeysEx.BOTTOM_PANEL);
        if (bottomPanel != null) {
            bottomContentSplitter.setSecondComponent(bottomPanel);
        }
        if (bottomPanel instanceof Disposable) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)bottomPanel));
        }
        this.myState = EmptyState.INSTANCE;
        this.myContentPanel.setContent((JComponent)DiffUtil.createMessagePanel(((LoadingDiffRequest)this.myActiveRequest).getMessage()));
    }

    protected void reloadRequest() {
        this.updateRequest(true);
    }

    public void updateRequest() {
        this.updateRequest(false);
    }

    public void updateRequest(boolean force) {
        this.updateRequest(force, null);
    }

    public abstract void updateRequest(boolean var1, @Nullable DiffUserDataKeysEx.ScrollToPolicy var2);

    @NotNull
    private FrameDiffTool getFittedTool(boolean applySubstitutor) {
        FrameDiffTool substitutor;
        ErrorDiffTool tool;
        if (this.myForcedDiffTool instanceof FrameDiffTool) {
            ErrorDiffTool errorDiffTool = this.myForcedDiffTool.canShow(this.myContext, this.myActiveRequest) ? (FrameDiffTool)this.myForcedDiffTool : ErrorDiffTool.INSTANCE;
            if (errorDiffTool == null) {
                DiffRequestProcessor.$$$reportNull$$$0(2);
            }
            return errorDiffTool;
        }
        List<FrameDiffTool> tools = this.filterFittedTools(this.myToolOrder);
        ErrorDiffTool errorDiffTool = tool = tools.isEmpty() ? ErrorDiffTool.INSTANCE : tools.get(0);
        if (applySubstitutor && (substitutor = this.findToolSubstitutor((DiffTool)tool)) != null) {
            FrameDiffTool frameDiffTool = substitutor;
            if (frameDiffTool == null) {
                DiffRequestProcessor.$$$reportNull$$$0(3);
            }
            return frameDiffTool;
        }
        ErrorDiffTool errorDiffTool2 = tool;
        if (errorDiffTool2 == null) {
            DiffRequestProcessor.$$$reportNull$$$0(4);
        }
        return errorDiffTool2;
    }

    @NotNull
    private List<FrameDiffTool> getAvailableFittedTools() {
        List<FrameDiffTool> list2 = this.filterFittedTools(this.myAvailableTools);
        if (list2 == null) {
            DiffRequestProcessor.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    private List<FrameDiffTool> filterFittedTools(@NotNull List<DiffTool> tools) {
        if (tools == null) {
            DiffRequestProcessor.$$$reportNull$$$0(6);
        }
        ArrayList<FrameDiffTool> result2 = new ArrayList<FrameDiffTool>();
        for (DiffTool tool : tools) {
            try {
                if (!(tool instanceof FrameDiffTool)) continue;
                if (tool.canShow(this.myContext, this.myActiveRequest)) {
                    result2.add((FrameDiffTool)tool);
                    continue;
                }
                FrameDiffTool substitutor = this.findToolSubstitutor(tool);
                if (substitutor == null) continue;
                result2.add((FrameDiffTool)tool);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        List<FrameDiffTool> list2 = DiffUtil.filterSuppressedTools(result2);
        if (list2 == null) {
            DiffRequestProcessor.$$$reportNull$$$0(7);
        }
        return list2;
    }

    private FrameDiffTool findToolSubstitutor(@NotNull DiffTool tool) {
        DiffTool substitutor;
        if (tool == null) {
            DiffRequestProcessor.$$$reportNull$$$0(8);
        }
        return (substitutor = DiffUtil.findToolSubstitutor(tool, this.myContext, this.myActiveRequest)) instanceof FrameDiffTool ? (FrameDiffTool)substitutor : null;
    }

    private void moveToolOnTop(@NotNull DiffTool tool) {
        int index;
        if (tool == null) {
            DiffRequestProcessor.$$$reportNull$$$0(9);
        }
        this.myToolOrder.remove(tool);
        FrameDiffTool toolToReplace = this.getFittedTool(false);
        for (index = 0; index < this.myToolOrder.size() && this.myToolOrder.get(index) != toolToReplace; ++index) {
        }
        this.myToolOrder.add(index, tool);
        this.updateToolOrderSettings(this.myToolOrder);
    }

    @NotNull
    private ViewerState createState() {
        FrameDiffTool frameTool = this.getFittedTool(true);
        FrameDiffTool.DiffViewer viewer = frameTool.createComponent(this.myContext, this.myActiveRequest);
        for (DiffExtension extension : (DiffExtension[])DiffExtension.EP_NAME.getExtensions()) {
            try {
                extension.onViewerCreated(viewer, this.myContext, this.myActiveRequest);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        DiffViewerWrapper wrapper2 = (DiffViewerWrapper)this.myActiveRequest.getUserData(DiffViewerWrapper.KEY);
        if (wrapper2 == null) {
            DefaultState defaultState = new DefaultState(viewer, frameTool);
            if (defaultState == null) {
                DiffRequestProcessor.$$$reportNull$$$0(10);
            }
            return defaultState;
        }
        WrapperState wrapperState = new WrapperState(viewer, frameTool, wrapper2);
        if (wrapperState == null) {
            DiffRequestProcessor.$$$reportNull$$$0(11);
        }
        return wrapperState;
    }

    protected void applyRequest(@NotNull DiffRequest request, boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        if (request == null) {
            DiffRequestProcessor.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myIterationState = IterationState.NONE;
        force = force || this.myQueuedApplyRequest != null && this.myQueuedApplyRequest.force;
        this.myQueuedApplyRequest = new ApplyData(request, force, scrollToChangePolicy);
        IdeFocusManager.getInstance((Project)this.myProject).doWhenFocusSettlesDown(() -> {
            if (this.myQueuedApplyRequest == null || this.myDisposed) {
                return;
            }
            this.doApplyRequest(this.myQueuedApplyRequest.request, this.myQueuedApplyRequest.force, this.myQueuedApplyRequest.scrollToChangePolicy);
            this.myQueuedApplyRequest = null;
        }, ModalityState.current());
    }

    private void doApplyRequest(@NotNull DiffRequest request, boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        if (request == null) {
            DiffRequestProcessor.$$$reportNull$$$0(13);
        }
        if (!force && request == this.myActiveRequest) {
            return;
        }
        request.putUserData(DiffUserDataKeysEx.SCROLL_TO_CHANGE, (Object)scrollToChangePolicy);
        DiffUtil.runPreservingFocus((FocusableContext)this.myContext, () -> {
            if (request == null) {
                DiffRequestProcessor.$$$reportNull$$$0(29);
            }
            this.myState.destroy();
            this.myToolbarStatusPanel.setContent(null);
            this.myContentPanel.setContent(null);
            this.myToolbarGroup.removeAll();
            this.myPopupActionGroup.removeAll();
            ActionUtil.clearActions((JComponent)((Object)this.myMainPanel));
            this.myActiveRequest.onAssigned(false);
            this.myActiveRequest = request;
            this.myActiveRequest.onAssigned(true);
            try {
                this.myState = this.createState();
                this.myState.init();
            }
            catch (Throwable e) {
                LOG.error(e);
                this.myState = new ErrorState(this, (MessageDiffRequest)new ErrorDiffRequest(DiffBundle.message((String)"error.cant.show.diff.message", (Object[])new Object[0])), (DiffTool)this.getFittedTool(true));
                this.myState.init();
            }
        });
    }

    protected void setWindowTitle(@NotNull String title) {
        if (title == null) {
            DiffRequestProcessor.$$$reportNull$$$0(14);
        }
    }

    protected void onAfterNavigate() {
    }

    protected void onDispose() {
    }

    @Nullable
    public <T> T getContextUserData(@NotNull Key<T> key) {
        if (key == null) {
            DiffRequestProcessor.$$$reportNull$$$0(15);
        }
        return (T)this.myContext.getUserData(key);
    }

    public <T> void putContextUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            DiffRequestProcessor.$$$reportNull$$$0(16);
        }
        this.myContext.putUserData(key, value);
    }

    @NotNull
    protected List<AnAction> getNavigationActions() {
        List list2 = ContainerUtil.list((Object[])new AnAction[]{new MyPrevDifferenceAction(), new MyNextDifferenceAction(), new MyOpenInEditorAction(), Separator.getInstance(), new MyPrevChangeAction(), new MyNextChangeAction()});
        if (list2 == null) {
            DiffRequestProcessor.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @NotNull
    private List<AnAction> getTouchbarActions() {
        DefaultActionGroup left = new DefaultActionGroup(new AnAction[]{new MyPrevDifferenceAction(), new MyNextDifferenceAction()});
        DefaultActionGroup main = new DefaultActionGroup(new AnAction[]{new MyPrevChangeAction(), new MyNextChangeAction()});
        TouchbarDataKeys.putActionDescriptor((AnAction)main).setShowText(true).setShowImage(false).setMainGroup(true);
        List list2 = ContainerUtil.list((Object[])new AnAction[]{left, main});
        if (list2 == null) {
            DiffRequestProcessor.$$$reportNull$$$0(18);
        }
        return list2;
    }

    protected boolean isWindowFocused() {
        Window window = SwingUtilities.getWindowAncestor(this.myPanel);
        return window != null && window.isFocused();
    }

    private boolean isFocusedInWindow() {
        return DiffUtil.isFocusedComponentInWindow((Component)this.myContentPanel) || DiffUtil.isFocusedComponentInWindow(this.myToolbar.getComponent());
    }

    private void requestFocusInWindow() {
        DiffUtil.requestFocusInWindow(this.getPreferredFocusedComponent());
    }

    @NotNull
    protected List<DiffTool> getToolOrderFromSettings(@NotNull List<DiffTool> availableTools) {
        if (availableTools == null) {
            DiffRequestProcessor.$$$reportNull$$$0(19);
        }
        ArrayList<DiffTool> result2 = new ArrayList<DiffTool>();
        List<String> savedOrder = this.getSettings().getDiffToolsOrder();
        for (String clazz : savedOrder) {
            DiffTool tool = (DiffTool)ContainerUtil.find(availableTools, t -> t.getClass().getCanonicalName().equals(clazz));
            if (tool == null) continue;
            result2.add(tool);
        }
        for (DiffTool tool : availableTools) {
            if (result2.contains(tool)) continue;
            result2.add(tool);
        }
        ArrayList<DiffTool> arrayList = result2;
        if (arrayList == null) {
            DiffRequestProcessor.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    protected void updateToolOrderSettings(@NotNull List<DiffTool> toolOrder) {
        if (toolOrder == null) {
            DiffRequestProcessor.$$$reportNull$$$0(21);
        }
        ArrayList<String> savedOrder = new ArrayList<String>();
        for (DiffTool tool : toolOrder) {
            savedOrder.add(tool.getClass().getCanonicalName());
        }
        this.getSettings().setDiffToolsOrder(savedOrder);
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myDisposed = true;
            this.onDispose();
            this.myState.destroy();
            this.myToolbarStatusPanel.setContent(null);
            this.myContentPanel.setContent(null);
            this.myToolbarGroup.removeAll();
            this.myPopupActionGroup.removeAll();
            ActionUtil.clearActions((JComponent)((Object)this.myMainPanel));
            this.myActiveRequest.onAssigned(false);
            this.myState = EmptyState.INSTANCE;
            this.myActiveRequest = NoDiffRequest.INSTANCE;
        });
    }

    protected void collectToolbarActions(@Nullable List<AnAction> viewerActions) {
        this.myToolbarGroup.removeAll();
        ArrayList<AnAction> navigationActions = new ArrayList<AnAction>(this.getNavigationActions());
        navigationActions.add((AnAction)new MyChangeDiffToolAction());
        DiffUtil.addActionBlock(this.myToolbarGroup, navigationActions);
        DiffUtil.addActionBlock(this.myToolbarGroup, viewerActions);
        List requestContextActions = (List)this.myActiveRequest.getUserData(DiffUserDataKeys.CONTEXT_ACTIONS);
        DiffUtil.addActionBlock(this.myToolbarGroup, requestContextActions);
        List contextActions = (List)this.myContext.getUserData(DiffUserDataKeys.CONTEXT_ACTIONS);
        DiffUtil.addActionBlock(this.myToolbarGroup, contextActions);
        DiffUtil.addActionBlock(this.myToolbarGroup, new AnAction[]{new ShowInExternalToolAction(), ActionManager.getInstance().getAction("ContextHelp")});
        this.myTouchbarActionGroup.replaceAll(this.getTouchbarActions());
    }

    protected void collectPopupActions(@Nullable List<AnAction> viewerActions) {
        this.myPopupActionGroup.removeAll();
        ArrayList<DiffToolToggleAction> selectToolActions = new ArrayList<DiffToolToggleAction>();
        for (DiffTool diffTool : this.getAvailableFittedTools()) {
            FrameDiffTool substitutor = this.findToolSubstitutor(diffTool);
            if (diffTool == this.myState.getActiveTool() || substitutor == this.myState.getActiveTool()) continue;
            selectToolActions.add(new DiffToolToggleAction(diffTool));
        }
        DiffUtil.addActionBlock(this.myPopupActionGroup, selectToolActions);
        DiffUtil.addActionBlock(this.myPopupActionGroup, viewerActions);
    }

    protected void buildToolbar(@Nullable List<AnAction> viewerActions) {
        this.collectToolbarActions(viewerActions);
        ((ActionToolbarImpl)this.myToolbar).clearPresentationCache();
        this.myToolbar.updateActionsImmediately();
        ActionUtil.recursiveRegisterShortcutSet((ActionGroup)this.myToolbarGroup, (JComponent)((Object)this.myMainPanel), null);
    }

    protected void buildActionPopup(@Nullable List<AnAction> viewerActions) {
        this.collectPopupActions(viewerActions);
        DiffUtil.registerAction((AnAction)new ShowActionGroupPopupAction(), (JComponent)((Object)this.myMainPanel));
    }

    private void setTitle(@Nullable String title) {
        if (this.getContextUserData(DiffUserDataKeys.DO_NOT_CHANGE_WINDOW_TITLE) == Boolean.TRUE) {
            return;
        }
        if (title == null) {
            title = "Diff";
        }
        this.setWindowTitle(title);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            DiffRequestProcessor.$$$reportNull$$$0(22);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        JComponent component = this.myState.getPreferredFocusedComponent();
        return component != null && component.isShowing() && component.isFocusable() ? component : this.myToolbar.getComponent();
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public DiffContext getContext() {
        DiffContext diffContext = this.myContext;
        if (diffContext == null) {
            DiffRequestProcessor.$$$reportNull$$$0(23);
        }
        return diffContext;
    }

    @NotNull
    protected DiffSettingsHolder.DiffSettings getSettings() {
        DiffSettingsHolder.DiffSettings diffSettings = this.mySettings;
        if (diffSettings == null) {
            DiffRequestProcessor.$$$reportNull$$$0(24);
        }
        return diffSettings;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    protected boolean hasNextChange() {
        return false;
    }

    protected boolean hasPrevChange() {
        return false;
    }

    protected void goToNextChange(boolean fromDifferences) {
    }

    protected void goToPrevChange(boolean fromDifferences) {
    }

    protected boolean isNavigationEnabled() {
        return false;
    }

    private void notifyMessage(@NotNull AnActionEvent e, boolean next) {
        if (e == null) {
            DiffRequestProcessor.$$$reportNull$$$0(25);
        }
        Editor editor = (Editor)e.getData(DiffDataKeys.CURRENT_EDITOR);
        String message = DiffUtil.createNotificationText(next ? "Press again to go to the next file" : "Press again to go to the previous file", "You can disable this feature in " + DiffUtil.getSettingsConfigurablePath());
        LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel(message));
        Point point = new Point(this.myContentPanel.getWidth() / 2, next ? this.myContentPanel.getHeight() - JBUI.scale((int)40) : JBUI.scale((int)40));
        if (editor == null) {
            Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            HintHint hintHint = DiffRequestProcessor.createNotifyHint((JComponent)this.myContentPanel, point, next);
            hint.show((JComponent)this.myContentPanel, point.x, point.y, owner instanceof JComponent ? (JComponent)owner : null, hintHint);
        } else {
            int x = SwingUtilities.convertPoint((Component)this.myContentPanel, (Point)point, (Component)editor.getComponent()).x;
            JComponent header = editor.getHeaderComponent();
            int shift = editor.getScrollingModel().getVerticalScrollOffset() - (header != null ? header.getHeight() : 0);
            LineRange changeRange = (LineRange)e.getData(DiffDataKeys.CURRENT_CHANGE_RANGE);
            LogicalPosition position = changeRange == null ? new LogicalPosition(editor.getCaretModel().getLogicalPosition().line + (next ? 1 : 0), 0) : new LogicalPosition(next ? changeRange.end : changeRange.start, 0);
            int y = editor.logicalPositionToXY((LogicalPosition)position).y - shift;
            Point editorPoint = new Point(x, y);
            HintHint hintHint = DiffRequestProcessor.createNotifyHint(editor.getComponent(), editorPoint, !next);
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, editorPoint, 42, 0, false, hintHint);
        }
    }

    @NotNull
    private static HintHint createNotifyHint(@NotNull JComponent component, @NotNull Point point, boolean above) {
        if (component == null) {
            DiffRequestProcessor.$$$reportNull$$$0(26);
        }
        if (point == null) {
            DiffRequestProcessor.$$$reportNull$$$0(27);
        }
        HintHint hintHint = new HintHint(component, point).setPreferredPosition(above ? Balloon.Position.above : Balloon.Position.below).setAwtTooltip(true).setFont(UIUtil.getLabelFont().deriveFont(1)).setTextBg(HintUtil.getInformationColor()).setShowImmediately(true);
        if (hintHint == null) {
            DiffRequestProcessor.$$$reportNull$$$0(28);
        }
        return hintHint;
    }

    private static boolean isToolbarPlace(String place) {
        return "DiffToolbar".equals(place) || "TouchBarGeneral".equals(place);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 12: 
            case 13: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "availableTools";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolOrder";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFittedTool";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableFittedTools";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "filterFittedTools";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createState";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationActions";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTouchbarActions";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolOrderFromSettings";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotifyHint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "filterFittedTools";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findToolSubstitutor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "moveToolOnTop";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "applyRequest";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doApplyRequest";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setWindowTitle";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getContextUserData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "putContextUserData";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getToolOrderFromSettings";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateToolOrderSettings";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "notifyMessage";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createNotifyHint";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doApplyRequest$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class WrapperState
    implements ViewerState {
        @NotNull
        private final FrameDiffTool.DiffViewer myViewer;
        @NotNull
        private final FrameDiffTool myTool;
        @NotNull
        private final FrameDiffTool.DiffViewer myWrapperViewer;

        public WrapperState(@NotNull FrameDiffTool.DiffViewer viewer, @NotNull FrameDiffTool tool, DiffViewerWrapper wrapper2) {
            if (viewer == null) {
                WrapperState.$$$reportNull$$$0(0);
            }
            if (tool == null) {
                WrapperState.$$$reportNull$$$0(1);
            }
            if (wrapper2 == null) {
                WrapperState.$$$reportNull$$$0(2);
            }
            this.myViewer = viewer;
            this.myTool = tool;
            this.myWrapperViewer = wrapper2.createComponent(DiffRequestProcessor.this.myContext, DiffRequestProcessor.this.myActiveRequest, this.myViewer);
        }

        @Override
        public void init() {
            DiffRequestProcessor.this.myContentPanel.setContent(this.myWrapperViewer.getComponent());
            DiffRequestProcessor.this.setTitle(DiffRequestProcessor.this.myActiveRequest.getTitle());
            FrameDiffTool.ToolbarComponents toolbarComponents1 = this.myViewer.init();
            FrameDiffTool.ToolbarComponents toolbarComponents2 = this.myWrapperViewer.init();
            ArrayList<AnAction> toolbarActions = new ArrayList<AnAction>();
            if (toolbarComponents1.toolbarActions != null) {
                toolbarActions.addAll(toolbarComponents1.toolbarActions);
            }
            if (toolbarComponents2.toolbarActions != null) {
                if (!toolbarActions.isEmpty() && !toolbarComponents2.toolbarActions.isEmpty()) {
                    toolbarActions.add((AnAction)Separator.getInstance());
                }
                toolbarActions.addAll(toolbarComponents2.toolbarActions);
            }
            DiffRequestProcessor.this.buildToolbar(toolbarActions);
            ArrayList<AnAction> popupActions = new ArrayList<AnAction>();
            if (toolbarComponents1.popupActions != null) {
                popupActions.addAll(toolbarComponents1.popupActions);
            }
            if (toolbarComponents2.popupActions != null) {
                if (!popupActions.isEmpty() && !toolbarComponents2.popupActions.isEmpty()) {
                    popupActions.add((AnAction)Separator.getInstance());
                }
                popupActions.addAll(toolbarComponents2.popupActions);
            }
            DiffRequestProcessor.this.buildActionPopup(popupActions);
            DiffRequestProcessor.this.myToolbarStatusPanel.setContent(toolbarComponents1.statusPanel);
        }

        @Override
        public void destroy() {
            Disposer.dispose((Disposable)this.myViewer);
            Disposer.dispose((Disposable)this.myWrapperViewer);
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myWrapperViewer.getPreferredFocusedComponent();
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            FrameDiffTool frameDiffTool = this.myTool;
            if (frameDiffTool == null) {
                WrapperState.$$$reportNull$$$0(3);
            }
            return frameDiffTool;
        }

        @Override
        @Nullable
        public Object getData(@NonNls String dataId) {
            if (DiffDataKeys.WRAPPING_DIFF_VIEWER.is(dataId)) {
                return this.myWrapperViewer;
            }
            if (DiffDataKeys.DIFF_VIEWER.is(dataId)) {
                return this.myViewer;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tool";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor$WrapperState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$WrapperState";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActiveTool";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class DefaultState
    implements ViewerState {
        @NotNull
        private final FrameDiffTool.DiffViewer myViewer;
        @NotNull
        private final FrameDiffTool myTool;

        public DefaultState(@NotNull FrameDiffTool.DiffViewer viewer, FrameDiffTool tool) {
            if (viewer == null) {
                DefaultState.$$$reportNull$$$0(0);
            }
            if (tool == null) {
                DefaultState.$$$reportNull$$$0(1);
            }
            this.myViewer = viewer;
            this.myTool = tool;
        }

        @Override
        public void init() {
            DiffRequestProcessor.this.myContentPanel.setContent(this.myViewer.getComponent());
            DiffRequestProcessor.this.setTitle(DiffRequestProcessor.this.myActiveRequest.getTitle());
            FrameDiffTool.ToolbarComponents toolbarComponents = this.myViewer.init();
            DiffRequestProcessor.this.buildToolbar(toolbarComponents.toolbarActions);
            DiffRequestProcessor.this.buildActionPopup(toolbarComponents.popupActions);
            DiffRequestProcessor.this.myToolbarStatusPanel.setContent(toolbarComponents.statusPanel);
        }

        @Override
        public void destroy() {
            Disposer.dispose((Disposable)this.myViewer);
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myViewer.getPreferredFocusedComponent();
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            FrameDiffTool frameDiffTool = this.myTool;
            if (frameDiffTool == null) {
                DefaultState.$$$reportNull$$$0(2);
            }
            return frameDiffTool;
        }

        @Override
        @Nullable
        public Object getData(@NonNls String dataId) {
            if (DiffDataKeys.DIFF_VIEWER.is(dataId)) {
                return this.myViewer;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tool";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor$DefaultState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$DefaultState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActiveTool";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ErrorState
    implements ViewerState {
        @Nullable
        private final DiffTool myDiffTool;
        @NotNull
        private final MessageDiffRequest myRequest;
        @NotNull
        private final FrameDiffTool.DiffViewer myViewer;
        final /* synthetic */ DiffRequestProcessor this$0;

        public ErrorState(@NotNull DiffRequestProcessor diffRequestProcessor, MessageDiffRequest request) {
            if (request == null) {
                ErrorState.$$$reportNull$$$0(0);
            }
            this(diffRequestProcessor, request, null);
        }

        public ErrorState(@NotNull DiffRequestProcessor diffRequestProcessor, @Nullable MessageDiffRequest request, DiffTool diffTool) {
            if (request == null) {
                ErrorState.$$$reportNull$$$0(1);
            }
            this.this$0 = diffRequestProcessor;
            this.myDiffTool = diffTool;
            this.myRequest = request;
            this.myViewer = ErrorDiffTool.INSTANCE.createComponent(diffRequestProcessor.myContext, (DiffRequest)this.myRequest);
        }

        @Override
        public void init() {
            this.this$0.myContentPanel.setContent(this.myViewer.getComponent());
            FrameDiffTool.ToolbarComponents init = this.myViewer.init();
            this.this$0.buildToolbar(init.toolbarActions);
        }

        @Override
        public void destroy() {
            Disposer.dispose((Disposable)this.myViewer);
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @Override
        @Nullable
        public Object getData(@NonNls String dataId) {
            return null;
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            ErrorDiffTool errorDiffTool = this.myDiffTool != null ? this.myDiffTool : ErrorDiffTool.INSTANCE;
            if (errorDiffTool == null) {
                ErrorState.$$$reportNull$$$0(2);
            }
            return errorDiffTool;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor$ErrorState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$ErrorState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActiveTool";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EmptyState
    implements ViewerState {
        private static final EmptyState INSTANCE = new EmptyState();

        private EmptyState() {
        }

        @Override
        public void init() {
        }

        @Override
        public void destroy() {
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @Override
        @Nullable
        public Object getData(@NonNls String dataId) {
            return null;
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            ErrorDiffTool errorDiffTool = ErrorDiffTool.INSTANCE;
            if (errorDiffTool == null) {
                EmptyState.$$$reportNull$$$0(0);
            }
            return errorDiffTool;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffRequestProcessor$EmptyState", "getActiveTool"));
        }
    }

    private static interface ViewerState {
        public void init();

        public void destroy();

        @Nullable
        public JComponent getPreferredFocusedComponent();

        @Nullable
        public Object getData(@NonNls String var1);

        @NotNull
        public DiffTool getActiveTool();
    }

    private static class ApplyData {
        @NotNull
        private final DiffRequest request;
        private final boolean force;
        @Nullable
        private final DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy;

        public ApplyData(@NotNull DiffRequest request, boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
            if (request == null) {
                ApplyData.$$$reportNull$$$0(0);
            }
            this.request = request;
            this.force = force;
            this.scrollToChangePolicy = scrollToChangePolicy;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/impl/DiffRequestProcessor$ApplyData", "<init>"));
        }
    }

    private class MyDiffContext
    extends DiffContextEx {
        @NotNull
        private final UserDataHolder myContext;

        public MyDiffContext(UserDataHolder context) {
            if (context == null) {
                MyDiffContext.$$$reportNull$$$0(0);
            }
            this.myContext = context;
        }

        @Override
        public void reopenDiffRequest() {
            DiffRequestProcessor.this.updateRequest(true);
        }

        @Override
        public void reloadDiffRequest() {
            DiffRequestProcessor.this.reloadRequest();
        }

        @Override
        public void showProgressBar(boolean enabled) {
            if (enabled) {
                DiffRequestProcessor.this.myProgressBar.startProgress();
            } else {
                DiffRequestProcessor.this.myProgressBar.stopProgress();
            }
        }

        @Override
        public void setWindowTitle(@NotNull String title) {
            if (title == null) {
                MyDiffContext.$$$reportNull$$$0(1);
            }
            DiffRequestProcessor.this.setTitle(title);
        }

        @Nullable
        public Project getProject() {
            return DiffRequestProcessor.this.getProject();
        }

        public boolean isFocusedInWindow() {
            return DiffRequestProcessor.this.isFocusedInWindow();
        }

        public boolean isWindowFocused() {
            return DiffRequestProcessor.this.isWindowFocused();
        }

        public void requestFocusInWindow() {
            DiffRequestProcessor.this.requestFocusInWindow();
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                MyDiffContext.$$$reportNull$$$0(2);
            }
            return (T)this.myContext.getUserData(key);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
            if (key == null) {
                MyDiffContext.$$$reportNull$$$0(3);
            }
            this.myContext.putUserData(key, value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$MyDiffContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setWindowTitle";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUserData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putUserData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyFocusTraversalPolicy
    extends IdeFocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        @Override
        public final Component getDefaultComponentImpl(Container focusCycleRoot) {
            JComponent component = DiffRequestProcessor.this.getPreferredFocusedComponent();
            if (component == null) {
                return null;
            }
            return IdeFocusTraversalPolicy.getPreferredFocusedComponent(component, this);
        }
    }

    private static class MyProgressBar
    extends JProgressBar {
        private int myProgressCount = 0;

        public MyProgressBar() {
            this.setIndeterminate(true);
            this.setVisible(false);
        }

        public void startProgress() {
            ++this.myProgressCount;
            this.setVisible(true);
        }

        public void stopProgress() {
            --this.myProgressCount;
            LOG.assertTrue(this.myProgressCount >= 0);
            if (this.myProgressCount == 0) {
                this.setVisible(false);
            }
        }
    }

    private class MyPanel
    extends JBPanelWithEmptyText
    implements DataProvider {
        public MyPanel() {
            super((LayoutManager)new BorderLayout());
        }

        public Dimension getPreferredSize() {
            Dimension windowSize = DiffUtil.getDefaultDiffPanelSize();
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(windowSize.width, size.width), Math.max(windowSize.height, size.height));
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            Object data;
            DataProvider contentProvider = DataManagerImpl.getDataProviderEx(DiffRequestProcessor.this.myContentPanel.getTargetComponent());
            if (contentProvider != null && (data = contentProvider.getData(dataId)) != null) {
                return data;
            }
            if (OpenInEditorAction.KEY.is(dataId)) {
                return new MyOpenInEditorAction();
            }
            if (DiffDataKeys.DIFF_REQUEST.is(dataId)) {
                return DiffRequestProcessor.this.myActiveRequest;
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return DiffRequestProcessor.this.myProject;
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                if (DiffRequestProcessor.this.myActiveRequest.getUserData(DiffUserDataKeys.HELP_ID) != null) {
                    return DiffRequestProcessor.this.myActiveRequest.getUserData(DiffUserDataKeys.HELP_ID);
                }
                return "reference.dialogs.diff.file";
            }
            if (DiffDataKeys.DIFF_CONTEXT.is(dataId)) {
                return DiffRequestProcessor.this.myContext;
            }
            if (TouchbarDataKeys.ACTIONS_KEY.is(dataId)) {
                return DiffRequestProcessor.this.myTouchbarActionGroup;
            }
            data = DiffRequestProcessor.this.myState.getData(dataId);
            if (data != null) {
                return data;
            }
            DataProvider requestProvider = (DataProvider)DiffRequestProcessor.this.myActiveRequest.getUserData(DiffUserDataKeys.DATA_PROVIDER);
            if (requestProvider != null && (data = requestProvider.getData(dataId)) != null) {
                return data;
            }
            DataProvider contextProvider = (DataProvider)DiffRequestProcessor.this.myContext.getUserData(DiffUserDataKeys.DATA_PROVIDER);
            if (contextProvider != null && (data = contextProvider.getData(dataId)) != null) {
                return data;
            }
            return null;
        }
    }

    protected class MyOpenInEditorAction
    extends OpenInEditorAction {
        protected MyOpenInEditorAction() {
        }

        @Override
        protected void onAfterEditorOpened() {
            DiffRequestProcessor.this.onAfterNavigate();
        }
    }

    protected class MyPrevChangeAction
    extends PrevChangeAction {
        protected MyPrevChangeAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyPrevChangeAction.$$$reportNull$$$0(0);
            }
            if (!DiffRequestProcessor.isToolbarPlace(e.getPlace())) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            if (!DiffRequestProcessor.this.isNavigationEnabled()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(DiffRequestProcessor.this.hasPrevChange());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyPrevChangeAction.$$$reportNull$$$0(1);
            }
            if (!DiffRequestProcessor.this.isNavigationEnabled() || !DiffRequestProcessor.this.hasPrevChange()) {
                return;
            }
            DiffRequestProcessor.this.goToPrevChange(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$MyPrevChangeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyNextChangeAction
    extends NextChangeAction {
        protected MyNextChangeAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyNextChangeAction.$$$reportNull$$$0(0);
            }
            if (!DiffRequestProcessor.isToolbarPlace(e.getPlace())) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            if (!DiffRequestProcessor.this.isNavigationEnabled()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(DiffRequestProcessor.this.hasNextChange());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyNextChangeAction.$$$reportNull$$$0(1);
            }
            if (!DiffRequestProcessor.this.isNavigationEnabled() || !DiffRequestProcessor.this.hasNextChange()) {
                return;
            }
            DiffRequestProcessor.this.goToNextChange(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$MyNextChangeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyPrevDifferenceAction
    extends PrevDifferenceAction {
        protected MyPrevDifferenceAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyPrevDifferenceAction.$$$reportNull$$$0(0);
            }
            if (!DiffRequestProcessor.isToolbarPlace(e.getPlace())) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            PrevNextDifferenceIterable iterable = (PrevNextDifferenceIterable)DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.getData(e.getDataContext());
            if (iterable != null && iterable.canGoPrev()) {
                e.getPresentation().setEnabled(true);
                return;
            }
            if (DiffRequestProcessor.this.getSettings().isGoToNextFileOnNextDifference() && DiffRequestProcessor.this.isNavigationEnabled() && DiffRequestProcessor.this.hasPrevChange()) {
                e.getPresentation().setEnabled(true);
                return;
            }
            e.getPresentation().setEnabled(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PrevNextDifferenceIterable iterable;
            if (e == null) {
                MyPrevDifferenceAction.$$$reportNull$$$0(1);
            }
            if ((iterable = (PrevNextDifferenceIterable)DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.getData(e.getDataContext())) != null && iterable.canGoPrev()) {
                iterable.goPrev();
                DiffRequestProcessor.this.myIterationState = IterationState.NONE;
                return;
            }
            if (!(DiffRequestProcessor.this.isNavigationEnabled() && DiffRequestProcessor.this.hasPrevChange() && DiffRequestProcessor.this.getSettings().isGoToNextFileOnNextDifference())) {
                return;
            }
            if (DiffRequestProcessor.this.myIterationState != IterationState.PREV) {
                DiffRequestProcessor.this.notifyMessage(e, false);
                DiffRequestProcessor.this.myIterationState = IterationState.PREV;
                return;
            }
            DiffRequestProcessor.this.goToPrevChange(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$MyPrevDifferenceAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyNextDifferenceAction
    extends NextDifferenceAction {
        protected MyNextDifferenceAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyNextDifferenceAction.$$$reportNull$$$0(0);
            }
            if (!DiffRequestProcessor.isToolbarPlace(e.getPlace())) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            PrevNextDifferenceIterable iterable = (PrevNextDifferenceIterable)DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.getData(e.getDataContext());
            if (iterable != null && iterable.canGoNext()) {
                e.getPresentation().setEnabled(true);
                return;
            }
            if (DiffRequestProcessor.this.getSettings().isGoToNextFileOnNextDifference() && DiffRequestProcessor.this.isNavigationEnabled() && DiffRequestProcessor.this.hasNextChange()) {
                e.getPresentation().setEnabled(true);
                return;
            }
            e.getPresentation().setEnabled(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PrevNextDifferenceIterable iterable;
            if (e == null) {
                MyNextDifferenceAction.$$$reportNull$$$0(1);
            }
            if ((iterable = (PrevNextDifferenceIterable)DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.getData(e.getDataContext())) != null && iterable.canGoNext()) {
                iterable.goNext();
                DiffRequestProcessor.this.myIterationState = IterationState.NONE;
                return;
            }
            if (!(DiffRequestProcessor.this.isNavigationEnabled() && DiffRequestProcessor.this.hasNextChange() && DiffRequestProcessor.this.getSettings().isGoToNextFileOnNextDifference())) {
                return;
            }
            if (DiffRequestProcessor.this.myIterationState != IterationState.NEXT) {
                DiffRequestProcessor.this.notifyMessage(e, true);
                DiffRequestProcessor.this.myIterationState = IterationState.NEXT;
                return;
            }
            DiffRequestProcessor.this.goToNextChange(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$MyNextDifferenceAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum IterationState {
        NEXT,
        PREV,
        NONE;

    }

    private class ShowActionGroupPopupAction
    extends DumbAwareAction {
        public ShowActionGroupPopupAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Diff.ShowSettingsPopup");
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(DiffRequestProcessor.this.myPopupActionGroup.getChildrenCount() > 0);
        }

        public void actionPerformed(AnActionEvent e) {
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup("Diff Actions", (ActionGroup)DiffRequestProcessor.this.myPopupActionGroup, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
            popup2.showInCenterOf((Component)DiffRequestProcessor.this.myPanel);
        }
    }

    private class DiffToolToggleAction
    extends AnAction
    implements DumbAware {
        @NotNull
        private final DiffTool myDiffTool;

        private DiffToolToggleAction(DiffTool tool) {
            if (tool == null) {
                DiffToolToggleAction.$$$reportNull$$$0(0);
            }
            super(tool.getName());
            this.myDiffTool = tool;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(DiffRequestProcessor.this.myForcedDiffTool == null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DiffToolToggleAction.$$$reportNull$$$0(1);
            }
            if (DiffRequestProcessor.this.myState.getActiveTool() == this.myDiffTool) {
                return;
            }
            UsageTrigger.trigger("diff.DiffSettings.Tool." + ConvertUsagesUtil.ensureProperKey(this.myDiffTool.getName()));
            DiffRequestProcessor.this.moveToolOnTop(this.myDiffTool);
            DiffRequestProcessor.this.updateRequest(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tool";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$DiffToolToggleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyChangeDiffToolAction
    extends ComboBoxAction
    implements DumbAware {
        private MyChangeDiffToolAction() {
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            DiffTool activeTool = DiffRequestProcessor.this.myState.getActiveTool();
            presentation.setText(activeTool.getName());
            if (DiffRequestProcessor.this.myForcedDiffTool != null) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            for (DiffTool tool : DiffRequestProcessor.this.getAvailableFittedTools()) {
                if (tool == activeTool) continue;
                presentation.setEnabledAndVisible(true);
                return;
            }
            presentation.setEnabledAndVisible(false);
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (DiffTool tool : DiffRequestProcessor.this.getAvailableFittedTools()) {
                group.add((AnAction)new DiffToolToggleAction(tool));
            }
            DefaultActionGroup defaultActionGroup = group;
            if (defaultActionGroup == null) {
                MyChangeDiffToolAction.$$$reportNull$$$0(0);
            }
            return defaultActionGroup;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/impl/DiffRequestProcessor$MyChangeDiffToolAction", "createPopupActionGroup"));
        }
    }

    private class ShowInExternalToolAction
    extends DumbAwareAction {
        public ShowInExternalToolAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Diff.ShowInExternalTool");
        }

        public void update(AnActionEvent e) {
            if (!ExternalDiffTool.isEnabled()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setEnabled(ExternalDiffTool.canShow(DiffRequestProcessor.this.myActiveRequest));
            e.getPresentation().setVisible(true);
        }

        public void actionPerformed(AnActionEvent e) {
            try {
                ExternalDiffTool.showRequest(e.getProject(), DiffRequestProcessor.this.myActiveRequest);
            }
            catch (Throwable ex) {
                Messages.showErrorDialog((Project)e.getProject(), (String)ex.getMessage(), (String)"Can't Show Diff In External Tool");
            }
        }
    }
}

