/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.ProxyUndoRedoAction;
import com.intellij.diff.actions.impl.FocusOppositePaneAction;
import com.intellij.diff.actions.impl.OpenInEditorWithMouseAction;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.holders.TextEditorHolder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.InitialScrollPositionSupport;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.TwosideDiffViewer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineCol;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TwosideTextDiffViewer
extends TwosideDiffViewer<TextEditorHolder> {
    @NotNull
    private final List<? extends EditorEx> myEditableEditors;
    @Nullable
    private List<? extends EditorEx> myEditors;
    @NotNull
    protected final SetEditorSettingsAction myEditorSettingsAction;
    @NotNull
    private final MyVisibleAreaListener myVisibleAreaListener;
    @Nullable
    private SyncScrollSupport.TwosideSyncScrollSupport mySyncScrollSupport;

    public TwosideTextDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(0);
        }
        if (request == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(1);
        }
        super(context, request, TextEditorHolder.TextEditorHolderFactory.INSTANCE);
        this.myVisibleAreaListener = new MyVisibleAreaListener();
        new MyFocusOppositePaneAction(true).install(this.myPanel);
        new MyFocusOppositePaneAction(false).install(this.myPanel);
        this.myEditorSettingsAction = new SetEditorSettingsAction(this.getTextSettings(), this.getEditors());
        this.myEditorSettingsAction.applyDefaults();
        new MyOpenInEditorWithMouseAction().install(this.getEditors());
        this.myEditableEditors = TextDiffViewerUtil.getEditableEditors(this.getEditors());
        TextDiffViewerUtil.checkDifferentDocuments(this.myRequest);
        boolean editable1 = DiffUtil.canMakeWritable(this.getContent1().getDocument());
        boolean editable2 = DiffUtil.canMakeWritable(this.getContent2().getDocument());
        if (editable1 ^ editable2) {
            ProxyUndoRedoAction.register(this.getProject(), editable1 ? this.getEditor1() : this.getEditor2(), this.myPanel);
        }
        for (Side side : Side.values()) {
            DiffUtil.installLineConvertor(this.getEditor(side), this.getContent(side));
        }
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.installEditorListeners();
    }

    @Override
    protected void onDispose() {
        this.destroyEditorListeners();
        super.onDispose();
    }

    @Override
    @NotNull
    protected List<TextEditorHolder> createEditorHolders(@NotNull EditorHolderFactory<TextEditorHolder> factory) {
        if (factory == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(2);
        }
        List<TextEditorHolder> holders = super.createEditorHolders(factory);
        boolean[] forceReadOnly = TextDiffViewerUtil.checkForceReadOnly(this.myContext, this.myRequest);
        for (int i = 0; i < 2; ++i) {
            if (!forceReadOnly[i]) continue;
            holders.get(i).getEditor().setViewer(true);
        }
        ((TextEditorHolder)Side.LEFT.select(holders)).getEditor().setVerticalScrollbarOrientation(0);
        for (TextEditorHolder holder : holders) {
            DiffUtil.disableBlitting(holder.getEditor());
        }
        List<TextEditorHolder> list2 = holders;
        if (list2 == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    @NotNull
    protected List<JComponent> createTitles() {
        List<JComponent> list2 = DiffUtil.createSyncHeightComponents(DiffUtil.createTextTitles(this.myRequest, this.getEditors()));
        if (list2 == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public TextDiffSettingsHolder.TextDiffSettings getTextSettings() {
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = TextDiffViewerUtil.getTextSettings(this.myContext);
        if (textDiffSettings == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(5);
        }
        return textDiffSettings;
    }

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        List<AnAction> list2 = TextDiffViewerUtil.createEditorPopupActions();
        if (list2 == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(7);
        }
        super.onDocumentChange(event);
        this.myContentPanel.repaintDivider();
    }

    protected void installEditorListeners() {
        new TextDiffViewerUtil.EditorActionsPopup(this.createEditorPopupActions()).install(this.getEditors());
        new TextDiffViewerUtil.EditorFontSizeSynchronizer(this.getEditors()).install((Disposable)this);
        this.getEditor(Side.LEFT).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        this.getEditor(Side.RIGHT).getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        SyncScrollSupport.SyncScrollable scrollable = this.getSyncScrollable();
        if (scrollable != null) {
            this.mySyncScrollSupport = new SyncScrollSupport.TwosideSyncScrollSupport(this.getEditors(), scrollable);
            this.myEditorSettingsAction.setSyncScrollSupport(this.mySyncScrollSupport);
        }
    }

    protected void destroyEditorListeners() {
        this.getEditor(Side.LEFT).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
        this.getEditor(Side.RIGHT).getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
        this.mySyncScrollSupport = null;
    }

    protected void disableSyncScrollSupport(boolean disable) {
        if (this.mySyncScrollSupport != null) {
            if (disable) {
                this.mySyncScrollSupport.enterDisableScrollSection();
            } else {
                this.mySyncScrollSupport.exitDisableScrollSection();
            }
        }
    }

    @NotNull
    protected List<? extends DocumentContent> getContents() {
        List list2 = this.myRequest.getContents();
        if (list2 == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    public List<? extends EditorEx> getEditors() {
        if (this.myEditors == null) {
            this.myEditors = ContainerUtil.map(this.getEditorHolders(), holder -> holder.getEditor());
        }
        List<? extends EditorEx> list2 = this.myEditors;
        if (list2 == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    protected List<? extends EditorEx> getEditableEditors() {
        List<? extends EditorEx> list2 = this.myEditableEditors;
        if (list2 == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NotNull
    public EditorEx getCurrentEditor() {
        EditorEx editorEx = this.getEditor(this.getCurrentSide());
        if (editorEx == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(11);
        }
        return editorEx;
    }

    @NotNull
    public DocumentContent getCurrentContent() {
        DocumentContent documentContent = this.getContent(this.getCurrentSide());
        if (documentContent == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(12);
        }
        return documentContent;
    }

    @NotNull
    public EditorEx getEditor1() {
        EditorEx editorEx = this.getEditor(Side.LEFT);
        if (editorEx == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(13);
        }
        return editorEx;
    }

    @NotNull
    public EditorEx getEditor2() {
        EditorEx editorEx = this.getEditor(Side.RIGHT);
        if (editorEx == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(14);
        }
        return editorEx;
    }

    @NotNull
    public EditorEx getEditor(@NotNull Side side) {
        if (side == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(15);
        }
        EditorEx editorEx = (EditorEx)side.select(this.getEditors());
        if (editorEx == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(16);
        }
        return editorEx;
    }

    @NotNull
    public DocumentContent getContent(@NotNull Side side) {
        if (side == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(17);
        }
        DocumentContent documentContent = (DocumentContent)side.select(this.getContents());
        if (documentContent == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(18);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent getContent1() {
        DocumentContent documentContent = this.getContent(Side.LEFT);
        if (documentContent == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(19);
        }
        return documentContent;
    }

    @NotNull
    public DocumentContent getContent2() {
        DocumentContent documentContent = this.getContent(Side.RIGHT);
        if (documentContent == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(20);
        }
        return documentContent;
    }

    @Nullable
    public SyncScrollSupport.TwosideSyncScrollSupport getSyncScrollSupport() {
        return this.mySyncScrollSupport;
    }

    @NotNull
    protected LineCol transferPosition(@NotNull Side baseSide, @NotNull LineCol position) {
        if (baseSide == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(21);
        }
        if (position == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(22);
        }
        if (this.mySyncScrollSupport == null) {
            LineCol lineCol = position;
            if (lineCol == null) {
                TwosideTextDiffViewer.$$$reportNull$$$0(23);
            }
            return lineCol;
        }
        int line = this.mySyncScrollSupport.getScrollable().transfer(baseSide, position.line);
        LineCol lineCol = new LineCol(line, position.column);
        if (lineCol == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(24);
        }
        return lineCol;
    }

    protected void scrollToLine(@NotNull Side side, int line) {
        if (side == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(25);
        }
        DiffUtil.scrollEditor(this.getEditor(side), line, false);
        this.setCurrentSide(side);
    }

    @Nullable
    protected abstract SyncScrollSupport.SyncScrollable getSyncScrollable();

    @Override
    @Nullable
    protected Navigatable getNavigatable() {
        Side side = this.getCurrentSide();
        LineCol position = LineCol.fromCaret((Editor)this.getEditor(side));
        Navigatable navigatable = this.getContent(side).getNavigatable(position);
        if (navigatable != null) {
            return navigatable;
        }
        LineCol otherPosition = this.transferPosition(side, position);
        return this.getContent(side.other()).getNavigatable(otherPosition);
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(26);
        }
        if (request == null) {
            TwosideTextDiffViewer.$$$reportNull$$$0(27);
        }
        return TwosideDiffViewer.canShowRequest(context, request, TextEditorHolder.TextEditorHolderFactory.INSTANCE);
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (DiffDataKeys.CURRENT_EDITOR.is(dataId)) {
            return this.getCurrentEditor();
        }
        return super.getData(dataId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/side/TwosideTextDiffViewer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 15: 
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSide";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/side/TwosideTextDiffViewer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorHolders";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditableEditors";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentEditor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentContent";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor1";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor2";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent1";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent2";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "transferPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createEditorHolders";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onDocumentChange";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "transferPosition";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "scrollToLine";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected abstract class MyInitialScrollPositionHelper
    extends InitialScrollPositionSupport.TwosideInitialScrollHelper {
        protected MyInitialScrollPositionHelper() {
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            List<? extends EditorEx> list2 = TwosideTextDiffViewer.this.getEditors();
            if (list2 == null) {
                MyInitialScrollPositionHelper.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Override
        protected void disableSyncScroll(boolean value) {
            TwosideTextDiffViewer.this.disableSyncScrollSupport(value);
        }

        @Override
        protected boolean doScrollToLine() {
            if (this.myScrollToLine == null) {
                return false;
            }
            TwosideTextDiffViewer.this.scrollToLine((Side)this.myScrollToLine.first, (Integer)this.myScrollToLine.second);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/side/TwosideTextDiffViewer$MyInitialScrollPositionHelper", "getEditors"));
        }
    }

    private class MyVisibleAreaListener
    implements VisibleAreaListener {
        private MyVisibleAreaListener() {
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (TwosideTextDiffViewer.this.mySyncScrollSupport != null) {
                TwosideTextDiffViewer.this.mySyncScrollSupport.visibleAreaChanged(e);
            }
            TwosideTextDiffViewer.this.myContentPanel.repaint();
        }
    }

    protected class MyToggleAutoScrollAction
    extends TextDiffViewerUtil.ToggleAutoScrollAction {
        public MyToggleAutoScrollAction() {
            super(TwosideTextDiffViewer.this.getTextSettings());
        }
    }

    private class MyOpenInEditorWithMouseAction
    extends OpenInEditorWithMouseAction {
        private MyOpenInEditorWithMouseAction() {
        }

        @Override
        protected Navigatable getNavigatable(@NotNull Editor editor, int line) {
            Side side;
            if (editor == null) {
                MyOpenInEditorWithMouseAction.$$$reportNull$$$0(0);
            }
            if ((side = Side.fromValue(TwosideTextDiffViewer.this.getEditors(), (Object)editor)) == null) {
                return null;
            }
            return TwosideTextDiffViewer.this.getContent(side).getNavigatable(new LineCol(line));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/side/TwosideTextDiffViewer$MyOpenInEditorWithMouseAction", "getNavigatable"));
        }
    }

    private class MyFocusOppositePaneAction
    extends FocusOppositePaneAction {
        public MyFocusOppositePaneAction(boolean scrollToPosition) {
            super(scrollToPosition);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyFocusOppositePaneAction.$$$reportNull$$$0(0);
            }
            Side currentSide = TwosideTextDiffViewer.this.getCurrentSide();
            Side targetSide = currentSide.other();
            EditorEx currentEditor = TwosideTextDiffViewer.this.getEditor(currentSide);
            EditorEx targetEditor = TwosideTextDiffViewer.this.getEditor(targetSide);
            if (this.myScrollToPosition) {
                LineCol position = TwosideTextDiffViewer.this.transferPosition(currentSide, LineCol.fromCaret((Editor)currentEditor));
                targetEditor.getCaretModel().moveToOffset(position.toOffset((Editor)targetEditor));
            }
            TwosideTextDiffViewer.this.setCurrentSide(targetSide);
            targetEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            DiffUtil.requestFocus(TwosideTextDiffViewer.this.getProject(), TwosideTextDiffViewer.this.getPreferredFocusedComponent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/util/side/TwosideTextDiffViewer$MyFocusOppositePaneAction", "actionPerformed"));
        }
    }
}

