/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.tree;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.RunDashboardGroup;
import com.intellij.execution.dashboard.RunDashboardGroupingRule;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.tree.GroupingNode;
import com.intellij.execution.dashboard.tree.RunConfigurationDashboardGroupingRule;
import com.intellij.execution.dashboard.tree.RunConfigurationNode;
import com.intellij.execution.dashboard.tree.RunDashboardFilter;
import com.intellij.execution.dashboard.tree.RunDashboardGrouper;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructureBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunDashboardTreeStructure
extends AbstractTreeStructureBase {
    private final Project myProject;
    private final List<RunDashboardGrouper> myGroupers;
    private final List<RunDashboardFilter> myFilters;
    private final RunConfigurationsTreeRootNode myRootElement;

    public RunDashboardTreeStructure(@NotNull Project project, @NotNull List<RunDashboardGrouper> groupers, @NotNull List<RunDashboardFilter> filters) {
        if (project == null) {
            RunDashboardTreeStructure.$$$reportNull$$$0(0);
        }
        if (groupers == null) {
            RunDashboardTreeStructure.$$$reportNull$$$0(1);
        }
        if (filters == null) {
            RunDashboardTreeStructure.$$$reportNull$$$0(2);
        }
        super(project);
        this.myProject = project;
        this.myGroupers = groupers;
        this.myFilters = filters;
        this.myRootElement = new RunConfigurationsTreeRootNode();
    }

    @Override
    @Nullable
    public List<TreeStructureProvider> getProviders() {
        return Collections.emptyList();
    }

    public Object getRootElement() {
        return this.myRootElement;
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    private static Collection<? extends AbstractTreeNode> group(Project project, AbstractTreeNode parent, List<RunDashboardGroupingRule> rules, final List<RunConfigurationNode> nodes) {
        if (rules.isEmpty()) {
            return nodes;
        }
        ArrayList<RunDashboardGroupingRule> remaining = new ArrayList<RunDashboardGroupingRule>(rules);
        RunDashboardGroupingRule rule = (RunDashboardGroupingRule)remaining.remove(0);
        Map<Optional, List<RunConfigurationNode>> groups = nodes.stream().collect(Collectors.groupingBy(node -> Optional.ofNullable(rule.getGroup((AbstractTreeNode)node))));
        ArrayList result2 = new ArrayList();
        ArrayList ungroupedNodes = new ArrayList();
        groups.forEach((group, groupedNodes) -> {
            if (!group.isPresent() || !rule.shouldGroupSingleNodes() && groupedNodes.size() == 1) {
                ungroupedNodes.addAll(RunDashboardTreeStructure.group(project, parent, remaining, groupedNodes));
            } else {
                GroupingNode node = new GroupingNode(project, parent.getValue(), (RunDashboardGroup)group.get());
                node.addChildren(RunDashboardTreeStructure.group(project, node, remaining, groupedNodes));
                result2.add(node);
            }
        });
        if (rule instanceof RunConfigurationDashboardGroupingRule) {
            result2.addAll(ungroupedNodes);
            Collections.sort(result2, new Comparator<AbstractTreeNode>(){

                @Override
                public int compare(AbstractTreeNode n1, AbstractTreeNode n2) {
                    RunConfigurationNode first = this.getNode(n1);
                    RunConfigurationNode second = this.getNode(n2);
                    return nodes.indexOf((Object)first) - nodes.indexOf((Object)second);
                }

                private RunConfigurationNode getNode(AbstractTreeNode node) {
                    Object runConfigurationNode;
                    if (node instanceof GroupingNode) {
                        Optional child = node.getChildren().stream().findFirst();
                        assert (child.isPresent());
                        runConfigurationNode = child.get();
                    } else {
                        runConfigurationNode = node;
                    }
                    assert (runConfigurationNode instanceof RunConfigurationNode);
                    return (RunConfigurationNode)((Object)runConfigurationNode);
                }
            });
        } else {
            Collections.sort(result2, Comparator.comparing(node -> ((GroupingNode)((Object)node)).getGroup(), rule.getGroupComparator()));
            result2.addAll(ungroupedNodes);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "groupers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "filters";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/dashboard/tree/RunDashboardTreeStructure";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class RunConfigurationsTreeRootNode
    extends AbstractTreeNode<Object> {
        public RunConfigurationsTreeRootNode() {
            super(RunDashboardTreeStructure.this.myProject, new Object());
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)this.myProject);
            List nodes = runDashboardManager.getRunConfigurations().stream().map(value -> new RunConfigurationNode(this.myProject, (Pair<RunnerAndConfigurationSettings, RunContentDescriptor>)value, runDashboardManager.getContributor(((RunnerAndConfigurationSettings)value.first).getType()))).filter(node -> RunDashboardTreeStructure.this.myFilters.stream().allMatch(filter -> filter.isVisible((AbstractTreeNode<?>)node))).collect(Collectors.toList());
            List enabledRules = RunDashboardTreeStructure.this.myGroupers.stream().filter(RunDashboardGrouper::isEnabled).map(RunDashboardGrouper::getRule).collect(Collectors.toList());
            Collection collection = RunDashboardTreeStructure.group(this.myProject, this, enabledRules, nodes);
            if (collection == null) {
                RunConfigurationsTreeRootNode.$$$reportNull$$$0(0);
            }
            return collection;
        }

        protected void update(PresentationData presentation) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/tree/RunDashboardTreeStructure$RunConfigurationsTreeRootNode", "getChildren"));
        }
    }
}

