/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.layout.impl.RunnerLayout;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="RunnerLayoutSettings", storages={@Storage(value="runner.layout.xml", roamingType=RoamingType.DISABLED)})
public class RunnerLayoutSettings
implements PersistentStateComponent<Element> {
    private final Map<String, RunnerLayout> myRunnerId2Settings = new LinkedHashMap<String, RunnerLayout>();

    public static RunnerLayoutSettings getInstance() {
        return (RunnerLayoutSettings)ServiceManager.getService(RunnerLayoutSettings.class);
    }

    public RunnerLayout getLayout(@NotNull String id) {
        RunnerLayout layout;
        if (id == null) {
            RunnerLayoutSettings.$$$reportNull$$$0(0);
        }
        if ((layout = this.myRunnerId2Settings.get(id)) == null) {
            layout = new RunnerLayout(id);
            this.myRunnerId2Settings.put(id, layout);
        }
        return layout;
    }

    public Element getState() {
        Element runners = new Element("runners");
        for (String eachID : this.myRunnerId2Settings.keySet()) {
            RunnerLayout layout = this.myRunnerId2Settings.get(eachID);
            Element runnerElement = new Element("runner");
            runnerElement.setAttribute("id", eachID);
            layout.write(runnerElement);
            runners.addContent(runnerElement);
        }
        return runners;
    }

    public void loadState(@NotNull Element state2) {
        if (state2 == null) {
            RunnerLayoutSettings.$$$reportNull$$$0(1);
        }
        List runners = state2.getChildren("runner");
        for (Object each : runners) {
            Element eachRunnerElement = (Element)each;
            String eachID = eachRunnerElement.getAttributeValue("id");
            RunnerLayout eachLayout = new RunnerLayout(eachID);
            eachLayout.read(eachRunnerElement);
            this.myRunnerId2Settings.put(eachID, eachLayout);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/ui/layout/impl/RunnerLayoutSettings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLayout";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

