/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.extapi.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class PsiFileBase
extends PsiFileImpl {
    @NotNull
    private final Language myLanguage;
    @NotNull
    private final ParserDefinition myParserDefinition;

    protected PsiFileBase(@NotNull FileViewProvider viewProvider, @NotNull Language language) {
        if (viewProvider == null) {
            PsiFileBase.$$$reportNull$$$0(0);
        }
        if (language == null) {
            PsiFileBase.$$$reportNull$$$0(1);
        }
        super(viewProvider);
        this.myLanguage = PsiFileBase.findLanguage(language, viewProvider);
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.myLanguage);
        if (parserDefinition == null) {
            throw new RuntimeException("PsiFileBase: language.getParserDefinition() returned null for: " + this.myLanguage);
        }
        this.myParserDefinition = parserDefinition;
        IFileElementType nodeType = parserDefinition.getFileNodeType();
        assert (nodeType.getLanguage() == this.myLanguage) : nodeType.getLanguage() + " != " + this.myLanguage;
        this.init((IElementType)nodeType, (IElementType)nodeType);
    }

    private static Language findLanguage(Language baseLanguage, FileViewProvider viewProvider) {
        Set languages = viewProvider.getLanguages();
        for (Language actualLanguage : languages) {
            if (!actualLanguage.isKindOf(baseLanguage)) continue;
            return actualLanguage;
        }
        throw new AssertionError((Object)("Language " + baseLanguage + " doesn't participate in view provider " + viewProvider + ": " + new ArrayList(languages)));
    }

    @Override
    @NotNull
    public final Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            PsiFileBase.$$$reportNull$$$0(2);
        }
        return language;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiFileBase.$$$reportNull$$$0(3);
        }
        visitor2.visitFile((PsiFile)this);
    }

    @NotNull
    public ParserDefinition getParserDefinition() {
        ParserDefinition parserDefinition = this.myParserDefinition;
        if (parserDefinition == null) {
            PsiFileBase.$$$reportNull$$$0(4);
        }
        return parserDefinition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/extapi/psi/PsiFileBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/extapi/psi/PsiFileBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParserDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

