/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.ide.util.PlatformModuleRendererFactory;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiElementListCellRenderer<T extends PsiElement>
extends JPanel
implements ListCellRenderer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.PsiElementListCellRenderer");
    private static final String LEFT = "West";
    private static final Pattern CONTAINER_PATTERN = Pattern.compile("(\\(in |\\()?([^)]*)(\\))?");
    private boolean myFocusBorderEnabled = Registry.is((String)"psi.element.list.cell.renderer.focus.border.enabled");
    protected int myRightComponentWidth;

    protected PsiElementListCellRenderer() {
        super(new BorderLayout());
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new MyAccessibleContext();
        }
        return this.accessibleContext;
    }

    @Nullable
    protected static Color getBackgroundColor(@Nullable Object value) {
        PsiElement psiElement = NavigationItemListCellRenderer.getPsiElement(value);
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
        Color fileColor = virtualFile == null ? null : VfsPresentationUtil.getFileBackgroundColor(psiElement.getProject(), virtualFile);
        return fileColor != null ? fileColor : UIUtil.getListBackground();
    }

    @Nullable
    protected TextAttributes getNavigationItemAttributes(Object value) {
        TextAttributes attributes = null;
        if (value instanceof NavigationItem) {
            TextAttributesKey attributesKey = null;
            ItemPresentation presentation = ((NavigationItem)value).getPresentation();
            if (presentation instanceof ColoredItemPresentation) {
                attributesKey = ((ColoredItemPresentation)presentation).getTextAttributesKey();
            }
            if (attributesKey != null) {
                attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attributesKey);
            }
        }
        return attributes;
    }

    public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.removeAll();
        this.myRightComponentWidth = 0;
        DefaultListCellRenderer rightRenderer = this.getRightCellRenderer(value);
        Component rightCellRendererComponent = null;
        JPanel spacer = null;
        if (rightRenderer != null) {
            rightCellRendererComponent = rightRenderer.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
            this.add(rightCellRendererComponent, "East");
            spacer = new JPanel();
            spacer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.add((Component)spacer, "Center");
            this.myRightComponentWidth = rightCellRendererComponent.getPreferredSize().width;
            this.myRightComponentWidth += spacer.getPreferredSize().width;
        }
        LeftRenderer leftRenderer = new LeftRenderer(null, value == null ? new ItemMatchers(null, null) : this.getItemMatchers(list2, value));
        Component leftCellRendererComponent = leftRenderer.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
        this.add(leftCellRendererComponent, LEFT);
        Color bg = isSelected ? UIUtil.getListSelectionBackground() : leftCellRendererComponent.getBackground();
        this.setBackground(bg);
        if (rightCellRendererComponent != null) {
            rightCellRendererComponent.setBackground(bg);
        }
        if (spacer != null) {
            spacer.setBackground(bg);
        }
        return this;
    }

    @NotNull
    protected ItemMatchers getItemMatchers(@NotNull JList list2, @NotNull Object value) {
        if (list2 == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(0);
        }
        if (value == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(1);
        }
        ItemMatchers itemMatchers = new ItemMatchers(MatcherHolder.getAssociatedMatcher(list2), null);
        if (itemMatchers == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(2);
        }
        return itemMatchers;
    }

    protected void setFocusBorderEnabled(boolean enabled) {
        this.myFocusBorderEnabled = enabled;
    }

    protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list2, Object value, int index, boolean selected, boolean hasFocus) {
        return false;
    }

    @Nullable
    protected DefaultListCellRenderer getRightCellRenderer(Object value) {
        if (UISettings.getInstance().getShowIconInQuickNavigation()) {
            DefaultListCellRenderer renderer = ModuleRendererFactory.findInstance(value).getModuleRenderer();
            if (renderer instanceof PlatformModuleRendererFactory.PlatformModuleRenderer) {
                return null;
            }
            return renderer;
        }
        return null;
    }

    public abstract String getElementText(T var1);

    @Nullable
    protected abstract String getContainerText(T var1, String var2);

    @Nullable
    protected String getContainerTextForLeftComponent(T element, String name) {
        return this.getContainerText(element, name);
    }

    @Iconable.IconFlags
    protected abstract int getIconFlags();

    protected Icon getIcon(PsiElement element) {
        return element.getIcon(this.getIconFlags());
    }

    public Comparator<T> getComparator() {
        return Comparator.comparing(this::getComparingObject);
    }

    @NotNull
    public Comparable getComparingObject(T element) {
        Comparable comparable = (Comparable)ReadAction.compute(() -> {
            String elementText = this.getElementText(element);
            String containerText = this.getContainerText(element, elementText);
            return containerText == null ? elementText : elementText + " " + containerText;
        });
        if (comparable == null) {
            PsiElementListCellRenderer.$$$reportNull$$$0(3);
        }
        return comparable;
    }

    public void installSpeedSearch(PopupChooserBuilder<?> builder2) {
        this.installSpeedSearch((IPopupChooserBuilder)builder2);
    }

    public void installSpeedSearch(PopupChooserBuilder<?> builder2, boolean includeContainerText) {
        this.installSpeedSearch((IPopupChooserBuilder)builder2, includeContainerText);
    }

    public void installSpeedSearch(IPopupChooserBuilder builder2) {
        this.installSpeedSearch(builder2, false);
    }

    public void installSpeedSearch(IPopupChooserBuilder builder2, boolean includeContainerText) {
        builder2.setNamerForFiltering(o -> {
            if (o instanceof PsiElement) {
                String elementText = this.getElementText((PsiElement)o);
                if (includeContainerText) {
                    return elementText + " " + this.getContainerText((PsiElement)o, elementText);
                }
                return elementText;
            }
            return o.toString();
        });
    }

    @Deprecated
    public void installSpeedSearch(JList list2) {
        new ListSpeedSearch(list2){

            @Override
            protected String getElementText(Object o) {
                if (o instanceof PsiElement) {
                    String elementText = PsiElementListCellRenderer.this.getElementText((PsiElement)o);
                    return elementText + " " + PsiElementListCellRenderer.this.getContainerText((PsiElement)o, elementText);
                }
                return o.toString();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/PsiElementListCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/PsiElementListCellRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemMatchers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparingObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItemMatchers";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LeftRenderer
    extends ColoredListCellRenderer {
        private final String myModuleName;
        private final ItemMatchers myMatchers;

        LeftRenderer(@NotNull String moduleName, ItemMatchers matchers) {
            if (matchers == null) {
                LeftRenderer.$$$reportNull$$$0(0);
            }
            this.myModuleName = moduleName;
            this.myMatchers = matchers;
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
            if (list2 == null) {
                LeftRenderer.$$$reportNull$$$0(1);
            }
            Color bgColor = UIUtil.getListBackground();
            Color color = list2.getForeground();
            this.setPaintFocusBorder(hasFocus && UIUtil.isToUseDottedCellBorder() && PsiElementListCellRenderer.this.myFocusBorderEnabled);
            PsiElement target2 = NavigationItemListCellRenderer.getPsiElement(value);
            VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)target2);
            boolean isProblemFile = false;
            if (vFile != null) {
                Project project = target2.getProject();
                isProblemFile = WolfTheProblemSolver.getInstance((Project)project).isProblemFile(vFile);
                FileStatus status = FileStatusManager.getInstance((Project)project).getStatus(vFile);
                color = status.getColor();
                Color fileBgColor = VfsPresentationUtil.getFileBackgroundColor(project, vFile);
                Color color2 = bgColor = fileBgColor == null ? bgColor : fileBgColor;
            }
            if (value instanceof PsiElement) {
                SimpleTextAttributes nameAttributes;
                PsiElement element = (PsiElement)value;
                String name = ((PsiElement)value).isValid() ? PsiElementListCellRenderer.this.getElementText(element) : "INVALID";
                TextAttributes attributes = element.isValid() ? PsiElementListCellRenderer.this.getNavigationItemAttributes(value) : null;
                SimpleTextAttributes simpleTextAttributes = nameAttributes = attributes != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes) : null;
                if (nameAttributes == null) {
                    nameAttributes = new SimpleTextAttributes(0, color);
                }
                if (name == null) {
                    LOG.error("Null name for PSI element " + element.getClass() + " (by " + PsiElementListCellRenderer.this + ")");
                    name = "Unknown";
                }
                SpeedSearchUtil.appendColoredFragmentForMatcher((String)name, (SimpleColoredComponent)this, (SimpleTextAttributes)nameAttributes, (com.intellij.util.text.Matcher)this.myMatchers.nameMatcher, (Color)bgColor, (boolean)selected);
                if (!element.isValid()) {
                    this.append(" Invalid", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    return;
                }
                this.setIcon(PsiElementListCellRenderer.this.getIcon(element));
                String containerText = PsiElementListCellRenderer.this.getContainerTextForLeftComponent(element, name + (this.myModuleName != null ? this.myModuleName + "        " : ""));
                if (containerText != null) {
                    this.appendLocationText(selected, bgColor, isProblemFile, containerText);
                }
            } else if (!PsiElementListCellRenderer.this.customizeNonPsiElementLeftRenderer(this, list2, value, index, selected, hasFocus)) {
                this.setIcon(IconUtil.getEmptyIcon((boolean)false));
                this.append(value == null ? "" : value.toString(), new SimpleTextAttributes(0, list2.getForeground()));
            }
            this.setBackground(selected ? UIUtil.getListSelectionBackground() : bgColor);
        }

        private void appendLocationText(boolean selected, Color bgColor, boolean isProblemFile, String containerText) {
            SimpleTextAttributes locationAttrs = new SimpleTextAttributes(0, (Color)JBColor.GRAY);
            if (isProblemFile) {
                SimpleTextAttributes wavedAttributes = SimpleTextAttributes.merge((SimpleTextAttributes)new SimpleTextAttributes(8, (Color)JBColor.GRAY, (Color)JBColor.RED), (SimpleTextAttributes)locationAttrs);
                Matcher matcher = CONTAINER_PATTERN.matcher(containerText);
                if (matcher.matches()) {
                    String prefix = matcher.group(1);
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)(" " + (String)ObjectUtils.notNull((Object)prefix, (Object)"")), (SimpleColoredComponent)this, (SimpleTextAttributes)locationAttrs, (com.intellij.util.text.Matcher)this.myMatchers.locationMatcher, (Color)bgColor, (boolean)selected);
                    String strippedContainerText = matcher.group(2);
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)((String)ObjectUtils.notNull((Object)strippedContainerText, (Object)"")), (SimpleColoredComponent)this, (SimpleTextAttributes)wavedAttributes, (com.intellij.util.text.Matcher)this.myMatchers.locationMatcher, (Color)bgColor, (boolean)selected);
                    String suffix = matcher.group(3);
                    if (suffix != null) {
                        SpeedSearchUtil.appendColoredFragmentForMatcher((String)suffix, (SimpleColoredComponent)this, (SimpleTextAttributes)locationAttrs, (com.intellij.util.text.Matcher)this.myMatchers.locationMatcher, (Color)bgColor, (boolean)selected);
                    }
                    return;
                }
                locationAttrs = wavedAttributes;
            }
            SpeedSearchUtil.appendColoredFragmentForMatcher((String)(" " + containerText), (SimpleColoredComponent)this, (SimpleTextAttributes)locationAttrs, (com.intellij.util.text.Matcher)this.myMatchers.locationMatcher, (Color)bgColor, (boolean)selected);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchers";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/util/PsiElementListCellRenderer$LeftRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ItemMatchers {
        @Nullable
        public final com.intellij.util.text.Matcher nameMatcher;
        @Nullable
        final com.intellij.util.text.Matcher locationMatcher;

        public ItemMatchers(@Nullable com.intellij.util.text.Matcher nameMatcher, @Nullable com.intellij.util.text.Matcher locationMatcher) {
            this.nameMatcher = nameMatcher;
            this.locationMatcher = locationMatcher;
        }
    }

    private class MyAccessibleContext
    extends JPanel.AccessibleJPanel {
        private MyAccessibleContext() {
            super(PsiElementListCellRenderer.this);
        }

        @Override
        public String getAccessibleName() {
            LayoutManager lm = PsiElementListCellRenderer.this.getLayout();
            assert (lm instanceof BorderLayout);
            Component leftCellRendererComp = ((BorderLayout)lm).getLayoutComponent(PsiElementListCellRenderer.LEFT);
            return leftCellRendererComp instanceof Accessible ? leftCellRendererComp.getAccessibleContext().getAccessibleName() : super.getAccessibleName();
        }
    }
}

