/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoClassPresentationUpdater;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.lang.Language;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.ChooseByNameRegistry;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IdeUICustomization;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoClassModel2
extends FilteringGotoByModel<Language> {
    private String[] mySeparators;

    public GotoClassModel2(@NotNull Project project) {
        if (project == null) {
            GotoClassModel2.$$$reportNull$$$0(0);
        }
        super(project, ChooseByNameRegistry.getInstance().getClassModelContributors());
    }

    @Override
    protected Language filterValueFor(NavigationItem item) {
        return item instanceof PsiElement ? ((PsiElement)item).getLanguage() : null;
    }

    @Override
    protected synchronized Collection<Language> getFilterItems() {
        Collection result2 = super.getFilterItems();
        if (result2 == null) {
            return null;
        }
        HashSet<Language> items = new HashSet<Language>(result2);
        items.add(Language.ANY);
        return items;
    }

    @Nullable
    public String getPromptText() {
        return IdeBundle.message((String)"prompt.gotoclass.enter.class.name", (Object[])new Object[]{StringUtil.toLowerCase((String)GotoClassPresentationUpdater.getActionTitle())});
    }

    public String getCheckBoxName() {
        return IdeBundle.message((String)"checkbox.include.non.project.classes", (Object[])new Object[]{IdeUICustomization.getInstance().getProjectConceptName()});
    }

    public String getNotInMessage() {
        return IdeBundle.message((String)"label.no.matches.found.in.project", (Object[])new Object[]{IdeUICustomization.getInstance().getProjectConceptName()});
    }

    public String getNotFoundMessage() {
        return IdeBundle.message((String)"label.no.matches.found", (Object[])new Object[0]);
    }

    public char getCheckBoxMnemonic() {
        return SystemInfo.isMac ? (char)'P' : 'n';
    }

    public boolean loadInitialCheckBoxState() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        return Boolean.TRUE.toString().equals(propertiesComponent.getValue("GoToClass.toSaveIncludeLibraries")) && Boolean.TRUE.toString().equals(propertiesComponent.getValue("GoToClass.includeLibraries"));
    }

    public void saveInitialCheckBoxState(boolean state2) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        if (Boolean.TRUE.toString().equals(propertiesComponent.getValue("GoToClass.toSaveIncludeLibraries"))) {
            propertiesComponent.setValue("GoToClass.includeLibraries", Boolean.toString(state2));
        }
    }

    public String getFullName(Object element) {
        if (element instanceof PsiElement && !((PsiElement)element).isValid()) {
            return null;
        }
        for (ChooseByNameContributor c : this.getContributors()) {
            String result2;
            if (!(c instanceof GotoClassContributor) || (result2 = ((GotoClassContributor)c).getQualifiedName((NavigationItem)element)) == null) continue;
            return result2;
        }
        return this.getElementName(element);
    }

    @NotNull
    public String[] getSeparators() {
        if (this.mySeparators == null) {
            this.mySeparators = GotoClassModel2.getSeparatorsFromContributors(this.getContributors());
        }
        if (this.mySeparators == null) {
            GotoClassModel2.$$$reportNull$$$0(1);
        }
        return this.mySeparators;
    }

    public static String[] getSeparatorsFromContributors(ChooseByNameContributor[] contributors) {
        HashSet<String> separators = new HashSet<String>();
        separators.add(".");
        for (ChooseByNameContributor c : contributors) {
            if (!(c instanceof GotoClassContributor)) continue;
            ContainerUtil.addIfNotNull(separators, (Object)((GotoClassContributor)c).getQualifiedNameSeparator());
        }
        return ArrayUtil.toStringArray(separators);
    }

    @Override
    public String getHelpId() {
        return "procedures.navigating.goto.class";
    }

    @Override
    @NotNull
    public String removeModelSpecificMarkup(@NotNull String pattern) {
        if (pattern == null) {
            GotoClassModel2.$$$reportNull$$$0(2);
        }
        if (pattern.startsWith("@")) {
            String string = pattern.substring(1);
            if (string == null) {
                GotoClassModel2.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = pattern;
        if (string == null) {
            GotoClassModel2.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean willOpenEditor() {
        return true;
    }

    @Override
    public boolean sameNamesForProjectAndLibraries() {
        return !FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoClassModel2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoClassModel2";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparators";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "removeModelSpecificMarkup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeModelSpecificMarkup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

