/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.performance;

import com.intellij.internal.performance.FileTypeLatencyRecord;
import com.intellij.internal.performance.LatenciometerKt;
import com.intellij.internal.performance.LatencyRecord;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.util.Comparator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0014\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/internal/performance/TypingLatencyReportDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "intellij.platform.ide.impl"})
public final class TypingLatencyReportDialog
extends DialogWrapper {
    @NotNull
    protected JComponent createCenterPanel() {
        Iterable $receiver$iv;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        Iterable iterable = $receiver$iv = (Iterable)LatenciometerKt.getLatencyMap().values();
        Object object = new Comparator<T>(){

            public final int compare(T a, T b) {
                FileTypeLatencyRecord it = (FileTypeLatencyRecord)a;
                Comparable comparable = (Comparable)((Object)it.getFileType().getName());
                it = (FileTypeLatencyRecord)b;
                Comparable comparable2 = comparable;
                String string = it.getFileType().getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        for (FileTypeLatencyRecord row : CollectionsKt.sortedWith((Iterable)iterable, (Comparator)object)) {
            Iterable $receiver$iv2;
            DefaultMutableTreeNode rowNode = new DefaultMutableTreeNode(row);
            root.add(rowNode);
            Iterable iterable2 = $receiver$iv2 = (Iterable)row.getActionLatencyRecords().entrySet();
            Comparator comparator2 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)b;
                    Comparable comparable = Long.valueOf(((LatencyRecord)it.getValue()).getAverageLatency());
                    it = (Map.Entry)a;
                    Comparable comparable2 = comparable;
                    Long l = ((LatencyRecord)it.getValue()).getAverageLatency();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                }
            };
            object = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator2).iterator();
            while (object.hasNext()) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                Map.Entry actionLatencyRecord;
                Map.Entry entry = actionLatencyRecord = (Map.Entry)object.next();
                DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
                DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode;
                DefaultMutableTreeNode defaultMutableTreeNode4 = rowNode;
                Pair pair = new Pair(entry.getKey(), entry.getValue());
                defaultMutableTreeNode2(pair);
                defaultMutableTreeNode4.add(defaultMutableTreeNode3);
            }
        }
        Tree reportList = new Tree((TreeModel)new DefaultTreeModel(root));
        reportList.setRootVisible(false);
        reportList.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Intrinsics.checkParameterIsNotNull((Object)tree, (String)"tree");
                if (value == null) {
                    return;
                }
                Object obj = ((DefaultMutableTreeNode)value).getUserObject();
                if (obj instanceof FileTypeLatencyRecord) {
                    this.append(((FileTypeLatencyRecord)obj).getFileType().getName());
                    this.setIcon(((FileTypeLatencyRecord)obj).getFileType().getIcon());
                    this.appendLatencyRecord(((FileTypeLatencyRecord)obj).getTotalLatency());
                } else if (obj instanceof Pair) {
                    Pair pair = (Pair)obj;
                    this.append((String)pair.getFirst());
                    this.appendLatencyRecord((LatencyRecord)pair.getSecond());
                }
            }

            private final void appendLatencyRecord(LatencyRecord latencyRecord) {
                this.append(" - avg ");
                this.append(String.valueOf(latencyRecord.getAverageLatency()));
                this.append("ms, max ");
                this.append(String.valueOf(latencyRecord.getMaxLatency()));
                this.append("ms");
            }
        });
        TreeUtil.expandAll((JTree)((JTree)reportList));
        return (JComponent)new JBScrollPane((Component)reportList);
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[1];
        Action action = this.getOKAction();
        Intrinsics.checkExpressionValueIsNotNull((Object)action, (String)"okAction");
        actionArray[0] = action;
        return actionArray;
    }

    public TypingLatencyReportDialog(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project);
        this.init();
        this.setTitle("Typing Latency Report");
    }
}

