/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.application.options.PathMacrosImpl;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.components.CompositePathMacroFilter;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStorageCoreUtil {
    private static final Logger LOG = Logger.getInstance(FileStorageCoreUtil.class);
    public static final String COMPONENT = "component";
    public static final String NAME = "name";
    public static final String DEFAULT_EXT = ".xml";

    @NotNull
    public static Map<String, Element> load(@NotNull Element rootElement, @Nullable PathMacroSubstitutor pathMacroSubstitutor) {
        List children2;
        if (rootElement == null) {
            FileStorageCoreUtil.$$$reportNull$$$0(0);
        }
        if (pathMacroSubstitutor != null) {
            pathMacroSubstitutor.expandPaths(rootElement);
        }
        if ((children2 = rootElement.getChildren(COMPONENT)).isEmpty() && rootElement.getName().equals(COMPONENT) && rootElement.getAttributeValue(NAME) != null) {
            children2 = new SmartList((Object)rootElement);
        }
        CompositePathMacroFilter filter = null;
        TreeMap<String, Element> map2 = new TreeMap<String, Element>();
        Iterator iterator = children2.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String name = FileStorageCoreUtil.getComponentNameIfValid(element);
            if (name == null || element.getAttributes().size() <= 1 && element.getChildren().isEmpty()) continue;
            iterator.remove();
            if (pathMacroSubstitutor instanceof TrackingPathMacroSubstitutor) {
                if (filter == null) {
                    filter = new CompositePathMacroFilter((PathMacroFilter[])PathMacrosCollector.MACRO_FILTER_EXTENSION_POINT_NAME.getExtensions());
                }
                ((TrackingPathMacroSubstitutor)pathMacroSubstitutor).addUnknownMacros(name, PathMacrosCollector.getMacroNames(element, filter, PathMacrosImpl.getInstanceEx()));
            }
            element.removeAttribute(NAME);
            map2.put(name, JDOMUtil.internElement((Element)element));
        }
        TreeMap<String, Element> treeMap = map2;
        if (treeMap == null) {
            FileStorageCoreUtil.$$$reportNull$$$0(1);
        }
        return treeMap;
    }

    @Nullable
    static String getComponentNameIfValid(@NotNull Element element) {
        String name;
        if (element == null) {
            FileStorageCoreUtil.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)(name = element.getAttributeValue(NAME)))) {
            LOG.warn("No name attribute for component in " + JDOMUtil.writeElement((Element)element));
            return null;
        }
        return name;
    }

    @Nullable
    public static String findComponentName(@NotNull Element element) {
        Parent parent;
        if (element == null) {
            FileStorageCoreUtil.$$$reportNull$$$0(3);
        }
        Element componentElement = element;
        while ((parent = componentElement.getParent()) instanceof Element) {
            componentElement = (Element)parent;
        }
        return StringUtil.nullize((String)componentElement.getAttributeValue(NAME));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/impl/stores/FileStorageCoreUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/impl/stores/FileStorageCoreUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getComponentNameIfValid";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findComponentName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

