/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.util.Consumer;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorFilteringMarkupModelEx
implements MarkupModelEx {
    @NotNull
    private final EditorImpl myEditor;
    @NotNull
    private final MarkupModelEx myDelegate;
    private final Condition<RangeHighlighter> IS_AVAILABLE;

    EditorFilteringMarkupModelEx(@NotNull EditorImpl editor, @NotNull MarkupModelEx delegate) {
        if (editor == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(0);
        }
        if (delegate == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(1);
        }
        this.IS_AVAILABLE = this::isAvailable;
        this.myEditor = editor;
        this.myDelegate = delegate;
    }

    @NotNull
    public MarkupModelEx getDelegate() {
        MarkupModelEx markupModelEx = this.myDelegate;
        if (markupModelEx == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(2);
        }
        return markupModelEx;
    }

    private boolean isAvailable(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(3);
        }
        return highlighter.getEditorFilter().avaliableIn((Editor)this.myEditor) && this.myEditor.isHighlighterAvailable(highlighter);
    }

    @Override
    public boolean containsHighlighter(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(4);
        }
        return this.isAvailable(highlighter) && this.myDelegate.containsHighlighter(highlighter);
    }

    @Override
    public boolean processRangeHighlightersOverlappingWith(int start, int end, @NotNull Processor<? super RangeHighlighterEx> processor2) {
        if (processor2 == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(5);
        }
        FilteringProcessor filteringProcessor = new FilteringProcessor(this.IS_AVAILABLE, processor2);
        return this.myDelegate.processRangeHighlightersOverlappingWith(start, end, (Processor<? super RangeHighlighterEx>)filteringProcessor);
    }

    @Override
    public boolean processRangeHighlightersOutside(int start, int end, @NotNull Processor<? super RangeHighlighterEx> processor2) {
        if (processor2 == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(6);
        }
        FilteringProcessor filteringProcessor = new FilteringProcessor(this.IS_AVAILABLE, processor2);
        return this.myDelegate.processRangeHighlightersOutside(start, end, (Processor<? super RangeHighlighterEx>)filteringProcessor);
    }

    @Override
    @NotNull
    public MarkupIterator<RangeHighlighterEx> overlappingIterator(int startOffset, int endOffset) {
        MyFilteringIterator myFilteringIterator = new MyFilteringIterator(this.myDelegate.overlappingIterator(startOffset, endOffset));
        if (myFilteringIterator == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(7);
        }
        return myFilteringIterator;
    }

    @NotNull
    public RangeHighlighter[] getAllHighlighters() {
        List list2 = ContainerUtil.filter((Object[])this.myDelegate.getAllHighlighters(), this.IS_AVAILABLE);
        RangeHighlighter[] rangeHighlighterArray = list2.toArray(RangeHighlighter.EMPTY_ARRAY);
        if (rangeHighlighterArray == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(8);
        }
        return rangeHighlighterArray;
    }

    @Override
    public void dispose() {
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDelegate.getDocument();
        if (document == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(9);
        }
        return document;
    }

    @Override
    public void addMarkupModelListener(@NotNull Disposable parentDisposable, @NotNull MarkupModelListener listener2) {
        if (parentDisposable == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(10);
        }
        if (listener2 == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(11);
        }
        this.myDelegate.addMarkupModelListener(parentDisposable, listener2);
    }

    @Override
    public void fireAttributesChanged(@NotNull RangeHighlighterEx segmentHighlighter, boolean renderersChanged, boolean fontStyleOrColorChanged) {
        if (segmentHighlighter == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(12);
        }
        this.myDelegate.fireAttributesChanged(segmentHighlighter, renderersChanged, fontStyleOrColorChanged);
    }

    @Override
    public void fireAfterAdded(@NotNull RangeHighlighterEx segmentHighlighter) {
        if (segmentHighlighter == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(13);
        }
        this.myDelegate.fireAfterAdded(segmentHighlighter);
    }

    @Override
    public void fireBeforeRemoved(@NotNull RangeHighlighterEx segmentHighlighter) {
        if (segmentHighlighter == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(14);
        }
        this.myDelegate.fireBeforeRemoved(segmentHighlighter);
    }

    @Override
    @Nullable
    public RangeHighlighterEx addPersistentLineHighlighter(int lineNumber, int layer, TextAttributes textAttributes) {
        return this.myDelegate.addPersistentLineHighlighter(lineNumber, layer, textAttributes);
    }

    @Override
    public void addRangeHighlighter(@NotNull RangeHighlighterEx marker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (marker == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(15);
        }
        this.myDelegate.addRangeHighlighter(marker, start, end, greedyToLeft, greedyToRight, layer);
    }

    @NotNull
    public RangeHighlighter addRangeHighlighter(int startOffset, int endOffset, int layer, @Nullable TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea) {
        if (targetArea == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(16);
        }
        RangeHighlighter rangeHighlighter = this.myDelegate.addRangeHighlighter(startOffset, endOffset, layer, textAttributes, targetArea);
        if (rangeHighlighter == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(17);
        }
        return rangeHighlighter;
    }

    @NotNull
    public RangeHighlighter addLineHighlighter(int line, int layer, @Nullable TextAttributes textAttributes) {
        RangeHighlighter rangeHighlighter = this.myDelegate.addLineHighlighter(line, layer, textAttributes);
        if (rangeHighlighter == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(18);
        }
        return rangeHighlighter;
    }

    @Override
    @NotNull
    public RangeHighlighterEx addRangeHighlighterAndChangeAttributes(int startOffset, int endOffset, int layer, TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea, boolean isPersistent, Consumer<RangeHighlighterEx> changeAttributesAction) {
        if (targetArea == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(19);
        }
        RangeHighlighterEx rangeHighlighterEx = this.myDelegate.addRangeHighlighterAndChangeAttributes(startOffset, endOffset, layer, textAttributes, targetArea, isPersistent, changeAttributesAction);
        if (rangeHighlighterEx == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(20);
        }
        return rangeHighlighterEx;
    }

    @Override
    public void setRangeHighlighterAttributes(@NotNull RangeHighlighter highlighter, @NotNull TextAttributes textAttributes) {
        if (highlighter == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(21);
        }
        if (textAttributes == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(22);
        }
        this.myDelegate.setRangeHighlighterAttributes(highlighter, textAttributes);
    }

    @Override
    public void changeAttributesInBatch(@NotNull RangeHighlighterEx highlighter, @NotNull Consumer<RangeHighlighterEx> changeAttributesAction) {
        if (highlighter == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(23);
        }
        if (changeAttributesAction == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(24);
        }
        this.myDelegate.changeAttributesInBatch(highlighter, changeAttributesAction);
    }

    public void removeHighlighter(@NotNull RangeHighlighter rangeHighlighter) {
        if (rangeHighlighter == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(25);
        }
        this.myDelegate.removeHighlighter(rangeHighlighter);
    }

    public void removeAllHighlighters() {
        this.myDelegate.removeAllHighlighters();
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(26);
        }
        return (T)this.myDelegate.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            EditorFilteringMarkupModelEx.$$$reportNull$$$0(27);
        }
        this.myDelegate.putUserData(key, value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx";
                break;
            }
            case 3: 
            case 4: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segmentHighlighter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetArea";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeAttributesAction";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeHighlighter";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "overlappingIterator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllHighlighters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "addRangeHighlighter";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "addLineHighlighter";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "addRangeHighlighterAndChangeAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 20: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsHighlighter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processRangeHighlightersOverlappingWith";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processRangeHighlightersOutside";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addMarkupModelListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fireAttributesChanged";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fireAfterAdded";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeRemoved";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addRangeHighlighter";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addRangeHighlighterAndChangeAttributes";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setRangeHighlighterAttributes";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "changeAttributesInBatch";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removeHighlighter";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyFilteringIterator
    extends FilteringIterator<RangeHighlighterEx, RangeHighlighterEx>
    implements MarkupIterator<RangeHighlighterEx> {
        private final MarkupIterator<RangeHighlighterEx> myDelegate;

        MyFilteringIterator(MarkupIterator<RangeHighlighterEx> delegate) {
            if (delegate == null) {
                MyFilteringIterator.$$$reportNull$$$0(0);
            }
            super(delegate, EditorFilteringMarkupModelEx.this.IS_AVAILABLE);
            this.myDelegate = delegate;
        }

        @Override
        public void dispose() {
            this.myDelegate.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/openapi/editor/impl/EditorFilteringMarkupModelEx$MyFilteringIterator", "<init>"));
        }
    }
}

