/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.FoldRegionImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.SweepProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FoldRegionsTree {
    private final RangeMarkerTree<FoldRegionImpl> myMarkerTree;
    @NotNull
    private volatile CachedData myCachedData;
    private static final Comparator<FoldRegion> BY_END_OFFSET = Comparator.comparingInt(RangeMarker::getEndOffset);
    private static final Comparator<? super FoldRegion> BY_END_OFFSET_REVERSE = Collections.reverseOrder(BY_END_OFFSET);
    static final TObjectHashingStrategy<FoldRegion> OFFSET_BASED_HASHING_STRATEGY = new TObjectHashingStrategy<FoldRegion>(){

        public int computeHashCode(FoldRegion o) {
            return o.getStartOffset() * 31 + o.getEndOffset();
        }

        public boolean equals(FoldRegion o1, FoldRegion o2) {
            return o1.getStartOffset() == o2.getStartOffset() && o1.getEndOffset() == o2.getEndOffset();
        }
    };

    FoldRegionsTree(@NotNull RangeMarkerTree<FoldRegionImpl> markerTree) {
        if (markerTree == null) {
            FoldRegionsTree.$$$reportNull$$$0(0);
        }
        this.myCachedData = new CachedData();
        this.myMarkerTree = markerTree;
    }

    void clear() {
        this.clearCachedValues();
        this.myMarkerTree.clear();
    }

    void clearCachedValues() {
        this.myCachedData = new CachedData();
    }

    protected abstract boolean isFoldingEnabled();

    CachedData rebuild() {
        final ArrayList<FoldRegion> visible = new ArrayList<FoldRegion>(this.myMarkerTree.size());
        final ArrayList duplicatesToKill = new ArrayList();
        SweepProcessor.Generator generator = processor2 -> this.myMarkerTree.processOverlappingWith(0, Integer.MAX_VALUE, processor2);
        SweepProcessor.sweep(generator, new SweepProcessor<FoldRegionImpl>(){
            FoldRegionImpl lastRegion;
            FoldRegionImpl lastCollapsedRegion;

            @Override
            public boolean process(int offset, @NotNull FoldRegionImpl region, boolean atStart, @NotNull Collection<FoldRegionImpl> overlapping) {
                if (region == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (overlapping == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (atStart) {
                    if (this.sameRange(region, this.lastRegion)) {
                        if (region.isExpanded()) {
                            duplicatesToKill.add(region);
                            return true;
                        }
                        duplicatesToKill.add(this.lastRegion);
                        if (!visible.isEmpty() && this.lastRegion == visible.get(visible.size() - 1)) {
                            visible.remove(visible.size() - 1);
                        }
                        if (this.lastRegion == this.lastCollapsedRegion) {
                            this.lastCollapsedRegion = null;
                        }
                    }
                    this.lastRegion = region;
                    if (this.lastCollapsedRegion == null || region.getEndOffset() > this.lastCollapsedRegion.getEndOffset()) {
                        if (!region.isExpanded()) {
                            this.hideContainedRegions(region);
                            this.lastCollapsedRegion = region;
                        }
                        visible.add(region);
                    }
                }
                return true;
            }

            private void hideContainedRegions(FoldRegion region) {
                for (int i = visible.size() - 1; i >= 0 && region.getStartOffset() == ((FoldRegion)visible.get(i)).getStartOffset(); --i) {
                    visible.remove(i);
                }
            }

            private boolean sameRange(@NotNull FoldRegion region, @Nullable FoldRegion otherRegion) {
                if (region == null) {
                    2.$$$reportNull$$$0(2);
                }
                return otherRegion != null && region.getStartOffset() == otherRegion.getStartOffset() && region.getEndOffset() == otherRegion.getEndOffset();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "region";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "overlapping";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/editor/impl/FoldRegionsTree$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sameRange";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        for (FoldRegionImpl region : duplicatesToKill) {
            this.myMarkerTree.removeInterval(region);
        }
        FoldRegion[] visibleRegions = FoldRegionsTree.toFoldArray(visible);
        Arrays.sort(visibleRegions, BY_END_OFFSET_REVERSE);
        return this.updateCachedAndSortOffsets(visibleRegions, true);
    }

    @NotNull
    private static FoldRegion[] toFoldArray(@NotNull List<FoldRegion> topLevels) {
        if (topLevels == null) {
            FoldRegionsTree.$$$reportNull$$$0(1);
        }
        FoldRegion[] foldRegionArray = topLevels.isEmpty() ? FoldRegion.EMPTY_ARRAY : topLevels.toArray(FoldRegion.EMPTY_ARRAY);
        if (foldRegionArray == null) {
            FoldRegionsTree.$$$reportNull$$$0(2);
        }
        return foldRegionArray;
    }

    void updateCachedOffsets() {
        CachedData cachedData = this.myCachedData;
        this.updateCachedAndSortOffsets(cachedData.visibleRegions, false);
    }

    private CachedData updateCachedAndSortOffsets(FoldRegion[] visibleRegions, boolean fromRebuild) {
        CachedData data;
        if (!this.isFoldingEnabled()) {
            return null;
        }
        if (visibleRegions == null) {
            return this.rebuild();
        }
        ArrayList<FoldRegion> topLevel = new ArrayList<FoldRegion>(visibleRegions.length / 2);
        THashSet distinctRegions = new THashSet(visibleRegions.length, OFFSET_BASED_HASHING_STRATEGY);
        for (FoldRegion region : visibleRegions) {
            if (!region.isValid() || !distinctRegions.add(region)) {
                if (fromRebuild) {
                    throw new RuntimeExceptionWithAttachments("FoldRegionsTree.rebuild() failed", new Attachment[]{new Attachment("visibleRegions.txt", Arrays.toString(visibleRegions))});
                }
                return this.rebuild();
            }
            if (region.isExpanded()) continue;
            topLevel.add(region);
        }
        FoldRegion[] topLevelRegions = topLevel.toArray(FoldRegion.EMPTY_ARRAY);
        Arrays.sort(topLevelRegions, BY_END_OFFSET);
        int[] startOffsets = ArrayUtil.newIntArray((int)topLevelRegions.length);
        int[] endOffsets = ArrayUtil.newIntArray((int)topLevelRegions.length);
        int[] foldedLines = ArrayUtil.newIntArray((int)topLevelRegions.length);
        int sum = 0;
        for (int i = 0; i < topLevelRegions.length; ++i) {
            FoldRegion region = topLevelRegions[i];
            startOffsets[i] = region.getStartOffset();
            endOffsets[i] = region.getEndOffset() - 1;
            Document document = region.getDocument();
            foldedLines[i] = sum += document.getLineNumber(region.getEndOffset()) - document.getLineNumber(region.getStartOffset());
        }
        this.myCachedData = data = new CachedData(visibleRegions, topLevelRegions, startOffsets, endOffsets, foldedLines);
        return data;
    }

    boolean checkIfValidToCreate(int start, int end) {
        return this.myMarkerTree.processOverlappingWith(start, end, region -> {
            int rStart = region.getStartOffset();
            int rEnd = region.getEndOffset();
            if (rStart < start) {
                if (region.isValid() && start < rEnd && rEnd < end) {
                    return false;
                }
            } else if (rStart == start) {
                if (rEnd == end) {
                    return false;
                }
            } else {
                if (rStart > end) {
                    return true;
                }
                if (region.isValid() && rStart < end && end < rEnd) {
                    return false;
                }
            }
            return true;
        });
    }

    private CachedData ensureAvailableData() {
        CachedData cachedData = this.myCachedData;
        if (!cachedData.isAvailable()) {
            return this.rebuild();
        }
        return cachedData;
    }

    @Nullable
    FoldRegion fetchOutermost(int offset) {
        if (!this.isFoldingEnabled()) {
            return null;
        }
        CachedData cachedData = this.ensureAvailableData();
        int[] starts = cachedData.topStartOffsets;
        int[] ends = cachedData.topEndOffsets;
        if (starts == null || ends == null) {
            return null;
        }
        int start = 0;
        int end = ends.length - 1;
        while (start <= end) {
            int i = (start + end) / 2;
            if (offset < starts[i]) {
                end = i - 1;
                continue;
            }
            if (offset > ends[i]) {
                start = i + 1;
                continue;
            }
            return cachedData.topLevelRegions[i];
        }
        return null;
    }

    @Nullable
    FoldRegion[] fetchVisible() {
        if (!this.isFoldingEnabled()) {
            return null;
        }
        CachedData cachedData = this.ensureAvailableData();
        return cachedData.visibleRegions;
    }

    @Nullable
    FoldRegion[] fetchTopLevel() {
        if (!this.isFoldingEnabled()) {
            return null;
        }
        CachedData cachedData = this.ensureAvailableData();
        return cachedData.topLevelRegions;
    }

    static boolean containsStrict(FoldRegion region, int offset) {
        return region.getStartOffset() < offset && offset < region.getEndOffset();
    }

    @NotNull
    FoldRegion[] fetchCollapsedAt(int offset) {
        if (!this.isFoldingEnabled()) {
            if (FoldRegion.EMPTY_ARRAY == null) {
                FoldRegionsTree.$$$reportNull$$$0(3);
            }
            return FoldRegion.EMPTY_ARRAY;
        }
        ArrayList<FoldRegion> allCollapsed = new ArrayList<FoldRegion>();
        this.myMarkerTree.processContaining(offset, region -> {
            if (!region.isExpanded() && FoldRegionsTree.containsStrict(region, offset)) {
                allCollapsed.add((FoldRegion)region);
            }
            return true;
        });
        FoldRegion[] foldRegionArray = FoldRegionsTree.toFoldArray(allCollapsed);
        if (foldRegionArray == null) {
            FoldRegionsTree.$$$reportNull$$$0(4);
        }
        return foldRegionArray;
    }

    boolean intersectsRegion(int startOffset, int endOffset) {
        if (!this.isFoldingEnabled()) {
            return true;
        }
        return !this.myMarkerTree.processAll(region -> {
            boolean contains2;
            boolean contains1 = FoldRegionsTree.containsStrict(region, startOffset);
            return contains1 == (contains2 = FoldRegionsTree.containsStrict(region, endOffset));
        });
    }

    @NotNull
    FoldRegion[] fetchAllRegions() {
        if (!this.isFoldingEnabled()) {
            if (FoldRegion.EMPTY_ARRAY == null) {
                FoldRegionsTree.$$$reportNull$$$0(5);
            }
            return FoldRegion.EMPTY_ARRAY;
        }
        ArrayList<FoldRegion> regions = new ArrayList<FoldRegion>();
        this.myMarkerTree.processOverlappingWith(0, Integer.MAX_VALUE, (Processor)new CommonProcessors.CollectProcessor(regions));
        FoldRegion[] foldRegionArray = FoldRegionsTree.toFoldArray(regions);
        if (foldRegionArray == null) {
            FoldRegionsTree.$$$reportNull$$$0(6);
        }
        return foldRegionArray;
    }

    private void forEach(@NotNull Consumer<? super FoldRegion> consumer) {
        if (consumer == null) {
            FoldRegionsTree.$$$reportNull$$$0(7);
        }
        this.myMarkerTree.processAll(region -> {
            if (consumer == null) {
                FoldRegionsTree.$$$reportNull$$$0(8);
            }
            consumer.consume(region);
            return true;
        });
    }

    int getFoldedLinesCountBefore(int offset) {
        if (!this.isFoldingEnabled()) {
            return 0;
        }
        CachedData cachedData = this.ensureAvailableData();
        int idx = FoldRegionsTree.getLastTopLevelIndexBefore(cachedData, offset);
        if (idx == -1) {
            return 0;
        }
        return cachedData.topFoldedLines[idx];
    }

    int getTotalNumberOfFoldedLines() {
        if (!this.isFoldingEnabled()) {
            return 0;
        }
        CachedData cachedData = this.ensureAvailableData();
        int[] foldedLines = cachedData.topFoldedLines;
        if (foldedLines == null || foldedLines.length == 0) {
            return 0;
        }
        return foldedLines[foldedLines.length - 1];
    }

    int getLastTopLevelIndexBefore(int offset) {
        if (!this.isFoldingEnabled()) {
            return -1;
        }
        CachedData cachedData = this.ensureAvailableData();
        return FoldRegionsTree.getLastTopLevelIndexBefore(cachedData, offset);
    }

    private static int getLastTopLevelIndexBefore(CachedData cachedData, int offset) {
        int[] endOffsets = cachedData.topEndOffsets;
        if (endOffsets == null) {
            return -1;
        }
        --offset;
        int start = 0;
        int end = endOffsets.length - 1;
        while (start <= end) {
            int i = (start + end) / 2;
            if (offset < endOffsets[i]) {
                end = i - 1;
                continue;
            }
            if (offset > endOffsets[i]) {
                start = i + 1;
                continue;
            }
            return i;
        }
        return end;
    }

    @Nullable
    FoldRegion getRegionAt(int startOffset, int endOffset) {
        FoldRegionImpl[] found = new FoldRegionImpl[]{null};
        this.myMarkerTree.processOverlappingWith(startOffset, endOffset, region -> {
            if (region.getStartOffset() == startOffset && region.getEndOffset() == endOffset) {
                found[0] = region;
                return false;
            }
            return true;
        });
        return found[0];
    }

    void clearDocumentRangesModificationStatus() {
        this.forEach((Consumer<? super FoldRegion>)((Consumer)region -> ((FoldRegionImpl)region).resetDocumentRegionChanged()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerTree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevels";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FoldRegionsTree";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FoldRegionsTree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toFoldArray";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchCollapsedAt";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchAllRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toFoldArray";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$forEach$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedData {
        private final FoldRegion[] visibleRegions;
        private final FoldRegion[] topLevelRegions;
        private final int[] topStartOffsets;
        private final int[] topEndOffsets;
        private final int[] topFoldedLines;

        private CachedData() {
            this.visibleRegions = null;
            this.topLevelRegions = null;
            this.topStartOffsets = null;
            this.topEndOffsets = null;
            this.topFoldedLines = null;
        }

        private CachedData(@NotNull FoldRegion[] visibleRegions, @NotNull FoldRegion[] topLevelRegions, @NotNull int[] topStartOffsets, @NotNull int[] topEndOffsets, @NotNull int[] topFoldedLines) {
            if (visibleRegions == null) {
                CachedData.$$$reportNull$$$0(0);
            }
            if (topLevelRegions == null) {
                CachedData.$$$reportNull$$$0(1);
            }
            if (topStartOffsets == null) {
                CachedData.$$$reportNull$$$0(2);
            }
            if (topEndOffsets == null) {
                CachedData.$$$reportNull$$$0(3);
            }
            if (topFoldedLines == null) {
                CachedData.$$$reportNull$$$0(4);
            }
            this.visibleRegions = visibleRegions;
            this.topLevelRegions = topLevelRegions;
            this.topStartOffsets = topStartOffsets;
            this.topEndOffsets = topEndOffsets;
            this.topFoldedLines = topFoldedLines;
        }

        private boolean isAvailable() {
            return this.visibleRegions != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "visibleRegions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "topLevelRegions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "topStartOffsets";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "topEndOffsets";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "topFoldedLines";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/FoldRegionsTree$CachedData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

