/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.impl.FileManager;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ProjectRootUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.ProjectRootUtil");

    private ProjectRootUtil() {
    }

    @NotNull
    private static PsiDirectory[] convertRoots(Project project, VirtualFile[] roots) {
        PsiDirectory[] psiDirectoryArray = ProjectRootUtil.convertRoots(((PsiManagerImpl)PsiManager.getInstance((Project)project)).getFileManager(), roots);
        if (psiDirectoryArray == null) {
            ProjectRootUtil.$$$reportNull$$$0(0);
        }
        return psiDirectoryArray;
    }

    @NotNull
    private static PsiDirectory[] convertRoots(FileManager fileManager, VirtualFile[] roots) {
        ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
        for (VirtualFile root : roots) {
            PsiDirectory dir;
            if (!root.isValid()) {
                LOG.error("Root " + root + " is not valid!");
            }
            if ((dir = fileManager.findDirectory(root)) == null) continue;
            dirs.add(dir);
        }
        PsiDirectory[] psiDirectoryArray = dirs.toArray(PsiDirectory.EMPTY_ARRAY);
        if (psiDirectoryArray == null) {
            ProjectRootUtil.$$$reportNull$$$0(1);
        }
        return psiDirectoryArray;
    }

    @NotNull
    public static PsiDirectory[] getSourceRootDirectories(Project project) {
        VirtualFile[] files2 = OrderEnumerator.orderEntries((Project)project).sources().usingCache().getRoots();
        PsiDirectory[] psiDirectoryArray = ProjectRootUtil.convertRoots(project, files2);
        if (psiDirectoryArray == null) {
            ProjectRootUtil.$$$reportNull$$$0(2);
        }
        return psiDirectoryArray;
    }

    @NotNull
    public static PsiDirectory[] getAllContentRoots(Project project) {
        VirtualFile[] files2 = ProjectRootManager.getInstance((Project)project).getContentRootsFromAllModules();
        PsiDirectory[] psiDirectoryArray = ProjectRootUtil.convertRoots(project, files2);
        if (psiDirectoryArray == null) {
            ProjectRootUtil.$$$reportNull$$$0(3);
        }
        return psiDirectoryArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/projectRoots/impl/ProjectRootUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "convertRoots";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootDirectories";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllContentRoots";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

