/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.vfs.ContentRevisionVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class OpenRepositoryVersionAction
extends AnAction
implements DumbAware {
    public OpenRepositoryVersionAction() {
        super(VcsBundle.message((String)"open.repository.version.text", (Object[])new Object[0]), VcsBundle.message((String)"open.repository.version.description", (Object[])new Object[0]), null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenRepositoryVersionAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        Change[] changes = (Change[])e.getRequiredData(VcsDataKeys.SELECTED_CHANGES);
        OpenRepositoryVersionAction.openRepositoryVersion(project, changes);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenRepositoryVersionAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Change[] changes = (Change[])e.getData(VcsDataKeys.SELECTED_CHANGES);
        e.getPresentation().setEnabled(project != null && changes != null && !CommittedChangesBrowserUseCase.IN_AIR.equals(CommittedChangesBrowserUseCase.DATA_KEY.getData(e.getDataContext())) && OpenRepositoryVersionAction.hasValidChanges(changes) && ModalityState.NON_MODAL.equals(ModalityState.current()));
    }

    private static boolean hasValidChanges(@NotNull Change[] changes) {
        if (changes == null) {
            OpenRepositoryVersionAction.$$$reportNull$$$0(2);
        }
        return ContainerUtil.exists((Object[])changes, c -> c.getAfterRevision() != null && !c.getAfterRevision().getFile().isDirectory());
    }

    private static void openRepositoryVersion(@NotNull Project project, @NotNull Change[] changes) {
        if (project == null) {
            OpenRepositoryVersionAction.$$$reportNull$$$0(3);
        }
        if (changes == null) {
            OpenRepositoryVersionAction.$$$reportNull$$$0(4);
        }
        for (Change change : changes) {
            ContentRevision revision = change.getAfterRevision();
            if (revision == null || revision.getFile().isDirectory()) continue;
            ContentRevisionVirtualFile vFile = ContentRevisionVirtualFile.create(revision);
            OpenFileDescriptor navigatable = new OpenFileDescriptor(project, (VirtualFile)vFile);
            navigatable.navigate(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/OpenRepositoryVersionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasValidChanges";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "openRepositoryVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

