/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.local;

import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import com.intellij.util.EventDispatcher;

public class RemoveList
implements ChangeListCommand {
    private final String myName;
    private boolean myRemoved;
    private LocalChangeList myListCopy;
    private LocalChangeList myDefaultListCopy;

    public RemoveList(String name) {
        this.myName = name;
    }

    @Override
    public void apply(ChangeListWorker worker) {
        this.myListCopy = worker.getChangeListByName(this.myName);
        this.myDefaultListCopy = worker.getDefaultList();
        this.myRemoved = worker.removeChangeList(this.myName);
    }

    @Override
    public void doNotify(EventDispatcher<ChangeListListener> dispatcher) {
        if (this.myListCopy != null && this.myRemoved) {
            ChangeListListener multicaster = (ChangeListListener)dispatcher.getMulticaster();
            multicaster.changesMoved(this.myListCopy.getChanges(), (ChangeList)this.myListCopy, (ChangeList)this.myDefaultListCopy);
            multicaster.changeListRemoved((ChangeList)this.myListCopy);
        }
    }
}

