/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;

public class RestoreShelvedChange
extends DumbAwareAction {
    public RestoreShelvedChange() {
        super("Restore");
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ShelvedChangeList[] recycledChanges = (ShelvedChangeList[])e.getData(ShelvedChangesViewManager.SHELVED_RECYCLED_CHANGELIST_KEY);
        e.getPresentation().setText(VcsBundle.message((String)"vcs.shelf.action.restore.text", (Object[])new Object[0]));
        e.getPresentation().setDescription(VcsBundle.message((String)"vcs.shelf.action.restore.description", (Object[])new Object[0]));
        e.getPresentation().setEnabled(project != null && recycledChanges != null && recycledChanges.length == 1);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ShelvedChangeList[] recycledChanges = (ShelvedChangeList[])e.getData(ShelvedChangesViewManager.SHELVED_RECYCLED_CHANGELIST_KEY);
        if (recycledChanges != null && recycledChanges.length == 1) {
            ShelveChangesManager.getInstance(project).restoreList(recycledChanges[0]);
        }
    }
}

