/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalFileSystemImpl
extends LocalFileSystemBase
implements Disposable {
    private static final String FS_ROOT = "/";
    private static final int STATUS_UPDATE_PERIOD = 1000;
    private final ManagingFS myManagingFS;
    private final FileWatcher myWatcher;
    private final Object myLock;
    private final Set<WatchRequestImpl> myRootsToWatch;
    private TreeNode myNormalizedTree;

    public LocalFileSystemImpl(@NotNull Application app, @NotNull ManagingFS managingFS) {
        if (app == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(0);
        }
        if (managingFS == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(1);
        }
        this.myLock = new Object();
        this.myRootsToWatch = new THashSet();
        this.myManagingFS = managingFS;
        this.myWatcher = new FileWatcher(this.myManagingFS);
        if (this.myWatcher.isOperational()) {
            JobScheduler.getScheduler().scheduleWithFixedDelay(() -> {
                if (app == null) {
                    LocalFileSystemImpl.$$$reportNull$$$0(11);
                }
                if (!app.isDisposed()) {
                    this.storeRefreshStatusToFiles();
                }
            }, 1000L, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    @NotNull
    public FileWatcher getFileWatcher() {
        FileWatcher fileWatcher = this.myWatcher;
        if (fileWatcher == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(2);
        }
        return fileWatcher;
    }

    public void dispose() {
        this.myWatcher.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WatchRequestImpl> normalizeRootsForRefresh() {
        ArrayList<WatchRequestImpl> result2 = new ArrayList<WatchRequestImpl>();
        Object object = this.myLock;
        synchronized (object) {
            TreeNode rootNode = new TreeNode();
            for (WatchRequestImpl request : this.myRootsToWatch) {
                request.myDominated = false;
                String rootPath = request.getRootPath();
                TreeNode currentNode = rootNode;
                for (String subPath : LocalFileSystemImpl.splitPath(rootPath)) {
                    TreeNode nextNode = (TreeNode)currentNode.nodes.get(subPath);
                    if (nextNode != null) {
                        currentNode = nextNode;
                        if (currentNode.watchRequest == null || !currentNode.watchRequest.isToWatchRecursively()) continue;
                        request.myDominated = true;
                        break;
                    }
                    TreeNode newNode = new TreeNode();
                    currentNode.nodes.put(subPath, newNode);
                    currentNode = newNode;
                }
                if (currentNode.watchRequest == null) {
                    currentNode.watchRequest = request;
                } else if (!currentNode.watchRequest.isToWatchRecursively()) {
                    currentNode.watchRequest.myDominated = true;
                    currentNode.watchRequest = request;
                } else {
                    request.myDominated = true;
                }
                if (!currentNode.watchRequest.isToWatchRecursively() || currentNode.nodes.isEmpty()) continue;
                LocalFileSystemImpl.visitTree(currentNode, (Consumer<TreeNode>)((Consumer)node -> {
                    if (((TreeNode)node).watchRequest != null) {
                        ((TreeNode)node).watchRequest.myDominated = true;
                    }
                }));
                currentNode.nodes.clear();
            }
            LocalFileSystemImpl.visitTree(rootNode, (Consumer<TreeNode>)((Consumer)node -> {
                if (((TreeNode)node).watchRequest != null) {
                    result2.add(((TreeNode)node).watchRequest);
                }
            }));
            this.myNormalizedTree = rootNode;
        }
        return result2;
    }

    @NotNull
    private static List<String> splitPath(@NotNull String path) {
        if (path == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(3);
        }
        if (path.isEmpty()) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                LocalFileSystemImpl.$$$reportNull$$$0(4);
            }
            return list2;
        }
        if (FS_ROOT.equals(path)) {
            List<String> list3 = Collections.singletonList(FS_ROOT);
            if (list3 == null) {
                LocalFileSystemImpl.$$$reportNull$$$0(5);
            }
            return list3;
        }
        List parts = StringUtil.split((String)path, (String)FS_ROOT);
        if (StringUtil.startsWithChar((CharSequence)path, (char)'/')) {
            parts.add(0, FS_ROOT);
        }
        List list4 = parts;
        if (list4 == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(6);
        }
        return list4;
    }

    private static void visitTree(TreeNode rootNode, Consumer<TreeNode> consumer) {
        for (TreeNode node : rootNode.nodes.values()) {
            consumer.consume((Object)node);
            LocalFileSystemImpl.visitTree(node, consumer);
        }
    }

    private boolean isAlreadyWatched(WatchRequestImpl request) {
        if (this.myNormalizedTree == null) {
            this.normalizeRootsForRefresh();
        }
        String rootPath = request.getRootPath();
        TreeNode currentNode = this.myNormalizedTree;
        for (String subPath : LocalFileSystemImpl.splitPath(rootPath)) {
            TreeNode nextNode = (TreeNode)currentNode.nodes.get(subPath);
            if (nextNode == null) {
                return false;
            }
            currentNode = nextNode;
            if (currentNode.watchRequest == null || !currentNode.watchRequest.isToWatchRecursively()) continue;
            return true;
        }
        return !request.isToWatchRecursively() && currentNode.watchRequest != null;
    }

    private void storeRefreshStatusToFiles() {
        if (this.myWatcher.isOperational()) {
            FileWatcher.DirtyPaths dirtyPaths = this.myWatcher.getDirtyPaths();
            this.markPathsDirty(dirtyPaths.dirtyPaths);
            this.markFlatDirsDirty(dirtyPaths.dirtyDirectories);
            this.markRecursiveDirsDirty(dirtyPaths.dirtyPathsRecursive);
        }
    }

    private void markPathsDirty(Iterable<String> dirtyPaths) {
        for (String dirtyPath : dirtyPaths) {
            VirtualFile file2 = this.findFileByPathIfCached(dirtyPath);
            if (!(file2 instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)file2).markDirty();
        }
    }

    private void markFlatDirsDirty(Iterable<String> dirtyPaths) {
        for (String dirtyPath : dirtyPaths) {
            Pair<NewVirtualFile, NewVirtualFile> pair = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)this, dirtyPath);
            if (pair.first != null) {
                ((NewVirtualFile)pair.first).markDirty();
                for (VirtualFile child : ((NewVirtualFile)pair.first).getCachedChildren()) {
                    ((NewVirtualFile)child).markDirty();
                }
                continue;
            }
            if (pair.second == null) continue;
            ((NewVirtualFile)pair.second).markDirty();
        }
    }

    private void markRecursiveDirsDirty(Iterable<String> dirtyPaths) {
        for (String dirtyPath : dirtyPaths) {
            Pair<NewVirtualFile, NewVirtualFile> pair = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)this, dirtyPath);
            if (pair.first != null) {
                ((NewVirtualFile)pair.first).markDirtyRecursively();
                continue;
            }
            if (pair.second == null) continue;
            ((NewVirtualFile)pair.second).markDirty();
        }
    }

    public void markSuspiciousFilesDirty(@NotNull List<VirtualFile> files2) {
        if (files2 == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(7);
        }
        this.storeRefreshStatusToFiles();
        if (this.myWatcher.isOperational()) {
            for (String root : this.myWatcher.getManualWatchRoots()) {
                VirtualFile suspiciousRoot = this.findFileByPathIfCached(root);
                if (suspiciousRoot == null) continue;
                ((NewVirtualFile)suspiciousRoot).markDirtyRecursively();
            }
        } else {
            for (VirtualFile file2 : files2) {
                if (file2.getFileSystem() != this) continue;
                ((NewVirtualFile)file2).markDirtyRecursively();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<LocalFileSystem.WatchRequest> replaceWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> watchRequests, @Nullable Collection<String> recursiveRoots, @Nullable Collection<String> flatRoots) {
        if (watchRequests == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(8);
        }
        recursiveRoots = (Collection)ObjectUtils.notNull(recursiveRoots, Collections.emptyList());
        flatRoots = (Collection)ObjectUtils.notNull(flatRoots, Collections.emptyList());
        HashSet<LocalFileSystem.WatchRequest> result2 = new HashSet<LocalFileSystem.WatchRequest>();
        Object object = this.myLock;
        synchronized (object) {
            boolean update = this.doAddRootsToWatch(recursiveRoots, flatRoots, result2) | this.doRemoveWatchedRoots(watchRequests);
            if (update) {
                this.myNormalizedTree = null;
                this.setUpFileWatcher();
            }
        }
        HashSet<LocalFileSystem.WatchRequest> hashSet = result2;
        if (hashSet == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    private boolean doAddRootsToWatch(Collection<String> recursiveRoots, Collection<String> flatRoots, Set<LocalFileSystem.WatchRequest> results) {
        boolean alreadyWatched;
        WatchRequestImpl request;
        boolean update = false;
        for (String root : recursiveRoots) {
            request = LocalFileSystemImpl.watch(root, true);
            if (request == null) continue;
            alreadyWatched = this.isAlreadyWatched(request);
            request.myDominated = alreadyWatched;
            this.myRootsToWatch.add(request);
            results.add(request);
            update |= !alreadyWatched;
        }
        for (String root : flatRoots) {
            request = LocalFileSystemImpl.watch(root, false);
            if (request == null) continue;
            alreadyWatched = this.isAlreadyWatched(request);
            request.myDominated = alreadyWatched;
            this.myRootsToWatch.add(request);
            results.add(request);
            update |= !alreadyWatched;
        }
        return update;
    }

    @Nullable
    private static WatchRequestImpl watch(String rootPath, boolean recursively) {
        File rootFile;
        int index = rootPath.indexOf("!/");
        if (index >= 0) {
            rootPath = rootPath.substring(0, index);
        }
        if (!(rootFile = new File(FileUtil.toSystemDependentName((String)rootPath))).isAbsolute()) {
            LOG.warn("Invalid path: " + rootPath);
            return null;
        }
        return new WatchRequestImpl(rootFile.getAbsolutePath(), recursively);
    }

    private boolean doRemoveWatchedRoots(@NotNull Collection<LocalFileSystem.WatchRequest> watchRequests) {
        if (watchRequests == null) {
            LocalFileSystemImpl.$$$reportNull$$$0(10);
        }
        boolean update = false;
        for (LocalFileSystem.WatchRequest watchRequest : watchRequests) {
            WatchRequestImpl impl = (WatchRequestImpl)watchRequest;
            boolean wasWatched = this.myRootsToWatch.remove(impl) && !impl.myDominated;
            update |= wasWatched;
        }
        return update;
    }

    private void setUpFileWatcher() {
        if (!ApplicationManager.getApplication().isDisposeInProgress() && this.myWatcher.isOperational()) {
            ArrayList<String> recursiveRoots = new ArrayList<String>();
            ArrayList<String> flatRoots = new ArrayList<String>();
            for (WatchRequestImpl request : this.normalizeRootsForRefresh()) {
                (request.isToWatchRecursively() ? recursiveRoots : flatRoots).add(request.myFSRootPath);
            }
            this.myWatcher.setWatchRoots(recursiveRoots, flatRoots);
        }
    }

    public void refreshWithoutFileWatcher(boolean asynchronous) {
        Runnable heavyRefresh = () -> {
            for (VirtualFile root : this.myManagingFS.getRoots((NewVirtualFileSystem)this)) {
                ((NewVirtualFile)root).markDirtyRecursively();
            }
            this.refresh(asynchronous);
        };
        if (asynchronous && this.myWatcher.isOperational()) {
            RefreshQueue.getInstance().refresh(true, true, heavyRefresh, this.myManagingFS.getRoots((NewVirtualFileSystem)this));
        } else {
            heavyRefresh.run();
        }
    }

    public String toString() {
        return "LocalFileSystem";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupForNextTest() {
        FileDocumentManager.getInstance().saveAllDocuments();
        PersistentFS.getInstance().clearIdCache();
        Object object = this.myLock;
        synchronized (object) {
            this.myRootsToWatch.clear();
            this.myNormalizedTree = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managingFS";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileWatcher";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWatchedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "markSuspiciousFilesDirty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceWatchedRoots";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveWatchedRoots";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TreeNode {
        private WatchRequestImpl watchRequest;
        private final Map<String, TreeNode> nodes = new THashMap(1, FileUtil.PATH_HASHING_STRATEGY);

        private TreeNode() {
        }
    }

    private static class WatchRequestImpl
    implements LocalFileSystem.WatchRequest {
        private final String myFSRootPath;
        private final boolean myWatchRecursively;
        private boolean myDominated;

        WatchRequestImpl(String rootPath, boolean watchRecursively) {
            this.myFSRootPath = rootPath;
            this.myWatchRecursively = watchRecursively;
        }

        @NotNull
        public String getRootPath() {
            String string = FileUtil.toSystemIndependentName((String)this.myFSRootPath);
            if (string == null) {
                WatchRequestImpl.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean isToWatchRecursively() {
            return this.myWatchRecursively;
        }

        public String toString() {
            return this.getRootPath();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/LocalFileSystemImpl$WatchRequestImpl", "getRootPath"));
        }
    }
}

