/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.stubs.StubProcessingHelperBase;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class StubProcessingHelper
extends StubProcessingHelperBase {
    private final FileBasedIndex myFileBasedIndex;
    private final ThreadLocal<Set<VirtualFile>> myFilesHavingProblems = new ThreadLocal();

    public StubProcessingHelper(FileBasedIndex fileBasedIndex) {
        this.myFileBasedIndex = fileBasedIndex;
    }

    @Override
    protected void onInternalError(VirtualFile file2) {
        THashSet set2 = this.myFilesHavingProblems.get();
        if (set2 == null) {
            set2 = new THashSet();
            this.myFilesHavingProblems.set((Set<VirtualFile>)set2);
        }
        set2.add((VirtualFile)file2);
        ApplicationManager.getApplication().invokeLater(() -> this.myFileBasedIndex.requestReindex(file2), ModalityState.NON_MODAL);
    }

    @Nullable
    Set<VirtualFile> takeAccumulatedFilesWithIndexProblems() {
        Set<VirtualFile> filesWithProblems = this.myFilesHavingProblems.get();
        if (filesWithProblems != null) {
            this.myFilesHavingProblems.set(null);
        }
        return filesWithProblems;
    }
}

