/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import gnu.trove.TIntArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListSpeedSearch<T>
extends SpeedSearchBase<JList<T>> {
    @Nullable
    private final Function<T, String> myToStringConvertor;

    public ListSpeedSearch(JList<T> list2) {
        super(list2);
        this.myToStringConvertor = null;
        this.registerSelectAll(list2);
    }

    public ListSpeedSearch(JList<T> list2, @NotNull Function<T, String> convertor) {
        if (convertor == null) {
            ListSpeedSearch.$$$reportNull$$$0(0);
        }
        super(list2);
        this.myToStringConvertor = convertor;
        this.registerSelectAll(list2);
    }

    public ListSpeedSearch(JList<T> list2, @Nullable Convertor<T, String> convertor) {
        super(list2);
        this.myToStringConvertor = convertor == null ? null : arg_0 -> convertor.convert(arg_0);
        this.registerSelectAll(list2);
    }

    private void registerSelectAll(JList<T> list2) {
        new MySelectAllAction(list2, this).registerCustomShortcutSet(list2, null);
    }

    @Override
    protected void selectElement(Object element, String selectedText) {
        if (element != null) {
            ScrollingUtil.selectItem((JList)((JList)this.myComponent), (Object)element);
        } else {
            ((JList)this.myComponent).clearSelection();
        }
    }

    @Override
    protected int getSelectedIndex() {
        return ((JList)this.myComponent).getSelectedIndex();
    }

    @Override
    @NotNull
    protected Object[] getAllElements() {
        Object[] objectArray = ListSpeedSearch.getAllListElements((JList)this.myComponent);
        if (objectArray == null) {
            ListSpeedSearch.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    public static Object[] getAllListElements(JList list2) {
        ListModel model = list2.getModel();
        if (model instanceof DefaultListModel) {
            return ((DefaultListModel)model).toArray();
        }
        Object[] elements = new Object[model.getSize()];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = model.getElementAt(i);
        }
        return elements;
    }

    @Override
    protected String getElementText(Object element) {
        if (this.myToStringConvertor != null) {
            return (String)this.myToStringConvertor.fun(element);
        }
        return element == null ? null : element.toString();
    }

    @NotNull
    private TIntArrayList findAllFilteredElements(String s) {
        TIntArrayList indices = new TIntArrayList();
        String _s = s.trim();
        Object[] elements = ListSpeedSearch.getAllListElements((JList)this.myComponent);
        for (int i = 0; i < elements.length; ++i) {
            Object element = elements[i];
            if (!this.isMatchingElement(element, _s)) continue;
            indices.add(i);
        }
        TIntArrayList tIntArrayList = indices;
        if (tIntArrayList == null) {
            ListSpeedSearch.$$$reportNull$$$0(2);
        }
        return tIntArrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ListSpeedSearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ListSpeedSearch";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllFilteredElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySelectAllAction
    extends DumbAwareAction {
        @NotNull
        private final JList myList;
        @NotNull
        private final ListSpeedSearch mySearch;

        MySelectAllAction(@NotNull JList list2, @NotNull ListSpeedSearch search2) {
            if (list2 == null) {
                MySelectAllAction.$$$reportNull$$$0(0);
            }
            if (search2 == null) {
                MySelectAllAction.$$$reportNull$$$0(1);
            }
            this.myList = list2;
            this.mySearch = search2;
            AnAction action = ActionManager.getInstance().getAction("$SelectAll");
            if (action != null) {
                this.copyShortcutFrom(action);
            }
            this.setEnabledInModalContext(true);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.mySearch.isPopupActive() && this.myList.getSelectionModel().getSelectionMode() == 2);
        }

        public void actionPerformed(AnActionEvent e) {
            ListSelectionModel sm = this.myList.getSelectionModel();
            String query = this.mySearch.getEnteredPrefix();
            if (query == null) {
                return;
            }
            TIntArrayList filtered = this.mySearch.findAllFilteredElements(query);
            if (filtered.isEmpty()) {
                return;
            }
            boolean alreadySelected = Arrays.equals(filtered.toNativeArray(), this.myList.getSelectedIndices());
            if (alreadySelected) {
                int anchor2 = this.myList.getAnchorSelectionIndex();
                this.myList.setSelectedIndex(anchor2);
                sm.setAnchorSelectionIndex(anchor2);
                this.mySearch.findAndSelectElement(query);
            } else {
                int anchor3 = -1;
                Object currentElement = this.mySearch.findElement(query);
                if (currentElement != null) {
                    List<Object> elements = Arrays.asList(ListSpeedSearch.getAllListElements(this.myList));
                    anchor3 = ContainerUtil.indexOfIdentity(elements, (Object)currentElement);
                }
                if (anchor3 == -1) {
                    anchor3 = filtered.get(0);
                }
                this.myList.setSelectedIndices(filtered.toNativeArray());
                sm.setAnchorSelectionIndex(anchor3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "list";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "search";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/ListSpeedSearch$MySelectAllAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

