/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.NotNull;

public class TreeSpeedSearch
extends SpeedSearchBase<JTree> {
    private final boolean myCanExpand;
    private static final Convertor<TreePath, String> TO_STRING = path -> path.getLastPathComponent().toString();
    private final Convertor<TreePath, String> myToStringConvertor;
    public static final Convertor<TreePath, String> NODE_DESCRIPTOR_TOSTRING = path -> {
        NodeDescriptor descriptor2 = (NodeDescriptor)TreeUtil.getUserObject(NodeDescriptor.class, (Object)path.getLastPathComponent());
        if (descriptor2 != null) {
            return descriptor2.toString();
        }
        return (String)TO_STRING.convert(path);
    };

    public TreeSpeedSearch(JTree tree, Convertor<TreePath, String> toStringConvertor) {
        this(tree, toStringConvertor, false);
    }

    public TreeSpeedSearch(JTree tree) {
        this(tree, TO_STRING);
    }

    public TreeSpeedSearch(Tree tree, Convertor<TreePath, String> toString) {
        this(tree, toString, false);
    }

    public TreeSpeedSearch(Tree tree, Convertor<TreePath, String> toString, boolean canExpand) {
        this((JTree)tree, toString, canExpand);
    }

    public TreeSpeedSearch(JTree tree, Convertor<TreePath, String> toString, boolean canExpand) {
        super(tree);
        this.setComparator(new SpeedSearchComparator(false, true));
        this.myToStringConvertor = toString;
        this.myCanExpand = canExpand;
        new MySelectAllAction(tree, this).registerCustomShortcutSet(tree, null);
    }

    @Override
    protected void selectElement(Object element, String selectedText) {
        TreeUtil.selectPath((JTree)((JTree)this.myComponent), (TreePath)((TreePath)element));
    }

    @Override
    protected int getSelectedIndex() {
        if (this.myCanExpand) {
            return ArrayUtilRt.find((Object[])this.getAllElements(), (Object)((JTree)this.myComponent).getSelectionPath());
        }
        int[] selectionRows = ((JTree)this.myComponent).getSelectionRows();
        return selectionRows == null || selectionRows.length == 0 ? -1 : selectionRows[0];
    }

    @Override
    @NotNull
    protected Object[] getAllElements() {
        JBIterable paths;
        if (this.myCanExpand) {
            paths = TreeUtil.treePathTraverser((JTree)((JTree)this.myComponent)).traverse();
        } else {
            Object[] arr = new TreePath[((JTree)this.myComponent).getRowCount()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = ((JTree)this.myComponent).getPathForRow(i);
            }
            paths = JBIterable.of((Object[])arr);
        }
        List result2 = paths.filter(o -> !(o.getLastPathComponent() instanceof LoadingNode)).toList();
        Object[] objectArray = result2.toArray(new TreePath[0]);
        if (objectArray == null) {
            TreeSpeedSearch.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    @Override
    protected String getElementText(Object element) {
        TreePath path = (TreePath)element;
        String string = (String)this.myToStringConvertor.convert((Object)path);
        if (string == null) {
            return (String)TO_STRING.convert((Object)path);
        }
        return string;
    }

    @NotNull
    private List<TreePath> findAllFilteredElements(String s) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        String _s = s.trim();
        ListIterator<Object> it = this.getElementIterator(0);
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.isMatchingElement(element, _s)) continue;
            paths.add((TreePath)element);
        }
        ArrayList<TreePath> arrayList = paths;
        if (arrayList == null) {
            TreeSpeedSearch.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ui/TreeSpeedSearch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllFilteredElements";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MySelectAllAction
    extends DumbAwareAction {
        @NotNull
        private final JTree myTree;
        @NotNull
        private final TreeSpeedSearch mySearch;

        public MySelectAllAction(@NotNull JTree tree, @NotNull TreeSpeedSearch search2) {
            if (tree == null) {
                MySelectAllAction.$$$reportNull$$$0(0);
            }
            if (search2 == null) {
                MySelectAllAction.$$$reportNull$$$0(1);
            }
            this.myTree = tree;
            this.mySearch = search2;
            this.copyShortcutFrom(ActionManager.getInstance().getAction("$SelectAll"));
            this.setEnabledInModalContext(true);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.mySearch.isPopupActive() && this.myTree.getSelectionModel().getSelectionMode() == 4);
        }

        public void actionPerformed(AnActionEvent e) {
            boolean alreadySelected;
            TreeSelectionModel sm = this.myTree.getSelectionModel();
            String query = this.mySearch.getEnteredPrefix();
            if (query == null) {
                return;
            }
            List filtered = this.mySearch.findAllFilteredElements(query);
            if (filtered.isEmpty()) {
                return;
            }
            boolean bl = alreadySelected = sm.getSelectionCount() == filtered.size() && ContainerUtil.and((Iterable)filtered, path -> sm.isPathSelected((TreePath)path));
            if (alreadySelected) {
                TreePath anchor2 = this.myTree.getAnchorSelectionPath();
                sm.setSelectionPath(anchor2);
                this.myTree.setAnchorSelectionPath(anchor2);
                this.mySearch.findAndSelectElement(query);
            } else {
                TreePath currentElement = (TreePath)this.mySearch.findElement(query);
                TreePath anchor3 = (TreePath)ObjectUtils.chooseNotNull((Object)currentElement, filtered.get(0));
                sm.setSelectionPaths((TreePath[])ArrayUtil.toObjectArray((Collection)filtered, TreePath.class));
                this.myTree.setAnchorSelectionPath(anchor3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "search";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/TreeSpeedSearch$MySelectAllAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

