/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.util.Condition;
import com.intellij.ui.mac.touchbar.BarContainer;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.TouchBar;
import java.util.ArrayDeque;
import java.util.Collection;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackTouchBars {
    private final ArrayDeque<BarContainer> myContainersStack = new ArrayDeque();
    private final TouchBarHolder myTouchBarHolder = new TouchBarHolder();
    private long myCurrentKeyMask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateKeyMask(long newMask) {
        if (this.myCurrentKeyMask != newMask) {
            StackTouchBars stackTouchBars = this;
            synchronized (stackTouchBars) {
                this.myCurrentKeyMask = newMask;
                this._setTouchBarFromTopContainer();
            }
        }
    }

    @Nullable
    synchronized TouchBar getTopTouchBar() {
        BarContainer topContainer = this.myContainersStack.peek();
        return topContainer == null ? null : topContainer.get();
    }

    synchronized void pop(@Nullable Condition<BarContainer> condition) {
        BarContainer top = this.myContainersStack.peek();
        if (top == null) {
            return;
        }
        if (condition != null && !condition.value((Object)top)) {
            return;
        }
        this.myContainersStack.pop();
        this._setTouchBarFromTopContainer();
    }

    synchronized void removeAll(@NotNull Collection<BarContainer> toErase) {
        if (toErase == null) {
            StackTouchBars.$$$reportNull$$$0(0);
        }
        this.myContainersStack.removeAll(toErase);
        this._setTouchBarFromTopContainer();
    }

    synchronized void setTouchBarFromTopContainer() {
        this._setTouchBarFromTopContainer();
    }

    synchronized void showContainer(BarContainer bar) {
        if (bar == null) {
            return;
        }
        BarContainer top = this.myContainersStack.peek();
        if (top == bar) {
            return;
        }
        this.myContainersStack.remove(bar);
        this.myContainersStack.push(bar);
        this._setTouchBarFromTopContainer();
    }

    synchronized void removeContainer(BarContainer tb) {
        if (tb == null || this.myContainersStack.isEmpty()) {
            return;
        }
        tb.onHide();
        BarContainer top = this.myContainersStack.peek();
        if (top == tb) {
            this.myContainersStack.pop();
            this._setTouchBarFromTopContainer();
        } else {
            this.myContainersStack.remove(tb);
        }
    }

    synchronized void elevateContainer(BarContainer bar) {
        boolean preserveTop;
        if (bar == null) {
            return;
        }
        BarContainer top = this.myContainersStack.peek();
        if (top == bar) {
            return;
        }
        boolean bl = preserveTop = top != null && (top.isPopup() || top.isDialog() || top.get().isManualClose());
        if (preserveTop) {
            this.myContainersStack.remove(bar);
            this.myContainersStack.remove(top);
            this.myContainersStack.push(bar);
            this.myContainersStack.push(top);
        } else {
            this.myContainersStack.remove(bar);
            this.myContainersStack.push(bar);
            this._setTouchBarFromTopContainer();
        }
    }

    private void _setTouchBarFromTopContainer() {
        if (this.myContainersStack.isEmpty()) {
            this.myTouchBarHolder.setTouchBar(null);
            return;
        }
        BarContainer top = this.myContainersStack.peek();
        top.selectBarByKeyMask(this.myCurrentKeyMask);
        this.myTouchBarHolder.setTouchBar(top.get());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toErase", "com/intellij/ui/mac/touchbar/StackTouchBars", "removeAll"));
    }

    private static class TouchBarHolder {
        private TouchBar myCurrentBar;
        private TouchBar myNextBar;

        private TouchBarHolder() {
        }

        synchronized void setTouchBar(TouchBar bar) {
            this.myNextBar = bar;
            Timer timer = new Timer(100, event -> this._setNextTouchBar());
            timer.setRepeats(false);
            timer.start();
        }

        synchronized void updateCurrent() {
            if (this.myCurrentBar != null) {
                this.myCurrentBar.updateActionItems();
            }
        }

        private synchronized void _setNextTouchBar() {
            if (this.myCurrentBar == this.myNextBar) {
                return;
            }
            if (this.myCurrentBar != null) {
                this.myCurrentBar.onHide();
            }
            this.myCurrentBar = this.myNextBar;
            if (this.myCurrentBar != null) {
                this.myCurrentBar.onBeforeShow();
            }
            NST.setTouchBar(this.myCurrentBar);
        }
    }
}

