/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.plaf.beg;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.plaf.beg.BegResources;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicMenuUI;

public class IdeaMenuUI
extends BasicMenuUI {
    private static final Rectangle ourZeroRect = new Rectangle(0, 0, 0, 0);
    private static final Rectangle ourTextRect = new Rectangle();
    private static final Rectangle ourArrowIconRect = new Rectangle();
    private int myMaxGutterIconWidth = JBUI.scale((int)18);
    private int a;
    private static Rectangle ourPreferredSizeRect = new Rectangle();
    private int k;
    private int e;
    private static final Rectangle ourAcceleratorRect = new Rectangle();
    private static final Rectangle ourCheckIconRect = new Rectangle();
    private static final Rectangle ourIconRect = new Rectangle();
    private static final Rectangle ourViewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    private Border myAquaSelectedBackgroundPainter;
    private Icon myAquaInvertedArrowIcon;
    private Icon myAquaDisabledArrowIcon;

    public static ComponentUI createUI(JComponent component) {
        return new IdeaMenuUI();
    }

    public IdeaMenuUI() {
        if (UIUtil.isUnderAquaLookAndFeel() || UIUtil.isUnderIntelliJLaF()) {
            if (this.myAquaSelectedBackgroundPainter == null) {
                this.myAquaSelectedBackgroundPainter = (Border)UIManager.get("MenuItem.selectedBackgroundPainter");
            }
            if (this.myAquaInvertedArrowIcon == null) {
                this.myAquaInvertedArrowIcon = (Icon)UIManager.get("Menu.invertedArrowIcon");
            }
            if (this.myAquaDisabledArrowIcon == null) {
                this.myAquaDisabledArrowIcon = (Icon)UIManager.get("Menu.disabledArrowIcon");
            }
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Integer integer = UIUtil.getPropertyMaxGutterIconWidth((String)this.getPropertyPrefix());
        if (integer != null) {
            this.myMaxGutterIconWidth = integer;
        }
    }

    @Override
    public void paint(Graphics g, JComponent comp) {
        UISettings.setupAntialiasing((Graphics)g);
        JMenu jMenu = (JMenu)comp;
        ButtonModel buttonmodel = jMenu.getModel();
        int mnemonicIndex = jMenu.getDisplayedMnemonicIndex();
        Icon icon = this.getIcon();
        Icon allowedIcon = this.getAllowedIcon();
        Insets insets = comp.getInsets();
        this.resetRects();
        ourViewRect.setBounds(0, 0, jMenu.getWidth(), jMenu.getHeight());
        IdeaMenuUI.ourViewRect.x += insets.left;
        IdeaMenuUI.ourViewRect.y += insets.top;
        IdeaMenuUI.ourViewRect.width -= insets.right + IdeaMenuUI.ourViewRect.x;
        IdeaMenuUI.ourViewRect.height -= insets.bottom + IdeaMenuUI.ourViewRect.y;
        Font font = g.getFont();
        Font font1 = comp.getFont();
        g.setFont(font1);
        FontMetrics fontmetrics = g.getFontMetrics(font1);
        String s1 = this.layoutMenuItem(fontmetrics, jMenu.getText(), icon, allowedIcon, this.arrowIcon, jMenu.getVerticalAlignment(), jMenu.getHorizontalAlignment(), jMenu.getVerticalTextPosition(), jMenu.getHorizontalTextPosition(), ourViewRect, ourIconRect, ourTextRect, ourAcceleratorRect, ourCheckIconRect, ourArrowIconRect, jMenu.getText() != null ? this.defaultTextIconGap : 0, this.defaultTextIconGap);
        Color color2 = g.getColor();
        if (comp.isOpaque()) {
            g.setColor(jMenu.getBackground());
            g.fillRect(0, 0, jMenu.getWidth(), jMenu.getHeight());
            if (buttonmodel.isArmed() || buttonmodel.isSelected()) {
                if (UIUtil.isUnderAquaLookAndFeel()) {
                    this.myAquaSelectedBackgroundPainter.paintBorder(comp, g, 0, 0, jMenu.getWidth(), jMenu.getHeight());
                } else {
                    g.setColor(this.selectionBackground);
                    if (allowedIcon != null && !UIUtil.isUnderIntelliJLaF() && !UIUtil.isUnderDarcula()) {
                        g.fillRect(this.k, 0, jMenu.getWidth() - this.k, jMenu.getHeight());
                    } else {
                        g.fillRect(0, 0, jMenu.getWidth(), jMenu.getHeight());
                        g.setColor(this.selectionBackground);
                    }
                }
            }
            g.setColor(color2);
        }
        if (allowedIcon != null) {
            if (buttonmodel.isArmed() || buttonmodel.isSelected()) {
                g.setColor(this.selectionForeground);
            } else {
                g.setColor(jMenu.getForeground());
            }
            if (this.useCheckAndArrow()) {
                allowedIcon.paintIcon(comp, g, IdeaMenuUI.ourCheckIconRect.x, IdeaMenuUI.ourCheckIconRect.y);
            }
            g.setColor(color2);
            if (this.menuItem.isArmed()) {
                this.drawIconBorder(g);
            }
        }
        if (icon != null) {
            if (!buttonmodel.isEnabled()) {
                icon = jMenu.getDisabledIcon();
            } else if (buttonmodel.isPressed() && buttonmodel.isArmed() && (icon = jMenu.getPressedIcon()) == null) {
                icon = jMenu.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(comp, g, IdeaMenuUI.ourIconRect.x, IdeaMenuUI.ourIconRect.y);
            }
        }
        if (s1 != null && s1.length() > 0) {
            if (buttonmodel.isEnabled()) {
                if (buttonmodel.isArmed() || buttonmodel.isSelected()) {
                    g.setColor(this.selectionForeground);
                } else {
                    g.setColor(jMenu.getForeground());
                }
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, s1, mnemonicIndex, IdeaMenuUI.ourTextRect.x, IdeaMenuUI.ourTextRect.y + fontmetrics.getAscent());
            } else {
                Color disabledForeground = UIUtil.getMenuItemDisabledForeground();
                if (disabledForeground != null) {
                    g.setColor(disabledForeground);
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, s1, mnemonicIndex, IdeaMenuUI.ourTextRect.x, IdeaMenuUI.ourTextRect.y + fontmetrics.getAscent());
                } else {
                    g.setColor(jMenu.getBackground().brighter());
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, s1, mnemonicIndex, IdeaMenuUI.ourTextRect.x, IdeaMenuUI.ourTextRect.y + fontmetrics.getAscent());
                    g.setColor(jMenu.getBackground().darker());
                    BasicGraphicsUtils.drawStringUnderlineCharAt(g, s1, mnemonicIndex, IdeaMenuUI.ourTextRect.x - 1, IdeaMenuUI.ourTextRect.y + fontmetrics.getAscent() - 1);
                }
            }
        }
        if (this.arrowIcon != null) {
            if (buttonmodel.isArmed() || buttonmodel.isSelected()) {
                g.setColor(this.selectionForeground);
            }
            if (this.useCheckAndArrow()) {
                try {
                    if (SystemInfo.isMac && this.myAquaInvertedArrowIcon != null && (buttonmodel.isArmed() || buttonmodel.isSelected()) && (UIUtil.isUnderAquaLookAndFeel() || UIUtil.isUnderIntelliJLaF())) {
                        this.myAquaInvertedArrowIcon.paintIcon(comp, g, IdeaMenuUI.ourArrowIconRect.x, IdeaMenuUI.ourArrowIconRect.y);
                    } else if (SystemInfo.isMac && this.myAquaDisabledArrowIcon != null && !buttonmodel.isEnabled() && (UIUtil.isUnderAquaLookAndFeel() || UIUtil.isUnderIntelliJLaF())) {
                        this.myAquaDisabledArrowIcon.paintIcon(comp, g, IdeaMenuUI.ourArrowIconRect.x, IdeaMenuUI.ourArrowIconRect.y);
                    } else {
                        this.arrowIcon.paintIcon(comp, g, IdeaMenuUI.ourArrowIconRect.x, IdeaMenuUI.ourArrowIconRect.y);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        g.setColor(color2);
        g.setFont(font);
    }

    private boolean useCheckAndArrow() {
        return !((JMenu)this.menuItem).isTopLevelMenu();
    }

    @Override
    public MenuElement[] getPath() {
        MenuElement[] amenuelement1;
        MenuSelectionManager menuselectionmanager = MenuSelectionManager.defaultManager();
        MenuElement[] amenuelement = menuselectionmanager.getSelectedPath();
        int i1 = amenuelement.length;
        if (i1 == 0) {
            return new MenuElement[0];
        }
        Container container = this.menuItem.getParent();
        if (amenuelement[i1 - 1].getComponent() == container) {
            amenuelement1 = new MenuElement[i1 + 1];
            System.arraycopy(amenuelement, 0, amenuelement1, 0, i1);
            amenuelement1[i1] = this.menuItem;
        } else {
            int j1;
            for (j1 = amenuelement.length - 1; j1 >= 0 && amenuelement[j1].getComponent() != container; --j1) {
            }
            amenuelement1 = new MenuElement[j1 + 2];
            System.arraycopy(amenuelement, 0, amenuelement1, 0, j1 + 1);
            amenuelement1[j1 + 1] = this.menuItem;
        }
        return amenuelement1;
    }

    private String layoutMenuItem(FontMetrics fontmetrics, String text2, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int textIconGap, int menuItemGap) {
        SwingUtilities.layoutCompoundLabel(this.menuItem, fontmetrics, text2, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewRect, iconRect, textRect, textIconGap);
        acceleratorRect.height = 0;
        acceleratorRect.width = 0;
        if (this.useCheckAndArrow()) {
            if (checkIcon != null) {
                checkIconRect.width = checkIcon.getIconWidth();
                checkIconRect.height = checkIcon.getIconHeight();
            } else {
                checkIconRect.height = 0;
                checkIconRect.width = 0;
            }
            if (arrowIcon != null) {
                arrowIconRect.width = arrowIcon.getIconWidth();
                arrowIconRect.height = arrowIcon.getIconHeight();
            } else {
                arrowIconRect.height = 0;
                arrowIconRect.width = 0;
            }
            textRect.x += this.myMaxGutterIconWidth;
            iconRect.x += this.myMaxGutterIconWidth;
        }
        textRect.x += menuItemGap;
        iconRect.x += menuItemGap;
        Rectangle labelRect = iconRect.union(textRect);
        acceleratorRect.x += viewRect.width - arrowIconRect.width - menuItemGap - acceleratorRect.width;
        acceleratorRect.y = viewRect.y + viewRect.height / 2 - acceleratorRect.height / 2;
        if (this.useCheckAndArrow()) {
            arrowIconRect.x += viewRect.width - arrowIconRect.width;
            arrowIconRect.y = viewRect.y + labelRect.height / 2 - arrowIconRect.height / 2;
            if (checkIcon != null) {
                checkIconRect.y = viewRect.y + labelRect.height / 2 - checkIconRect.height / 2;
                checkIconRect.x += viewRect.x + this.myMaxGutterIconWidth / 2 - checkIcon.getIconWidth() / 2;
                this.a = viewRect.x;
                this.e = viewRect.y + labelRect.height / 2 - this.myMaxGutterIconWidth / 2;
                this.k = viewRect.x + this.myMaxGutterIconWidth + 2;
            } else {
                checkIconRect.y = 0;
                checkIconRect.x = 0;
            }
        }
        return text2;
    }

    private Icon getIcon() {
        Icon icon = this.menuItem.getIcon();
        if (icon != null && this.getAllowedIcon() != null) {
            icon = null;
        }
        return icon;
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent comp, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        JMenu jMenu = (JMenu)comp;
        Icon icon1 = this.getIcon();
        Icon icon2 = this.getAllowedIcon();
        String text2 = jMenu.getText();
        Font font = jMenu.getFont();
        FontMetrics fontmetrics = jMenu.getToolkit().getFontMetrics(font);
        this.resetRects();
        this.layoutMenuItem(fontmetrics, text2, icon1, icon2, arrowIcon, jMenu.getVerticalAlignment(), jMenu.getHorizontalAlignment(), jMenu.getVerticalTextPosition(), jMenu.getHorizontalTextPosition(), ourViewRect, ourIconRect, ourTextRect, ourAcceleratorRect, ourCheckIconRect, ourArrowIconRect, text2 != null ? defaultTextIconGap : 0, defaultTextIconGap);
        ourPreferredSizeRect.setBounds(ourTextRect);
        ourPreferredSizeRect = SwingUtilities.computeUnion(IdeaMenuUI.ourIconRect.x, IdeaMenuUI.ourIconRect.y, IdeaMenuUI.ourIconRect.width, IdeaMenuUI.ourIconRect.height, ourPreferredSizeRect);
        if (this.useCheckAndArrow()) {
            IdeaMenuUI.ourPreferredSizeRect.width += this.myMaxGutterIconWidth;
            IdeaMenuUI.ourPreferredSizeRect.width += defaultTextIconGap;
            IdeaMenuUI.ourPreferredSizeRect.width += defaultTextIconGap;
            IdeaMenuUI.ourPreferredSizeRect.width += IdeaMenuUI.ourArrowIconRect.width;
        }
        IdeaMenuUI.ourPreferredSizeRect.width += 2 * defaultTextIconGap;
        Insets insets = jMenu.getInsets();
        if (insets != null) {
            IdeaMenuUI.ourPreferredSizeRect.width += insets.left + insets.right;
            IdeaMenuUI.ourPreferredSizeRect.height += insets.top + insets.bottom;
        }
        if (IdeaMenuUI.ourPreferredSizeRect.width % 2 == 0) {
            ++IdeaMenuUI.ourPreferredSizeRect.width;
        }
        if (IdeaMenuUI.ourPreferredSizeRect.height % 2 == 0) {
            ++IdeaMenuUI.ourPreferredSizeRect.height;
        }
        return ourPreferredSizeRect.getSize();
    }

    private void drawIconBorder(Graphics g) {
        int i1 = this.a - 1;
        int j1 = this.e - 2;
        int k1 = i1 + this.myMaxGutterIconWidth + 1;
        int l1 = j1 + this.myMaxGutterIconWidth + 4;
        g.setColor(BegResources.m);
        UIUtil.drawLine((Graphics)g, (int)i1, (int)j1, (int)i1, (int)l1);
        UIUtil.drawLine((Graphics)g, (int)i1, (int)j1, (int)k1, (int)j1);
        g.setColor(BegResources.j);
        UIUtil.drawLine((Graphics)g, (int)k1, (int)j1, (int)k1, (int)l1);
        UIUtil.drawLine((Graphics)g, (int)i1, (int)l1, (int)k1, (int)l1);
    }

    private void resetRects() {
        ourIconRect.setBounds(ourZeroRect);
        ourTextRect.setBounds(ourZeroRect);
        ourAcceleratorRect.setBounds(ourZeroRect);
        ourCheckIconRect.setBounds(ourZeroRect);
        ourArrowIconRect.setBounds(ourZeroRect);
        ourViewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        ourPreferredSizeRect.setBounds(ourZeroRect);
    }

    private Icon getAllowedIcon() {
        Icon icon;
        Icon icon2 = icon = this.menuItem.isEnabled() ? this.menuItem.getIcon() : this.menuItem.getDisabledIcon();
        if (icon != null && icon.getIconWidth() > this.myMaxGutterIconWidth) {
            icon = null;
        }
        return icon;
    }

    @Override
    public void update(Graphics g, JComponent comp) {
        this.paint(g, comp);
    }
}

