/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.profiling;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ResolveProfiler {
    @NonNls
    private static final String PATH = "../../resolve_info/";
    private static final boolean DISABLED = true;
    private static final ThreadLocal<ThreadInfo> threadMap = new ThreadLocal();
    private static volatile int fileCount;

    public static void start() {
    }

    public static long finish() {
        return -1L;
    }

    public static void write(String prefix, @NotNull PsiElement expression, long time) {
        if (expression == null) {
            ResolveProfiler.$$$reportNull$$$0(0);
        }
        ResolveProfiler.write(ResolveProfiler.getInfo(prefix, expression, time));
    }

    public static void write(@NotNull String s) {
        if (s == null) {
            ResolveProfiler.$$$reportNull$$$0(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static ThreadInfo getThreadInfo() {
        ThreadInfo info = threadMap.get();
        if (info == null) {
            Class<ResolveProfiler> clazz = ResolveProfiler.class;
            // MONITORENTER : com.intellij.util.profiling.ResolveProfiler.class
            info = new ThreadInfo("../../resolve_info/out" + fileCount + ".txt");
            ++fileCount;
            // MONITOREXIT : clazz
            threadMap.set(info);
        }
        ThreadInfo threadInfo = info;
        if (threadInfo != null) return threadInfo;
        ResolveProfiler.$$$reportNull$$$0(2);
        return threadInfo;
    }

    public static String getInfo(String prefix, @NotNull PsiElement expression, long time) {
        if (expression == null) {
            ResolveProfiler.$$$reportNull$$$0(3);
        }
        PsiFile file2 = expression.getContainingFile();
        String text2 = expression.getText();
        String textInfo = text2 != null ? StringUtil.escapeLineBreak((String)text2) : "<null>";
        return prefix + " :: " + (file2 != null ? file2.getName() : "<no file>") + " :: " + textInfo + " :: " + expression.hashCode() + " :: " + time;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/profiling/ResolveProfiler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/profiling/ResolveProfiler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ThreadInfo {
        private final String myFileName;
        private final Deque<Long> myTimeStack;
        private String myPrefix;

        private ThreadInfo(@NotNull String name) {
            if (name == null) {
                ThreadInfo.$$$reportNull$$$0(0);
            }
            this.myTimeStack = new ArrayDeque<Long>();
            this.myPrefix = "";
            this.myFileName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myFileName;
            if (string == null) {
                ThreadInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void start() {
            this.myTimeStack.push(System.nanoTime());
            this.myPrefix = this.myPrefix + "  ";
        }

        public long finish() {
            this.myPrefix = this.myPrefix.substring(2);
            Long time = this.myTimeStack.pop();
            return (System.nanoTime() - time) / 1000L;
        }

        private String getPrefix() {
            return this.myPrefix;
        }

        static /* synthetic */ String access$000(ThreadInfo x0) {
            return x0.getPrefix();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/profiling/ResolveProfiler$ThreadInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/profiling/ResolveProfiler$ThreadInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

