/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonContainer;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaTreeNode;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.impl.SchemaResolveState;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaVariantsTreeBuilder {
    private static final Logger LOG = Logger.getInstance(JsonSchemaVariantsTreeBuilder.class);

    public static JsonSchemaTreeNode buildTree(@NotNull JsonSchemaObject schema, @Nullable List<Step> position, boolean skipLastExpand, boolean literalResolve, boolean acceptAdditional) {
        if (schema == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(0);
        }
        JsonSchemaTreeNode root = new JsonSchemaTreeNode(null, schema);
        JsonSchemaService service2 = JsonSchemaService.Impl.get(schema.getJsonObject().getProject());
        JsonSchemaVariantsTreeBuilder.expandChildSchema(root, schema, service2);
        for (JsonSchemaTreeNode treeNode : root.getChildren()) {
            treeNode.setSteps(ContainerUtil.notNullize(position));
        }
        ArrayDeque<JsonSchemaTreeNode> queue2 = new ArrayDeque<JsonSchemaTreeNode>(root.getChildren());
        while (!queue2.isEmpty()) {
            Pair<ThreeState, JsonSchemaObject> pair;
            JsonSchemaTreeNode node = queue2.removeFirst();
            if (node.isAny() || node.isNothing() || node.getSteps().isEmpty() || node.getSchema() == null) continue;
            Step step = node.getSteps().get(0);
            if (!JsonSchemaVariantsTreeBuilder.typeMatches(step.isFromObject(), node.getSchema())) {
                node.nothingChild();
                continue;
            }
            if (literalResolve) {
                step.myLiteralResolve = true;
            }
            if (ThreeState.NO.equals((pair = step.step(node.getSchema(), acceptAdditional)).getFirst())) {
                node.nothingChild();
            } else if (ThreeState.YES.equals(pair.getFirst())) {
                node.anyChild();
            } else {
                assert (pair.getSecond() != null);
                if (node.getSteps().size() > 1 || !skipLastExpand) {
                    JsonSchemaVariantsTreeBuilder.expandChildSchema(node, (JsonSchemaObject)pair.getSecond(), service2);
                } else {
                    node.setChild((JsonSchemaObject)pair.getSecond());
                }
            }
            queue2.addAll(node.getChildren());
        }
        return root;
    }

    private static boolean typeMatches(boolean isObject, @NotNull JsonSchemaObject schema) {
        JsonSchemaType requiredType;
        if (schema == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(1);
        }
        JsonSchemaType jsonSchemaType = requiredType = isObject ? JsonSchemaType._object : JsonSchemaType._array;
        if (schema.getType() != null) {
            return requiredType.equals((Object)schema.getType());
        }
        if (schema.getTypeVariants() != null) {
            for (JsonSchemaType schemaType : schema.getTypeVariants()) {
                if (!requiredType.equals((Object)schemaType)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static void expandChildSchema(@NotNull JsonSchemaTreeNode node, @NotNull JsonSchemaObject childSchema, @NotNull JsonSchemaService service2) {
        if (node == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(2);
        }
        if (childSchema == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(3);
        }
        if (service2 == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(4);
        }
        JsonContainer element = childSchema.getJsonObject();
        if (JsonSchemaVariantsTreeBuilder.interestingSchema(childSchema)) {
            Operation operation = (Operation)CachedValuesManager.getManager((Project)element.getProject()).createParameterizedCachedValue(param -> {
                if (service2 == null) {
                    JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(18);
                }
                ProcessDefinitionsOperation expand = new ProcessDefinitionsOperation((JsonSchemaObject)param, service2);
                expand.doMap(new HashSet<JsonContainer>());
                expand.doReduce();
                return CachedValueProvider.Result.create((Object)expand, (Object[])new Object[]{element.getContainingFile(), service2.getAnySchemaChangeTracker()});
            }, false).getValue((Object)childSchema);
            node.createChildrenFromOperation(operation);
        } else {
            node.setChild(childSchema);
        }
    }

    public static List<Step> buildSteps(@NotNull String nameInSchema) {
        if (nameInSchema == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(5);
        }
        List chain = StringUtil.split((String)JsonSchemaService.normalizeId(nameInSchema).replace("\\", "/"), (String)"/");
        ArrayList steps = ContainerUtil.newArrayListWithCapacity((int)chain.size());
        for (String s : chain) {
            if (StringUtil.isEmpty((String)s)) continue;
            try {
                steps.add(Step.createArrayElementStep(Integer.parseInt(s)));
            }
            catch (NumberFormatException e) {
                steps.add(Step.createPropertyStep(s));
            }
        }
        return steps;
    }

    private static List<JsonSchemaObject> andGroups(@NotNull List<JsonSchemaObject> g1, @NotNull List<JsonSchemaObject> g2) {
        if (g1 == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(6);
        }
        if (g2 == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(7);
        }
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)(g1.size() * g2.size()));
        for (JsonSchemaObject s : g1) {
            result2.addAll(JsonSchemaVariantsTreeBuilder.andGroup(s, g2));
        }
        return result2;
    }

    private static List<JsonSchemaObject> andGroup(@NotNull JsonSchemaObject object, @NotNull List<JsonSchemaObject> group) {
        if (object == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(8);
        }
        if (group == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(9);
        }
        ArrayList list2 = ContainerUtil.newArrayListWithCapacity((int)group.size());
        for (JsonSchemaObject s : group) {
            list2.add(JsonSchemaVariantsTreeBuilder.merge(object, s, s));
        }
        return list2;
    }

    @Nullable
    private static JsonSchemaObject getSchemaFromDefinition(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaService service2) {
        if (schema == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(10);
        }
        if (service2 == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(11);
        }
        String ref = schema.getRef();
        assert (!StringUtil.isEmptyOrSpaces((String)ref));
        VirtualFile schemaFile = schema.getSchemaFile();
        SchemaUrlSplitter splitter = new SchemaUrlSplitter(ref);
        if (splitter.getSchemaId() != null) {
            VirtualFile refFile = service2.findSchemaFileByReference(splitter.getSchemaId(), schemaFile);
            if (refFile == null) {
                LOG.debug(String.format("Schema file not found by reference: '%s' from %s", splitter.getSchemaId(), schemaFile.getPath()));
                return null;
            }
            JsonSchemaObject refSchema = service2.getSchemaObjectForSchemaFile(refFile);
            if (refSchema == null) {
                LOG.debug(String.format("Schema object not found by reference: '%s' from %s", splitter.getSchemaId(), schemaFile.getPath()));
                return null;
            }
            return JsonSchemaVariantsTreeBuilder.findRelativeDefinition(refSchema, splitter);
        }
        JsonSchemaObject rootSchema = service2.getSchemaObjectForSchemaFile(schemaFile);
        if (rootSchema == null) {
            LOG.debug(String.format("Schema object not found for %s", schemaFile.getPath()));
            return null;
        }
        return JsonSchemaVariantsTreeBuilder.findRelativeDefinition(rootSchema, splitter);
    }

    private static JsonSchemaObject findRelativeDefinition(@NotNull JsonSchemaObject schema, @NotNull SchemaUrlSplitter splitter) {
        String path;
        if (schema == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(12);
        }
        if (splitter == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(13);
        }
        if (StringUtil.isEmptyOrSpaces((String)(path = splitter.getRelativePath()))) {
            return schema;
        }
        JsonSchemaObject definition = schema.findRelativeDefinition(path);
        if (definition == null) {
            LOG.debug(String.format("Definition not found by reference: '%s' in file %s", path, schema.getSchemaFile().getPath()));
        }
        return definition;
    }

    public static JsonSchemaObject merge(@NotNull JsonSchemaObject base, @NotNull JsonSchemaObject other, @NotNull JsonSchemaObject pointTo) {
        if (base == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(14);
        }
        if (other == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(15);
        }
        if (pointTo == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(16);
        }
        JsonSchemaObject object = new JsonSchemaObject(pointTo.getJsonObject());
        object.mergeValues(other);
        object.mergeValues(base);
        object.setRef(other.getRef());
        return object;
    }

    private static boolean conflictingSchema(JsonSchemaObject schema) {
        int cnt = 0;
        if (schema.getAllOf() != null) {
            ++cnt;
        }
        if (schema.getAnyOf() != null) {
            ++cnt;
        }
        if (schema.getOneOf() != null) {
            ++cnt;
        }
        return cnt > 1;
    }

    private static boolean interestingSchema(@NotNull JsonSchemaObject schema) {
        if (schema == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(17);
        }
        return schema.getAnyOf() != null || schema.getOneOf() != null || schema.getAllOf() != null || schema.getRef() != null || schema.getIf() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childSchema";
                break;
            }
            case 4: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameInSchema";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointTo";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildTree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "typeMatches";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "expandChildSchema";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "buildSteps";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "andGroups";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "andGroup";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getSchemaFromDefinition";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "findRelativeDefinition";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "merge";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "interestingSchema";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$expandChildSchema$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SchemaUrlSplitter {
        @Nullable
        private final String mySchemaId;
        @NotNull
        private final String myRelativePath;

        public SchemaUrlSplitter(@NotNull String ref) {
            if (ref == null) {
                SchemaUrlSplitter.$$$reportNull$$$0(0);
            }
            if ("#".equals(ref)) {
                this.mySchemaId = null;
                this.myRelativePath = "";
                return;
            }
            if (!ref.startsWith("#/")) {
                int idx = ref.indexOf("#/");
                if (idx == -1) {
                    this.mySchemaId = ref.endsWith("#") ? ref.substring(0, ref.length() - 1) : ref;
                    this.myRelativePath = "";
                } else {
                    this.mySchemaId = ref.substring(0, idx);
                    this.myRelativePath = ref.substring(idx);
                }
            } else {
                this.mySchemaId = null;
                this.myRelativePath = ref;
            }
        }

        public boolean isAbsolute() {
            return this.mySchemaId != null;
        }

        @Nullable
        public String getSchemaId() {
            return this.mySchemaId;
        }

        @NotNull
        public String getRelativePath() {
            String string = this.myRelativePath;
            if (string == null) {
                SchemaUrlSplitter.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder$SchemaUrlSplitter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder$SchemaUrlSplitter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRelativePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Step {
        @Nullable
        private final String myName;
        private final int myIdx;
        private boolean myLiteralResolve;

        private Step(@Nullable String name, int idx) {
            this.myName = name;
            this.myIdx = idx;
        }

        public static Step createPropertyStep(@NotNull String name) {
            if (name == null) {
                Step.$$$reportNull$$$0(0);
            }
            return new Step(name, -1);
        }

        public static Step createArrayElementStep(int idx) {
            assert (idx >= 0);
            return new Step(null, idx);
        }

        public boolean isFromObject() {
            return this.myName != null;
        }

        public boolean isFromArray() {
            return this.myName == null;
        }

        @Nullable
        public String getName() {
            return this.myName;
        }

        @NotNull
        public Pair<ThreeState, JsonSchemaObject> step(@NotNull JsonSchemaObject parent, boolean acceptAdditionalPropertiesSchemas) {
            if (parent == null) {
                Step.$$$reportNull$$$0(1);
            }
            if (this.myName != null) {
                Pair<ThreeState, JsonSchemaObject> pair = this.propertyStep(parent, acceptAdditionalPropertiesSchemas);
                if (pair == null) {
                    Step.$$$reportNull$$$0(2);
                }
                return pair;
            }
            assert (this.myIdx >= 0);
            Pair<ThreeState, JsonSchemaObject> pair = this.arrayElementStep(parent, acceptAdditionalPropertiesSchemas);
            if (pair == null) {
                Step.$$$reportNull$$$0(3);
            }
            return pair;
        }

        public String toString() {
            String format = "?%s";
            if (this.myName != null) {
                format = "{%s}";
            }
            if (this.myIdx >= 0) {
                format = "[%s]";
            }
            return String.format(format, this.myName != null ? this.myName : (this.myIdx >= 0 ? String.valueOf(this.myIdx) : "null"));
        }

        @NotNull
        private Pair<ThreeState, JsonSchemaObject> propertyStep(@NotNull JsonSchemaObject parent, boolean acceptAdditionalPropertiesSchemas) {
            if (parent == null) {
                Step.$$$reportNull$$$0(4);
            }
            assert (this.myName != null);
            if ("definitions".equals(this.myName) && parent.getDefinitionsMap() != null && (!Step.isInMainSchema(parent) || this.myLiteralResolve)) {
                Map<String, JsonSchemaObject> definitionsMap = parent.getDefinitionsMap();
                JsonObject anyDefinitions = definitionsMap.values().stream().filter(def -> {
                    JsonProperty parentObj = (JsonProperty)ObjectUtils.tryCast((Object)def.getJsonObject().getParent(), JsonProperty.class);
                    return parentObj != null && parentObj.isValid() && parentObj.getValue() instanceof JsonObject;
                }).map(def -> (JsonObject)((JsonProperty)def.getJsonObject().getParent()).getValue()).findFirst().orElse(null);
                if (anyDefinitions == null) {
                    Pair pair = Pair.create((Object)ThreeState.NO, null);
                    if (pair == null) {
                        Step.$$$reportNull$$$0(5);
                    }
                    return pair;
                }
                JsonSchemaObject object = new JsonSchemaObject(anyDefinitions);
                object.setProperties(definitionsMap);
                Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)object);
                if (pair == null) {
                    Step.$$$reportNull$$$0(6);
                }
                return pair;
            }
            JsonSchemaObject child = parent.getProperties().get(this.myName);
            if (child != null) {
                Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)child);
                if (pair == null) {
                    Step.$$$reportNull$$$0(7);
                }
                return pair;
            }
            JsonSchemaObject schema = parent.getMatchingPatternPropertySchema(this.myName);
            if (schema != null) {
                Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)schema);
                if (pair == null) {
                    Step.$$$reportNull$$$0(8);
                }
                return pair;
            }
            if (acceptAdditionalPropertiesSchemas) {
                if (parent.getAdditionalPropertiesSchema() != null) {
                    Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)parent.getAdditionalPropertiesSchema());
                    if (pair == null) {
                        Step.$$$reportNull$$$0(9);
                    }
                    return pair;
                }
                if (parent.getIf() != null) {
                    JsonSchemaObject childObject;
                    if (parent.getThen() != null && (childObject = parent.getThen().getProperties().get(this.myName)) != null) {
                        Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)childObject);
                        if (pair == null) {
                            Step.$$$reportNull$$$0(10);
                        }
                        return pair;
                    }
                    if (parent.getElse() != null && (childObject = parent.getElse().getProperties().get(this.myName)) != null) {
                        Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)childObject);
                        if (pair == null) {
                            Step.$$$reportNull$$$0(11);
                        }
                        return pair;
                    }
                }
            }
            if (Boolean.FALSE.equals(parent.getAdditionalPropertiesAllowed())) {
                Pair pair = Pair.create((Object)ThreeState.NO, null);
                if (pair == null) {
                    Step.$$$reportNull$$$0(12);
                }
                return pair;
            }
            Pair pair = Pair.create((Object)ThreeState.YES, null);
            if (pair == null) {
                Step.$$$reportNull$$$0(13);
            }
            return pair;
        }

        private static boolean isInMainSchema(@NotNull JsonSchemaObject parent) {
            if (parent == null) {
                Step.$$$reportNull$$$0(14);
            }
            VirtualFile schemaFile = parent.getSchemaFile();
            JsonSchemaService service2 = JsonSchemaService.Impl.get(parent.getJsonObject().getProject());
            if (!service2.isApplicableToFile(schemaFile) || !service2.isSchemaFile(schemaFile)) {
                return false;
            }
            JsonSchemaObject rootSchema = service2.getSchemaObjectForSchemaFile(schemaFile);
            if (rootSchema == null) {
                return false;
            }
            return JsonSchemaVersion.isSchemaSchemaId(rootSchema.getId());
        }

        @NotNull
        private Pair<ThreeState, JsonSchemaObject> arrayElementStep(@NotNull JsonSchemaObject parent, boolean acceptAdditionalPropertiesSchemas) {
            if (parent == null) {
                Step.$$$reportNull$$$0(15);
            }
            if (parent.getItemsSchema() != null) {
                Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)parent.getItemsSchema());
                if (pair == null) {
                    Step.$$$reportNull$$$0(16);
                }
                return pair;
            }
            if (parent.getItemsSchemaList() != null) {
                List<JsonSchemaObject> list2 = parent.getItemsSchemaList();
                if (this.myIdx >= 0 && this.myIdx < list2.size()) {
                    Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)list2.get(this.myIdx));
                    if (pair == null) {
                        Step.$$$reportNull$$$0(17);
                    }
                    return pair;
                }
            }
            if (parent.getAdditionalItemsSchema() != null && acceptAdditionalPropertiesSchemas) {
                Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)parent.getAdditionalItemsSchema());
                if (pair == null) {
                    Step.$$$reportNull$$$0(18);
                }
                return pair;
            }
            if (Boolean.FALSE.equals(parent.getAdditionalItemsAllowed())) {
                Pair pair = Pair.create((Object)ThreeState.NO, null);
                if (pair == null) {
                    Step.$$$reportNull$$$0(19);
                }
                return pair;
            }
            Pair pair = Pair.create((Object)ThreeState.YES, null);
            if (pair == null) {
                Step.$$$reportNull$$$0(20);
            }
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 4: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder$Step";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder$Step";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "step";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "propertyStep";
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "arrayElementStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createPropertyStep";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "step";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "propertyStep";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "isInMainSchema";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "arrayElementStep";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AnyOfOperation
    extends Operation {
        private final JsonSchemaService myService;

        protected AnyOfOperation(@NotNull JsonSchemaObject sourceNode, JsonSchemaService service2) {
            if (sourceNode == null) {
                AnyOfOperation.$$$reportNull$$$0(0);
            }
            super(sourceNode);
            this.myService = service2;
        }

        @Override
        public void map(@NotNull Set<JsonContainer> visited) {
            if (visited == null) {
                AnyOfOperation.$$$reportNull$$$0(1);
            }
            assert (this.mySourceNode.getAnyOf() != null);
            this.myChildOperations.addAll(this.mySourceNode.getAnyOf().stream().map((? super T sourceNode) -> new ProcessDefinitionsOperation((JsonSchemaObject)sourceNode, this.myService)).collect(Collectors.toList()));
        }

        @Override
        public void reduce() {
            for (Operation op : this.myChildOperations) {
                if (!op.myState.equals((Object)SchemaResolveState.normal)) continue;
                this.myAnyOfGroup.addAll(JsonSchemaVariantsTreeBuilder.andGroup(this.mySourceNode, op.myAnyOfGroup));
                for (List<JsonSchemaObject> group : op.myOneOfGroup) {
                    this.myOneOfGroup.add(JsonSchemaVariantsTreeBuilder.andGroup(this.mySourceNode, group));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visited";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder$AnyOfOperation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "map";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class OneOfOperation
    extends Operation {
        private final JsonSchemaService myService;

        protected OneOfOperation(@NotNull JsonSchemaObject sourceNode, JsonSchemaService service2) {
            if (sourceNode == null) {
                OneOfOperation.$$$reportNull$$$0(0);
            }
            super(sourceNode);
            this.myService = service2;
        }

        @Override
        public void map(@NotNull Set<JsonContainer> visited) {
            if (visited == null) {
                OneOfOperation.$$$reportNull$$$0(1);
            }
            assert (this.mySourceNode.getOneOf() != null);
            this.myChildOperations.addAll(this.mySourceNode.getOneOf().stream().map((? super T sourceNode) -> new ProcessDefinitionsOperation((JsonSchemaObject)sourceNode, this.myService)).collect(Collectors.toList()));
        }

        @Override
        public void reduce() {
            SmartList oneOf = new SmartList();
            for (Operation op : this.myChildOperations) {
                if (!op.myState.equals((Object)SchemaResolveState.normal)) continue;
                oneOf.addAll(JsonSchemaVariantsTreeBuilder.andGroup(this.mySourceNode, op.myAnyOfGroup));
                oneOf.addAll(JsonSchemaVariantsTreeBuilder.andGroup(this.mySourceNode, OneOfOperation.mergeOneOf(op)));
            }
            this.myOneOfGroup.add(oneOf);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visited";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder$OneOfOperation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "map";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AllOfOperation
    extends Operation {
        private final JsonSchemaService myService;

        protected AllOfOperation(@NotNull JsonSchemaObject sourceNode, JsonSchemaService service2) {
            if (sourceNode == null) {
                AllOfOperation.$$$reportNull$$$0(0);
            }
            super(sourceNode);
            this.myService = service2;
        }

        @Override
        public void map(@NotNull Set<JsonContainer> visited) {
            if (visited == null) {
                AllOfOperation.$$$reportNull$$$0(1);
            }
            assert (this.mySourceNode.getAllOf() != null);
            this.myChildOperations.addAll(this.mySourceNode.getAllOf().stream().map((? super T sourceNode) -> new ProcessDefinitionsOperation((JsonSchemaObject)sourceNode, this.myService)).collect(Collectors.toList()));
        }

        private static <T> int maxSize(List<List<T>> items) {
            if (items.size() == 0) {
                return 0;
            }
            int maxsize = -1;
            for (List<T> item : items) {
                int size = item.size();
                if (maxsize >= size) continue;
                maxsize = size;
            }
            return maxsize;
        }

        @Override
        public void reduce() {
            this.myAnyOfGroup.add(this.mySourceNode);
            for (Operation op : this.myChildOperations) {
                if (!op.myState.equals((Object)SchemaResolveState.normal)) continue;
                List mergedAny = JsonSchemaVariantsTreeBuilder.andGroups(op.myAnyOfGroup, this.myAnyOfGroup);
                ArrayList mergedExclusive = ContainerUtil.newArrayListWithCapacity((int)(op.myAnyOfGroup.size() * AllOfOperation.maxSize(this.myOneOfGroup) + this.myAnyOfGroup.size() * AllOfOperation.maxSize(op.myOneOfGroup) + AllOfOperation.maxSize(this.myOneOfGroup) * AllOfOperation.maxSize(op.myOneOfGroup)));
                for (List list2 : this.myOneOfGroup) {
                    mergedExclusive.add(JsonSchemaVariantsTreeBuilder.andGroups(op.myAnyOfGroup, list2));
                }
                for (List list3 : op.myOneOfGroup) {
                    mergedExclusive.add(JsonSchemaVariantsTreeBuilder.andGroups(list3, this.myAnyOfGroup));
                }
                for (List list4 : op.myOneOfGroup) {
                    for (List otherGroup : this.myOneOfGroup) {
                        mergedExclusive.add(JsonSchemaVariantsTreeBuilder.andGroups(list4, otherGroup));
                    }
                }
                this.myAnyOfGroup.clear();
                this.myOneOfGroup.clear();
                this.myAnyOfGroup.addAll(mergedAny);
                this.myOneOfGroup.addAll(mergedExclusive);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visited";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder$AllOfOperation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "map";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ProcessDefinitionsOperation
    extends Operation {
        private final JsonSchemaService myService;

        protected ProcessDefinitionsOperation(@NotNull JsonSchemaObject sourceNode, JsonSchemaService service2) {
            if (sourceNode == null) {
                ProcessDefinitionsOperation.$$$reportNull$$$0(0);
            }
            super(sourceNode);
            this.myService = service2;
        }

        @Override
        public void map(@NotNull Set<JsonContainer> visited) {
            Operation expandOperation;
            if (visited == null) {
                ProcessDefinitionsOperation.$$$reportNull$$$0(1);
            }
            JsonSchemaObject current = this.mySourceNode;
            while (!StringUtil.isEmptyOrSpaces((String)current.getRef())) {
                JsonSchemaObject definition = JsonSchemaVariantsTreeBuilder.getSchemaFromDefinition(current, this.myService);
                if (definition == null) {
                    this.myState = SchemaResolveState.brokenDefinition;
                    return;
                }
                if (!visited.add(definition.getJsonObject())) break;
                current = JsonSchemaVariantsTreeBuilder.merge(current, definition, current);
            }
            if ((expandOperation = this.createExpandOperation(current, this.myService)) != null) {
                this.myChildOperations.add(expandOperation);
            } else {
                this.myAnyOfGroup.add(current);
            }
        }

        @Override
        public void reduce() {
            if (!this.myChildOperations.isEmpty()) {
                assert (this.myChildOperations.size() == 1);
                Operation operation = (Operation)this.myChildOperations.get(0);
                this.myAnyOfGroup.addAll(operation.myAnyOfGroup);
                this.myOneOfGroup.addAll(operation.myOneOfGroup);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visited";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder$ProcessDefinitionsOperation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "map";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static abstract class Operation {
        @NotNull
        final List<JsonSchemaObject> myAnyOfGroup;
        @NotNull
        final List<List<JsonSchemaObject>> myOneOfGroup;
        @NotNull
        protected final List<Operation> myChildOperations;
        @NotNull
        protected final JsonSchemaObject mySourceNode;
        protected SchemaResolveState myState;

        protected Operation(@NotNull JsonSchemaObject sourceNode) {
            if (sourceNode == null) {
                Operation.$$$reportNull$$$0(0);
            }
            this.myAnyOfGroup = new SmartList();
            this.myOneOfGroup = new SmartList();
            this.myState = SchemaResolveState.normal;
            this.mySourceNode = sourceNode;
            this.myChildOperations = new ArrayList<Operation>();
        }

        protected abstract void map(@NotNull Set<JsonContainer> var1);

        protected abstract void reduce();

        public void doMap(@NotNull Set<JsonContainer> visited) {
            if (visited == null) {
                Operation.$$$reportNull$$$0(1);
            }
            this.map(visited);
            for (Operation operation : this.myChildOperations) {
                operation.doMap(visited);
            }
        }

        public void doReduce() {
            if (!SchemaResolveState.normal.equals((Object)this.myState)) {
                this.myChildOperations.clear();
                this.myAnyOfGroup.clear();
                this.myOneOfGroup.clear();
                return;
            }
            this.myAnyOfGroup.forEach(Operation::clearVariants);
            this.myOneOfGroup.forEach(list2 -> list2.forEach(Operation::clearVariants));
            for (Operation myChildOperation : this.myChildOperations) {
                myChildOperation.doReduce();
            }
            this.reduce();
            this.myChildOperations.clear();
        }

        private static void clearVariants(@NotNull JsonSchemaObject object) {
            if (object == null) {
                Operation.$$$reportNull$$$0(2);
            }
            object.setAllOf(null);
            object.setAnyOf(null);
            object.setOneOf(null);
        }

        @Nullable
        protected Operation createExpandOperation(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaService service2) {
            if (schema == null) {
                Operation.$$$reportNull$$$0(3);
            }
            if (service2 == null) {
                Operation.$$$reportNull$$$0(4);
            }
            if (JsonSchemaVariantsTreeBuilder.conflictingSchema(schema)) {
                AnyOfOperation operation = new AnyOfOperation(schema, service2);
                operation.myState = SchemaResolveState.conflict;
                return operation;
            }
            if (schema.getAnyOf() != null) {
                return new AnyOfOperation(schema, service2);
            }
            if (schema.getOneOf() != null) {
                return new OneOfOperation(schema, service2);
            }
            if (schema.getAllOf() != null) {
                return new AllOfOperation(schema, service2);
            }
            return null;
        }

        protected static List<JsonSchemaObject> mergeOneOf(Operation op) {
            return op.myOneOfGroup.stream().flatMap(Collection::stream).collect(Collectors.toList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visited";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schema";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder$Operation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doMap";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clearVariants";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createExpandOperation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

