/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.TypeEvalContext;
import icons.PythonIcons;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aB\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u001aJ\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\b\b\u0002\u0010\u0012\u001a\u00020\u00072\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u001a\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u001a\f\u0010\u001c\u001a\u0004\u0018\u00010\u0019*\u00020\u001d\u001a\f\u0010\u001e\u001a\u0004\u0018\u00010\u000e*\u00020\u001d\u001a\n\u0010\u001f\u001a\u00020\u0010*\u00020\u001d\u00a8\u0006 "}, d2={"addFunctionToResult", "", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "pyFile", "Lcom/jetbrains/python/psi/PyFile;", "functionName", "", "functionParentheses", "builderPostprocessor", "Lkotlin/Function1;", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "addMethodToResult", "pyClass", "Lcom/jetbrains/python/psi/PyClass;", "typeEvalContext", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "methodName", "methodParentheses", "autoInsertSingleItem", "Lcom/intellij/codeInsight/completion/AutoCompletionDecision;", "context", "Lcom/intellij/codeInsight/completion/AutoCompletionContext;", "createLookupElementBuilder", "file", "Lcom/intellij/psi/PsiFile;", "element", "Lcom/intellij/psi/PsiFileSystemItem;", "getFile", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "getPyClass", "getTypeEvalContext", "intellij.python.community.impl"})
public final class PyCompletionUtilsKt {
    @NotNull
    public static final AutoCompletionDecision autoInsertSingleItem(@NotNull AutoCompletionContext context) {
        AutoCompletionDecision autoCompletionDecision;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (context.getItems().length == 1) {
            Object[] objectArray = context.getItems();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"context.items");
            autoCompletionDecision = AutoCompletionDecision.insertItem((LookupElement)((LookupElement)ArraysKt.first((Object[])objectArray)));
            if (autoCompletionDecision == null) {
                Intrinsics.throwNpe();
            }
        } else {
            autoCompletionDecision = AutoCompletionDecision.SHOW_LOOKUP;
            if (autoCompletionDecision == null) {
                Intrinsics.throwNpe();
            }
        }
        return autoCompletionDecision;
    }

    @Nullable
    public static final PyClass getPyClass(@NotNull CompletionParameters $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner($receiver.getPosition());
        if (!(scopeOwner instanceof PyFunction)) {
            scopeOwner = null;
        }
        PyFunction pyFunction = (PyFunction)scopeOwner;
        return pyFunction != null ? pyFunction.getContainingClass() : null;
    }

    @Nullable
    public static final PsiFile getFile(@NotNull CompletionParameters $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner($receiver.getPosition());
        if (!(scopeOwner instanceof PyFunction)) {
            scopeOwner = null;
        }
        PyFunction pyFunction = (PyFunction)scopeOwner;
        return pyFunction != null ? pyFunction.getContainingFile() : null;
    }

    @NotNull
    public static final TypeEvalContext getTypeEvalContext(@NotNull CompletionParameters $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiFile psiFile = $receiver.getOriginalFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"originalFile");
        TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion(psiFile.getProject(), $receiver.getOriginalFile());
        Intrinsics.checkExpressionValueIsNotNull((Object)typeEvalContext, (String)"TypeEvalContext.codeComp\u2026le.project, originalFile)");
        return typeEvalContext;
    }

    public static final void addMethodToResult(@NotNull CompletionResultSet result2, @Nullable PyClass pyClass, @NotNull TypeEvalContext typeEvalContext, @NotNull String methodName, @NotNull String methodParentheses, @Nullable Function1<? super LookupElementBuilder, LookupElementBuilder> builderPostprocessor) {
        LookupElementBuilder lookupElementBuilder;
        block5: {
            LookupElementBuilder item;
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
                Intrinsics.checkParameterIsNotNull((Object)typeEvalContext, (String)"typeEvalContext");
                Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
                Intrinsics.checkParameterIsNotNull((Object)methodParentheses, (String)"methodParentheses");
                PyClass pyClass2 = pyClass;
                if ((pyClass2 != null ? pyClass2.findMethodByName(methodName, false, typeEvalContext) : null) != null) {
                    return;
                }
                item = LookupElementBuilder.create((String)(methodName + methodParentheses)).withIcon(PythonIcons.Python.Nodes.Cyan_dot);
                lookupElementBuilder = builderPostprocessor;
                if (lookupElementBuilder == null) break block4;
                LookupElementBuilder lookupElementBuilder2 = item;
                Intrinsics.checkExpressionValueIsNotNull((Object)lookupElementBuilder2, (String)"item");
                if ((lookupElementBuilder = (LookupElementBuilder)lookupElementBuilder.invoke((Object)lookupElementBuilder2)) != null) break block5;
            }
            lookupElementBuilder = item;
        }
        result2.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)lookupElementBuilder, TailType.CASE_COLON));
    }

    public static /* bridge */ /* synthetic */ void addMethodToResult$default(CompletionResultSet completionResultSet, PyClass pyClass, TypeEvalContext typeEvalContext, String string, String string2, Function1 function1, int n, Object object) {
        if ((n & 0x10) != 0) {
            string2 = "(self)";
        }
        if ((n & 0x20) != 0) {
            function1 = null;
        }
        PyCompletionUtilsKt.addMethodToResult(completionResultSet, pyClass, typeEvalContext, string, string2, (Function1<? super LookupElementBuilder, LookupElementBuilder>)function1);
    }

    public static final void addFunctionToResult(@NotNull CompletionResultSet result2, @Nullable PyFile pyFile, @NotNull String functionName, @NotNull String functionParentheses, @Nullable Function1<? super LookupElementBuilder, LookupElementBuilder> builderPostprocessor) {
        LookupElementBuilder lookupElementBuilder;
        block5: {
            LookupElementBuilder item;
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
                Intrinsics.checkParameterIsNotNull((Object)functionName, (String)"functionName");
                Intrinsics.checkParameterIsNotNull((Object)functionParentheses, (String)"functionParentheses");
                PyFile pyFile2 = pyFile;
                if ((pyFile2 != null ? pyFile2.findTopLevelFunction(functionName) : null) != null) {
                    return;
                }
                item = LookupElementBuilder.create((String)(functionName + functionParentheses)).withIcon(PythonIcons.Python.Nodes.Cyan_dot);
                lookupElementBuilder = builderPostprocessor;
                if (lookupElementBuilder == null) break block4;
                LookupElementBuilder lookupElementBuilder2 = item;
                Intrinsics.checkExpressionValueIsNotNull((Object)lookupElementBuilder2, (String)"item");
                if ((lookupElementBuilder = (LookupElementBuilder)lookupElementBuilder.invoke((Object)lookupElementBuilder2)) != null) break block5;
            }
            lookupElementBuilder = item;
        }
        result2.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)lookupElementBuilder, TailType.CASE_COLON));
    }

    public static /* bridge */ /* synthetic */ void addFunctionToResult$default(CompletionResultSet completionResultSet, PyFile pyFile, String string, String string2, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = "()";
        }
        if ((n & 0x10) != 0) {
            function1 = null;
        }
        PyCompletionUtilsKt.addFunctionToResult(completionResultSet, pyFile, string, string2, (Function1<? super LookupElementBuilder, LookupElementBuilder>)function1);
    }

    @Nullable
    public static final LookupElementBuilder createLookupElementBuilder(@NotNull PsiFile file2, @NotNull PsiFileSystemItem element) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        String string = FileUtil.getNameWithoutExtension((String)element.getName());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.getNameWithoutExtension(element.name)");
        String name = string;
        if (!PyNames.isIdentifier(name)) {
            return null;
        }
        QualifiedName qualifiedName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)element, (PsiElement)file2);
        QualifiedName importPath = qualifiedName != null ? qualifiedName.removeLastComponent() : null;
        String tailText = importPath != null && importPath.getComponentCount() > 0 ? " (" + importPath + ')' : null;
        return LookupElementBuilder.create((Object)element, (String)name).withTailText(tailText, true).withIcon(element.getIcon(0));
    }
}

