/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PythonConsoleRunnerFactory;
import com.jetbrains.python.console.PythonConsoleToolWindowFactory;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonConsoleToolWindow {
    public static final Key<RunContentDescriptor> CONTENT_DESCRIPTOR = Key.create((String)"CONTENT_DESCRIPTOR");
    public static final Function<Content, RunContentDescriptor> CONTENT_TO_DESCRIPTOR_FUNCTION = input -> input != null ? (RunContentDescriptor)input.getUserData(CONTENT_DESCRIPTOR) : null;
    private final Project myProject;
    private boolean myInitialized = false;

    public PythonConsoleToolWindow(Project project) {
        this.myProject = project;
    }

    public static PythonConsoleToolWindow getInstance(@NotNull Project project) {
        if (project == null) {
            PythonConsoleToolWindow.$$$reportNull$$$0(0);
        }
        return (PythonConsoleToolWindow)project.getComponent(PythonConsoleToolWindow.class);
    }

    public List<RunContentDescriptor> getConsoleContentDescriptors() {
        return FluentIterable.from((Iterable)Lists.newArrayList((Object[])PythonConsoleToolWindow.getToolWindow(this.myProject).getContentManager().getContents())).transform(CONTENT_TO_DESCRIPTOR_FUNCTION).filter(Predicates.notNull()).toList();
    }

    public void init(@NotNull ToolWindow toolWindow, @NotNull RunContentDescriptor contentDescriptor) {
        if (toolWindow == null) {
            PythonConsoleToolWindow.$$$reportNull$$$0(1);
        }
        if (contentDescriptor == null) {
            PythonConsoleToolWindow.$$$reportNull$$$0(2);
        }
        PythonConsoleToolWindow.setContent(toolWindow, contentDescriptor);
        if (!this.myInitialized) {
            this.doInit(toolWindow);
        }
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }

    private void doInit(final @NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            PythonConsoleToolWindow.$$$reportNull$$$0(3);
        }
        this.myInitialized = true;
        toolWindow.setToHideOnEmptyContent(true);
        this.myProject.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            @Override
            public void stateChanged() {
                boolean visible;
                ToolWindow window = PythonConsoleToolWindow.getToolWindow(PythonConsoleToolWindow.this.myProject);
                if (window != null && (visible = window.isVisible()) && toolWindow.getContentManager().getContentCount() == 0) {
                    PydevConsoleRunner runner = PythonConsoleRunnerFactory.getInstance().createConsoleRunner(PythonConsoleToolWindow.this.myProject, null);
                    runner.run(true);
                }
            }
        });
    }

    private static void setContent(ToolWindow toolWindow, RunContentDescriptor contentDescriptor) {
        toolWindow.getComponent().putClientProperty("HideIdLabel", "true");
        Content content = toolWindow.getContentManager().findContent(contentDescriptor.getDisplayName());
        if (content == null) {
            content = PythonConsoleToolWindow.createContent(contentDescriptor);
            toolWindow.getContentManager().addContent(content);
        } else {
            SimpleToolWindowPanel panel2 = new SimpleToolWindowPanel(false, true);
            PythonConsoleToolWindow.resetContent(contentDescriptor, panel2, content);
        }
        toolWindow.getContentManager().setSelectedContent(content);
    }

    public ToolWindow getToolWindow() {
        return PythonConsoleToolWindow.getToolWindow(this.myProject);
    }

    public static ToolWindow getToolWindow(Project project) {
        return ToolWindowManager.getInstance((Project)project).getToolWindow(PythonConsoleToolWindowFactory.Companion.getID());
    }

    public void setContent(RunContentDescriptor contentDescriptor) {
        PythonConsoleToolWindow.setContent(PythonConsoleToolWindow.getToolWindow(this.myProject), contentDescriptor);
    }

    private static Content createContent(@NotNull RunContentDescriptor contentDescriptor) {
        if (contentDescriptor == null) {
            PythonConsoleToolWindow.$$$reportNull$$$0(4);
        }
        SimpleToolWindowPanel panel2 = new SimpleToolWindowPanel(false, true);
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)panel2, contentDescriptor.getDisplayName(), false);
        content.setCloseable(true);
        PythonConsoleToolWindow.resetContent(contentDescriptor, panel2, content);
        return content;
    }

    private static void resetContent(RunContentDescriptor contentDescriptor, SimpleToolWindowPanel panel2, Content content) {
        RunContentDescriptor oldDescriptor;
        RunContentDescriptor runContentDescriptor = oldDescriptor = content.getDisposer() instanceof RunContentDescriptor ? (RunContentDescriptor)content.getDisposer() : null;
        if (oldDescriptor != null) {
            Disposer.dispose((Disposable)oldDescriptor);
        }
        panel2.setContent(contentDescriptor.getComponent());
        content.setComponent((JComponent)panel2);
        content.setDisposer((Disposable)contentDescriptor);
        content.setPreferredFocusableComponent(contentDescriptor.getComponent());
        content.putUserData(CONTENT_DESCRIPTOR, (Object)contentDescriptor);
    }

    private static FocusListener createFocusListener(final ToolWindow toolWindow) {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JComponent component = PythonConsoleToolWindow.getComponentToFocus(toolWindow);
                if (component != null) {
                    component.requestFocusInWindow();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
    }

    private static JComponent getComponentToFocus(ToolWindow window) {
        return window.getContentManager().getComponent();
    }

    public void activate(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            PythonConsoleToolWindow.$$$reportNull$$$0(5);
        }
        PythonConsoleToolWindow.getToolWindow(this.myProject).activate(runnable2);
    }

    @Nullable
    public RunContentDescriptor getSelectedContentDescriptor() {
        return (RunContentDescriptor)CONTENT_TO_DESCRIPTOR_FUNCTION.apply((Object)PythonConsoleToolWindow.getToolWindow(this.myProject).getContentManager().getSelectedContent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentDescriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/console/PythonConsoleToolWindow";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doInit";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createContent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "activate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

