/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.startup.StartupActivity;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackageService;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class PyPackagesUpdater
implements StartupActivity {
    private static final Logger LOG = Logger.getInstance(PyPackagesUpdater.class);
    private static final long EXPIRATION_TIMEOUT = 86400000L;

    public void runActivity(@NotNull Project project) {
        Application application;
        if (project == null) {
            PyPackagesUpdater.$$$reportNull$$$0(0);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode()) {
            return;
        }
        if (PyPackagesUpdater.checkNeeded(project)) {
            application.executeOnPooledThread(() -> {
                try {
                    PyPIPackageUtil.INSTANCE.updatePyPICache();
                }
                catch (IOException e) {
                    LOG.warn(e.getMessage());
                }
            });
        }
        if (PyPackagesUpdater.checkCondaUpdateNeeded(project)) {
            application.executeOnPooledThread(() -> PyCondaPackageService.getInstance().updatePackagesCache());
        }
    }

    private static boolean checkCondaUpdateNeeded(Project project) {
        if (!PyPackagesUpdater.hasPython(project)) {
            return false;
        }
        long timeDelta = System.currentTimeMillis() - PyCondaPackageService.getInstance().LAST_TIME_CHECKED;
        if (Math.abs(timeDelta) < 86400000L) {
            return false;
        }
        LOG.debug("Updating outdated Conda package cache");
        return true;
    }

    private static boolean hasPython(Project project) {
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            Sdk sdk = PythonSdkType.findPythonSdk(module2);
            if (sdk == null || !(sdk.getSdkType() instanceof PythonSdkType)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkNeeded(Project project) {
        if (!PyPackagesUpdater.hasPython(project)) {
            return false;
        }
        PyPackageService service2 = PyPackageService.getInstance();
        if (service2.PYPI_REMOVED.booleanValue()) {
            return false;
        }
        long timeDelta = System.currentTimeMillis() - service2.LAST_TIME_CHECKED;
        if (Math.abs(timeDelta) < 86400000L) {
            return false;
        }
        LOG.debug("Updating outdated PyPI package cache");
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/packaging/PyPackagesUpdater", "runActivity"));
    }
}

