/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveProcessor;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyResolveUtil {
    private PyResolveUtil() {
    }

    public static void scopeCrawlUp(@NotNull PsiScopeProcessor processor2, @NotNull PsiElement element, @Nullable String name, @Nullable PsiElement roof) {
        ScopeOwner outerScopeOwner;
        PsiElement realContext;
        if (processor2 == null) {
            PyResolveUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PyResolveUtil.$$$reportNull$$$0(1);
        }
        ScopeOwner originalOwner = (realContext = PyPsiUtils.getRealContext(element)) != element && realContext instanceof PyFile ? (PyFile)realContext : ScopeUtil.getScopeOwner(realContext);
        PsiElement parent = element.getParent();
        boolean isGlobalOrNonlocal = parent instanceof PyGlobalStatement || parent instanceof PyNonlocalStatement;
        ScopeOwner owner = originalOwner;
        if (isGlobalOrNonlocal && (outerScopeOwner = ScopeUtil.getScopeOwner((PsiElement)owner)) != null) {
            owner = outerScopeOwner;
        }
        PyResolveUtil.scopeCrawlUp(processor2, owner, originalOwner, name, roof);
    }

    public static void scopeCrawlUp(@NotNull PsiScopeProcessor processor2, @NotNull ScopeOwner scopeOwner, @Nullable String name, @Nullable PsiElement roof) {
        if (processor2 == null) {
            PyResolveUtil.$$$reportNull$$$0(2);
        }
        if (scopeOwner == null) {
            PyResolveUtil.$$$reportNull$$$0(3);
        }
        PyResolveUtil.scopeCrawlUp(processor2, scopeOwner, scopeOwner, name, roof);
    }

    public static void scopeCrawlUp(@NotNull PsiScopeProcessor processor2, @Nullable ScopeOwner scopeOwner, @Nullable ScopeOwner originalScopeOwner, @Nullable String name, @Nullable PsiElement roof) {
        if (processor2 == null) {
            PyResolveUtil.$$$reportNull$$$0(4);
        }
        while (scopeOwner != null) {
            if (!(scopeOwner instanceof PyClass) || scopeOwner == originalScopeOwner) {
                Scope scope = ControlFlowCache.getScope(scopeOwner);
                if (name != null) {
                    boolean includeNestedGlobals = scopeOwner instanceof PyFile;
                    for (PsiNamedElement resolved : scope.getNamedElements(name, includeNestedGlobals)) {
                        if (processor2.execute((PsiElement)resolved, ResolveState.initial())) continue;
                        return;
                    }
                } else {
                    for (PsiNamedElement element : scope.getNamedElements()) {
                        if (processor2.execute((PsiElement)element, ResolveState.initial())) continue;
                        return;
                    }
                }
                for (PyImportedNameDefiner definer : scope.getImportedNameDefiners()) {
                    if (processor2.execute((PsiElement)definer, ResolveState.initial())) continue;
                    return;
                }
            }
            if (scopeOwner == roof) {
                return;
            }
            if (name != null && scopeOwner instanceof PyClass && scopeOwner == originalScopeOwner) {
                scopeOwner = PyResolveUtil.parentScopeForUnresolvedClassLevelName((PyClass)scopeOwner, name);
                continue;
            }
            scopeOwner = ScopeUtil.getScopeOwner((PsiElement)scopeOwner);
        }
    }

    @NotNull
    public static Collection<PsiElement> resolveLocally(@NotNull PyReferenceExpression referenceExpression) {
        String referenceName;
        if (referenceExpression == null) {
            PyResolveUtil.$$$reportNull$$$0(5);
        }
        if ((referenceName = referenceExpression.getName()) == null || referenceExpression.isQualified()) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                PyResolveUtil.$$$reportNull$$$0(6);
            }
            return list2;
        }
        PyResolveProcessor processor2 = new PyResolveProcessor(referenceName, true);
        PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor2, (PsiElement)referenceExpression, referenceName, null);
        Collection<PsiElement> collection = processor2.getElements();
        if (collection == null) {
            PyResolveUtil.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> resolveLocally(@NotNull ScopeOwner scopeOwner, @NotNull String name) {
        if (scopeOwner == null) {
            PyResolveUtil.$$$reportNull$$$0(8);
        }
        if (name == null) {
            PyResolveUtil.$$$reportNull$$$0(9);
        }
        PyResolveProcessor processor2 = new PyResolveProcessor(name, true);
        PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor2, scopeOwner, name, null);
        Collection<PsiElement> collection = processor2.getElements();
        if (collection == null) {
            PyResolveUtil.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public static List<QualifiedName> resolveImportedElementQNameLocally(@NotNull PyReferenceExpression expression) {
        PyExpression qualifier;
        if (expression == null) {
            PyResolveUtil.$$$reportNull$$$0(11);
        }
        if ((qualifier = expression.getQualifier()) instanceof PyReferenceExpression) {
            String name = expression.getName();
            List list2 = name == null ? Collections.emptyList() : ContainerUtil.map(PyResolveUtil.resolveImportedElementQNameLocally((PyReferenceExpression)qualifier), qn -> qn.append(name));
            if (list2 == null) {
                PyResolveUtil.$$$reportNull$$$0(12);
            }
            return list2;
        }
        List list3 = PyResolveUtil.fullMultiResolveLocally(expression, new HashSet<PyReferenceExpression>()).select(PyImportElement.class).map(PyResolveUtil::getImportedElementQName).nonNull().toList();
        if (list3 == null) {
            PyResolveUtil.$$$reportNull$$$0(13);
        }
        return list3;
    }

    @Nullable
    private static QualifiedName getImportedElementQName(@NotNull PyImportElement element) {
        PyStatement importStatement;
        if (element == null) {
            PyResolveUtil.$$$reportNull$$$0(14);
        }
        if ((importStatement = element.getContainingImportStatement()) instanceof PyFromImportStatement) {
            QualifiedName importSourceQName = ((PyFromImportStatement)importStatement).getImportSourceQName();
            QualifiedName importedQName = element.getImportedQName();
            if (importSourceQName != null && importedQName != null) {
                return importSourceQName.append(importedQName);
            }
        }
        return element.getImportedQName();
    }

    @NotNull
    public static List<PsiElement> resolveQualifiedNameInScope(@NotNull QualifiedName qualifiedName, @NotNull ScopeOwner scopeOwner, @NotNull TypeEvalContext context) {
        StreamEx initialResults;
        List<RatedResolveResult> unqualifiedResults;
        String firstName;
        if (qualifiedName == null) {
            PyResolveUtil.$$$reportNull$$$0(15);
        }
        if (scopeOwner == null) {
            PyResolveUtil.$$$reportNull$$$0(16);
        }
        if (context == null) {
            PyResolveUtil.$$$reportNull$$$0(17);
        }
        if ((firstName = qualifiedName.getFirstComponent()) == null || !(scopeOwner instanceof PyTypedElement)) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                PyResolveUtil.$$$reportNull$$$0(18);
            }
            return list2;
        }
        PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
        if (scopeOwner instanceof PyiFile) {
            unqualifiedResults = ((PyiFile)scopeOwner).multiResolveName(firstName, false);
        } else {
            PyType scopeType = context.getType((PyTypedElement)((Object)scopeOwner));
            if (scopeType == null) {
                List<PsiElement> list3 = Collections.emptyList();
                if (list3 == null) {
                    PyResolveUtil.$$$reportNull$$$0(19);
                }
                return list3;
            }
            unqualifiedResults = scopeType.resolveMember(firstName, null, AccessDirection.READ, resolveContext);
        }
        if (ContainerUtil.isEmpty(unqualifiedResults)) {
            PsiElement builtin = PyBuiltinCache.getInstance((PsiElement)scopeOwner).getByName(firstName);
            if (builtin == null) {
                List<PsiElement> list4 = Collections.emptyList();
                if (list4 == null) {
                    PyResolveUtil.$$$reportNull$$$0(20);
                }
                return list4;
            }
            initialResults = StreamEx.of((Object)new RatedResolveResult(0, builtin));
        } else {
            initialResults = StreamEx.of(unqualifiedResults);
        }
        List remainingNames = qualifiedName.removeHead(1).getComponents();
        StreamEx result2 = (StreamEx)StreamEx.of((Collection)remainingNames).foldLeft((Object)initialResults, (prev2, name) -> {
            if (context == null) {
                PyResolveUtil.$$$reportNull$$$0(34);
            }
            return prev2.map(RatedResolveResult::getElement).select(PyTypedElement.class).map(context::getType).nonNull().flatMap(type -> {
                PyType instanceType = type instanceof PyClassLikeType ? ((PyClassLikeType)type).toInstance() : type;
                List<? extends RatedResolveResult> results = instanceType.resolveMember((String)name, null, AccessDirection.READ, resolveContext);
                return results != null ? StreamEx.of(results) : StreamEx.empty();
            });
        });
        List<PsiElement> list5 = PyUtil.filterTopPriorityResults((ResolveResult[])result2.toArray(RatedResolveResult[]::new));
        if (list5 == null) {
            PyResolveUtil.$$$reportNull$$$0(21);
        }
        return list5;
    }

    @Nullable
    public static String resolveFirstStrArgument(@NotNull PyCallExpression callExpression) {
        PyExpression nameExpression;
        if (callExpression == null) {
            PyResolveUtil.$$$reportNull$$$0(22);
        }
        if ((nameExpression = PyPsiUtils.flattenParens(callExpression.getArgument(0, PyExpression.class))) instanceof PyReferenceExpression) {
            return PyPsiUtils.strValue(PyResolveUtil.fullResolveLocally((PyReferenceExpression)nameExpression));
        }
        return PyPsiUtils.strValue(nameExpression);
    }

    @Nullable
    public static PyExpression fullResolveLocally(@NotNull PyReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            PyResolveUtil.$$$reportNull$$$0(23);
        }
        return PyResolveUtil.fullMultiResolveLocally(referenceExpression, new HashSet<PyReferenceExpression>()).select(PyExpression.class).findFirst().orElse(null);
    }

    @NotNull
    private static StreamEx<PsiElement> fullMultiResolveLocally(@NotNull PyReferenceExpression referenceExpression, @NotNull Set<PyReferenceExpression> visited) {
        if (referenceExpression == null) {
            PyResolveUtil.$$$reportNull$$$0(24);
        }
        if (visited == null) {
            PyResolveUtil.$$$reportNull$$$0(25);
        }
        StreamEx streamEx = StreamEx.of(PyResolveUtil.resolveLocally(referenceExpression)).flatMap(element -> {
            if (visited == null) {
                PyResolveUtil.$$$reportNull$$$0(33);
            }
            if (element instanceof PyTargetExpression) {
                PyExpression assignedValue = ((PyTargetExpression)element).findAssignedValue();
                if (assignedValue instanceof PyReferenceExpression && visited.add((PyReferenceExpression)assignedValue)) {
                    return PyResolveUtil.fullMultiResolveLocally((PyReferenceExpression)assignedValue, visited);
                }
                return StreamEx.of((Object)assignedValue);
            }
            return StreamEx.of((Object)element);
        });
        if (streamEx == null) {
            PyResolveUtil.$$$reportNull$$$0(26);
        }
        return streamEx;
    }

    public static boolean allowForwardReferences(@NotNull PyQualifiedExpression element) {
        if (element == null) {
            PyResolveUtil.$$$reportNull$$$0(27);
        }
        if (PyiUtil.isInsideStubAnnotation((PsiElement)element)) {
            return true;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 instanceof PyFile) {
            PyFile pyFile = (PyFile)file2;
            return pyFile.getLanguageLevel().isAtLeast(LanguageLevel.PYTHON37) && pyFile.hasImportFromFuture(FutureFeature.ANNOTATIONS) && PsiTreeUtil.getParentOfType((PsiElement)element, PyAnnotation.class) != null;
        }
        return false;
    }

    @Nullable
    public static ScopeOwner parentScopeForUnresolvedClassLevelName(@NotNull PyClass cls, @NotNull String name) {
        if (cls == null) {
            PyResolveUtil.$$$reportNull$$$0(28);
        }
        if (name == null) {
            PyResolveUtil.$$$reportNull$$$0(29);
        }
        return PyResolveUtil.containsDeclaration(cls, name) ? (ScopeOwner)PyUtil.as(cls.getContainingFile(), PyFile.class) : ScopeUtil.getScopeOwner((PsiElement)cls);
    }

    private static boolean containsDeclaration(@NotNull PyClass cls, @NotNull String name) {
        Scope scope;
        if (cls == null) {
            PyResolveUtil.$$$reportNull$$$0(30);
        }
        if (name == null) {
            PyResolveUtil.$$$reportNull$$$0(31);
        }
        if (!(scope = ControlFlowCache.getScope(cls)).getNamedElements(name, false).isEmpty()) {
            return true;
        }
        return StreamEx.of(scope.getImportedNameDefiners()).select(PyImportElement.class).anyMatch(e -> {
            if (name == null) {
                PyResolveUtil.$$$reportNull$$$0(32);
            }
            return name.equals(e.getVisibleName());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 14: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeOwner";
                break;
            }
            case 5: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/resolve/PyResolveUtil";
                break;
            }
            case 9: 
            case 29: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 17: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 25: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/resolve/PyResolveUtil";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocally";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveImportedElementQNameLocally";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveQualifiedNameInScope";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "fullMultiResolveLocally";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "scopeCrawlUp";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocally";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveImportedElementQNameLocally";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getImportedElementQName";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveQualifiedNameInScope";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveFirstStrArgument";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fullResolveLocally";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fullMultiResolveLocally";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "allowForwardReferences";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "parentScopeForUnresolvedClassLevelName";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "containsDeclaration";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$containsDeclaration$5";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fullMultiResolveLocally$4";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveQualifiedNameInScope$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

