/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.move;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.QualifiedName;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.impl.PyImportStatementNavigator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMoveRefactoringUtil {
    private PyMoveRefactoringUtil() {
    }

    public static void checkValidImportableFile(@NotNull PsiElement anchor2, @NotNull VirtualFile file2) {
        QualifiedName qName;
        if (anchor2 == null) {
            PyMoveRefactoringUtil.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            PyMoveRefactoringUtil.$$$reportNull$$$0(1);
        }
        if (!PyClassRefactoringUtil.isValidQualifiedName(qName = QualifiedNameFinder.findShortestImportableQName(anchor2, file2))) {
            throw new IncorrectOperationException(PyBundle.message("refactoring.move.error.cannot.use.module.name.$0", file2.getName()));
        }
    }

    @NotNull
    public static String getPresentableName(@NotNull PsiNamedElement element) {
        if (element == null) {
            PyMoveRefactoringUtil.$$$reportNull$$$0(2);
        }
        String name = null;
        if (element instanceof PyQualifiedNameOwner) {
            name = ((PyQualifiedNameOwner)element).getQualifiedName();
        }
        if (StringUtil.isEmpty(name)) {
            name = element.getName();
        }
        if (StringUtil.isNotEmpty((String)name)) {
            String string = element instanceof PyFunction ? name + "()" : name;
            if (string == null) {
                PyMoveRefactoringUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        if ("" == null) {
            PyMoveRefactoringUtil.$$$reportNull$$$0(4);
        }
        return "";
    }

    @Nullable
    public static PsiElement findLowestPossibleTopLevelInsertionPosition(@NotNull List<UsageInfo> usages, @NotNull PsiFile destination) {
        if (usages == null) {
            PyMoveRefactoringUtil.$$$reportNull$$$0(5);
        }
        if (destination == null) {
            PyMoveRefactoringUtil.$$$reportNull$$$0(6);
        }
        return PyMoveRefactoringUtil.findFirstTopLevelUsageInFile(usages, destination).map(element -> PyPsiUtils.getParentRightBefore(element, (PsiElement)element.getContainingFile())).orElse(null);
    }

    @NotNull
    private static Optional<PsiElement> findFirstTopLevelUsageInFile(@NotNull List<UsageInfo> usages, @NotNull PsiFile destination) {
        if (usages == null) {
            PyMoveRefactoringUtil.$$$reportNull$$$0(7);
        }
        if (destination == null) {
            PyMoveRefactoringUtil.$$$reportNull$$$0(8);
        }
        Optional<PsiElement> optional = usages.stream().map(UsageInfo::getElement).filter(Objects::nonNull).filter(element -> {
            if (destination == null) {
                PyMoveRefactoringUtil.$$$reportNull$$$0(10);
            }
            return ScopeUtil.getScopeOwner(element) == destination;
        }).filter(element -> PyImportStatementNavigator.getImportStatementByElement(element) == null).min(PsiUtilCore::compareElementsByPosition);
        if (optional == null) {
            PyMoveRefactoringUtil.$$$reportNull$$$0(9);
        }
        return optional;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/move/PyMoveRefactoringUtil";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/move/PyMoveRefactoringUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findFirstTopLevelUsageInFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkValidImportableFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findLowestPossibleTopLevelInsertionPosition";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findFirstTopLevelUsageInFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findFirstTopLevelUsageInFile$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

