/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.testing.PyTestFrameworkService;
import com.jetbrains.python.testing.PythonTestConfigurationsModel;
import com.jetbrains.python.testing.TestRunnerService;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class PyIntegratedToolsProjectConfigurator
implements DirectoryProjectConfigurator {
    private static final Logger LOG = Logger.getInstance(PyIntegratedToolsProjectConfigurator.class);

    @Override
    public void configureProject(Project project, @NotNull VirtualFile baseDir, Ref<Module> moduleRef) {
        Application application;
        if (baseDir == null) {
            PyIntegratedToolsProjectConfigurator.$$$reportNull$$$0(0);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode()) {
            return;
        }
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            if (!(ModuleType.get((Module)module2) instanceof PythonModuleTypeBase)) continue;
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> PyIntegratedToolsProjectConfigurator.updateIntegratedTools(module2), 10L, TimeUnit.SECONDS);
            break;
        }
    }

    private static void updateIntegratedTools(@NotNull Module module2) {
        TestRunnerService runnerService;
        Sdk sdk;
        if (module2 == null) {
            PyIntegratedToolsProjectConfigurator.$$$reportNull$$$0(1);
        }
        if (module2.isDisposed()) {
            return;
        }
        assert (!ApplicationManager.getApplication().isDispatchThread()) : "This method should not be called on AWT";
        PyDocumentationSettings docSettings = PyDocumentationSettings.getInstance(module2);
        LOG.debug("Integrated tools configurator has started");
        if (module2.isDisposed()) {
            return;
        }
        DocStringFormat docFormat = DocStringFormat.PLAIN;
        String testRunner = (String)ReadAction.compute(() -> {
            if (module2 == null) {
                PyIntegratedToolsProjectConfigurator.$$$reportNull$$$0(17);
            }
            return PyIntegratedToolsProjectConfigurator.detectTestRunnerFromSetupPy(module2);
        });
        assert (testRunner != null) : "detectTestRunnerFromSetupPy can't return null";
        if (!testRunner.isEmpty()) {
            LOG.debug("Test runner '" + testRunner + "' was discovered from setup.py in the module '" + module2.getModuleFilePath() + "'");
        }
        String extension = PythonFileType.INSTANCE.getDefaultExtension();
        GlobalSearchScope searchScope = module2.getModuleScope();
        Collection pyFiles = (Collection)ReadAction.compute(() -> {
            if (module2 == null) {
                PyIntegratedToolsProjectConfigurator.$$$reportNull$$$0(16);
            }
            return FilenameIndex.getAllFilesByExt(module2.getProject(), extension, searchScope);
        });
        for (VirtualFile file2 : pyFiles) {
            if (file2.getName().startsWith("test")) {
                if (testRunner.isEmpty() && !(testRunner = PyIntegratedToolsProjectConfigurator.checkImports(file2, module2)).isEmpty()) {
                    LOG.debug("Test runner '" + testRunner + "' was detected from imports in the file '" + file2.getPath() + "'");
                }
            } else if (docFormat == DocStringFormat.PLAIN && (docFormat = (DocStringFormat)((Object)ReadAction.compute(() -> {
                if (module2 == null) {
                    PyIntegratedToolsProjectConfigurator.$$$reportNull$$$0(15);
                }
                return PyIntegratedToolsProjectConfigurator.checkDocstring(file2, module2);
            }))) != DocStringFormat.PLAIN) {
                LOG.debug("Docstring format '" + (Object)((Object)docFormat) + "' was detected from content of the file '" + file2.getPath() + "'");
            }
            if (testRunner.isEmpty() || docFormat == DocStringFormat.PLAIN) continue;
            break;
        }
        if (testRunner.isEmpty() && (sdk = PythonSdkType.findPythonSdk(module2)) != null && sdk.getSdkType() instanceof PythonSdkType) {
            List<PyPackage> packages = PyPackageUtil.refreshAndGetPackagesModally(sdk);
            for (String framework : PyTestFrameworkService.getFrameworkNamesArray()) {
                if (PyPackageUtil.findPackage(packages, framework) == null) continue;
                testRunner = PyTestFrameworkService.getSdkReadableNameByFramework(framework);
                break;
            }
            if (!testRunner.isEmpty()) {
                LOG.debug("Test runner '" + testRunner + "' was detected from SDK " + sdk);
            }
        }
        if ((runnerService = TestRunnerService.getInstance(module2)) != null) {
            if (testRunner.isEmpty()) {
                runnerService.setProjectConfiguration(PythonTestConfigurationsModel.PYTHONS_UNITTEST_NAME);
            } else {
                runnerService.setProjectConfiguration(testRunner);
                LOG.info("Test runner '" + testRunner + "' was detected by project configurator");
            }
        }
        if (docFormat != DocStringFormat.PLAIN) {
            docSettings.setFormat(docFormat);
            LOG.info("Docstring format '" + (Object)((Object)docFormat) + "' was detected by project configurator");
        }
    }

    @NotNull
    private static String detectTestRunnerFromSetupPy(@NotNull Module module2) {
        PyCallExpression setupCall;
        if (module2 == null) {
            PyIntegratedToolsProjectConfigurator.$$$reportNull$$$0(2);
        }
        if ((setupCall = PyPackageUtil.findSetupCall(module2)) == null) {
            if ("" == null) {
                PyIntegratedToolsProjectConfigurator.$$$reportNull$$$0(3);
            }
            return "";
        }
        for (String argumentName : Arrays.asList("test_loader", "test_suite")) {
            PyExpression argumentValue = setupCall.getKeywordArgument(argumentName);
            if (!(argumentValue instanceof PyStringLiteralExpression)) continue;
            String stringValue = ((PyStringLiteralExpression)argumentValue).getStringValue();
            for (String framework : PyTestFrameworkService.getFrameworkNamesArray()) {
                if (!stringValue.contains(framework)) continue;
                String string = PyTestFrameworkService.getSdkReadableNameByFramework(framework);
                if (string == null) {
                    PyIntegratedToolsProjectConfigurator.$$$reportNull$$$0(4);
                }
                return string;
            }
        }
        if ("" == null) {
            PyIntegratedToolsProjectConfigurator.$$$reportNull$$$0(5);
        }
        return "";
    }

    @NotNull
    private static DocStringFormat checkDocstring(@NotNull VirtualFile file2, @NotNull Module module2) {
        PsiFile psiFile;
        if (file2 == null) {
            PyIntegratedToolsProjectConfigurator.$$$reportNull$$$0(6);
        }
        if (module2 == null) {
            PyIntegratedToolsProjectConfigurator.$$$reportNull$$$0(7);
        }
        if ((psiFile = PsiManager.getInstance((Project)module2.getProject()).findFile(file2)) instanceof PyFile) {
            DocStringFormat perFileFormat = PyDocumentationSettings.getFormatFromDocformatAttribute(psiFile);
            if (perFileFormat != null) {
                DocStringFormat docStringFormat = perFileFormat;
                if (docStringFormat == null) {
                    PyIntegratedToolsProjectConfigurator.$$$reportNull$$$0(8);
                }
                return docStringFormat;
            }
            PyDocStringOwner[] children2 = (PyDocStringOwner[])PsiTreeUtil.getChildrenOfType((PsiElement)psiFile, PyDocStringOwner.class);
            if (children2 != null) {
                for (PyDocStringOwner owner : children2) {
                    DocStringFormat guessed;
                    PyStringLiteralExpression docStringExpression = owner.getDocStringExpression();
                    if (docStringExpression == null || (guessed = DocStringUtil.guessDocStringFormat(docStringExpression.getStringValue())) == DocStringFormat.PLAIN) continue;
                    DocStringFormat docStringFormat = guessed;
                    if (docStringFormat == null) {
                        PyIntegratedToolsProjectConfigurator.$$$reportNull$$$0(9);
                    }
                    return docStringFormat;
                }
            }
        }
        DocStringFormat docStringFormat = DocStringFormat.PLAIN;
        if (docStringFormat == null) {
            PyIntegratedToolsProjectConfigurator.$$$reportNull$$$0(10);
        }
        return docStringFormat;
    }

    @NotNull
    private static String checkImports(@NotNull VirtualFile file2, @NotNull Module module2) {
        PsiFile psiFile;
        if (file2 == null) {
            PyIntegratedToolsProjectConfigurator.$$$reportNull$$$0(11);
        }
        if (module2 == null) {
            PyIntegratedToolsProjectConfigurator.$$$reportNull$$$0(12);
        }
        if ((psiFile = PsiManager.getInstance((Project)module2.getProject()).findFile(file2)) instanceof PyFile) {
            List<PyImportElement> importTargets = ((PyFile)psiFile).getImportTargets();
            for (PyImportElement importElement : importTargets) {
                for (String framework : PyTestFrameworkService.getFrameworkNamesArray()) {
                    if (!framework.equals(importElement.getVisibleName())) continue;
                    String string = PyTestFrameworkService.getSdkReadableNameByFramework(framework);
                    if (string == null) {
                        PyIntegratedToolsProjectConfigurator.$$$reportNull$$$0(13);
                    }
                    return string;
                }
            }
        }
        if ("" == null) {
            PyIntegratedToolsProjectConfigurator.$$$reportNull$$$0(14);
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/testing/PyIntegratedToolsProjectConfigurator";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/testing/PyIntegratedToolsProjectConfigurator";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "detectTestRunnerFromSetupPy";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "checkDocstring";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "checkImports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateIntegratedTools";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "detectTestRunnerFromSetupPy";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkDocstring";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkImports";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateIntegratedTools$3";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateIntegratedTools$2";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateIntegratedTools$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

