/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.util.registry.Registry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u001a\u001a\u0010\f\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0013\u001a\n\u0010\u0014\u001a\u00020\u0015*\u00020\u0006\u001a\u0012\u0010\u0016\u001a\u00020\u0017*\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u001a\n\u0010\u0018\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010\u0019\u001a\u00020\u0015*\u00020\u0006\u001a\u0012\u0010\u001a\u001a\u00020\b*\u00020\b2\u0006\u0010\u001b\u001a\u00020\b\u001a\"\u0010\f\u001a\u00020\u0006*\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0001\u001a*\u0010\u001c\u001a\u00020\u0015*\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 H\u0007\u001a\u001a\u0010\u001c\u001a\u00020\u0015*\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0017\u001a8\u0010\u001c\u001a\u00020\u0015*\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 H\u0007\u001a\n\u0010\"\u001a\u00020\u0015*\u00020\u0006\"\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006#"}, d2={"SERVER_HEADER_VALUE", "", "serverHeaderValue", "getServerHeaderValue", "()Ljava/lang/String;", "createStatusResponse", "Lio/netty/handler/codec/http/HttpResponse;", "responseStatus", "Lio/netty/handler/codec/http/HttpResponseStatus;", "request", "Lio/netty/handler/codec/http/HttpRequest;", "description", "response", "Lio/netty/handler/codec/http/FullHttpResponse;", "content", "", "charset", "Ljava/nio/charset/Charset;", "contentType", "Lio/netty/buffer/ByteBuf;", "addCommonHeaders", "", "addKeepAliveIfNeed", "", "addNoCache", "addServer", "orInSafeMode", "safeStatus", "send", "channel", "Lio/netty/channel/Channel;", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "close", "setDate", "intellij.platform.ide.impl"})
@JvmName(name="Responses")
public final class Responses {
    private static String SERVER_HEADER_VALUE;

    @NotNull
    public static final FullHttpResponse response(@Nullable String contentType, @Nullable ByteBuf content) {
        DefaultFullHttpResponse response;
        DefaultFullHttpResponse defaultFullHttpResponse = response = content == null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
        if (contentType != null) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        }
        return (FullHttpResponse)response;
    }

    @NotNull
    public static final FullHttpResponse response(@NotNull CharSequence content, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        return (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)content, (Charset)charset));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ FullHttpResponse response$default(CharSequence charSequence, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            Charset charset2 = CharsetUtil.US_ASCII;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset2, (String)"CharsetUtil.US_ASCII");
            charset = charset2;
        }
        return Responses.response(charSequence, charset);
    }

    public static final void setDate(@NotNull HttpResponse $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!$receiver.headers().contains((CharSequence)HttpHeaderNames.DATE)) {
            HttpHeaders httpHeaders = $receiver.headers();
            CharSequence charSequence = (CharSequence)HttpHeaderNames.DATE;
            Calendar calendar = Calendar.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
            httpHeaders.set(charSequence, (Object)calendar.getTime());
        }
    }

    @NotNull
    public static final HttpResponse addNoCache(@NotNull HttpResponse $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.headers().add((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"no-cache, no-store, must-revalidate, max-age=0");
        $receiver.headers().add((CharSequence)HttpHeaderNames.PRAGMA, (Object)"no-cache");
        return $receiver;
    }

    @Nullable
    public static final String getServerHeaderValue() {
        Application app;
        if (SERVER_HEADER_VALUE == null && (app = ApplicationManager.getApplication()) != null && !app.isDisposed()) {
            ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)applicationInfoEx), (String)"ApplicationInfoEx.getInstanceEx()");
            SERVER_HEADER_VALUE = applicationInfoEx.getFullApplicationName();
        }
        return SERVER_HEADER_VALUE;
    }

    public static final void addServer(@NotNull HttpResponse $receiver) {
        block0: {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            String string2 = Responses.getServerHeaderValue();
            if (string2 == null) break block0;
            String it = string = string2;
            $receiver.headers().add((CharSequence)HttpHeaderNames.SERVER, (Object)it);
        }
    }

    @JvmOverloads
    public static final void send(@NotNull HttpResponse $receiver, @NotNull Channel channel, @Nullable HttpRequest request, @Nullable HttpHeaders extraHeaders) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        if ($receiver.status() != HttpResponseStatus.NOT_MODIFIED && !HttpUtil.isContentLengthSet((HttpMessage)((HttpMessage)$receiver))) {
            HttpUtil.setContentLength((HttpMessage)((HttpMessage)$receiver), (long)($receiver instanceof FullHttpResponse ? ((FullHttpResponse)$receiver).content().readableBytes() : 0));
        }
        Responses.addCommonHeaders($receiver);
        HttpHeaders httpHeaders = extraHeaders;
        if (httpHeaders != null) {
            HttpHeaders httpHeaders2;
            HttpHeaders it = httpHeaders2 = httpHeaders;
            $receiver.headers().add(it);
        }
        Responses.send($receiver, channel, request != null && !Responses.addKeepAliveIfNeed($receiver, request));
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void send$default(HttpResponse httpResponse, Channel channel, HttpRequest httpRequest, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 4) != 0) {
            httpHeaders = null;
        }
        Responses.send(httpResponse, channel, httpRequest, httpHeaders);
    }

    @JvmOverloads
    public static final void send(@NotNull HttpResponse $receiver, @NotNull Channel channel, @Nullable HttpRequest request) {
        Responses.send$default($receiver, channel, request, null, 4, null);
    }

    public static final boolean addKeepAliveIfNeed(@NotNull HttpResponse $receiver, @NotNull HttpRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        if (HttpUtil.isKeepAlive((HttpMessage)((HttpMessage)request))) {
            HttpUtil.setKeepAlive((HttpMessage)((HttpMessage)$receiver), (boolean)true);
            return true;
        }
        return false;
    }

    public static final void addCommonHeaders(@NotNull HttpResponse $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Responses.addServer($receiver);
        Responses.setDate($receiver);
        if (!$receiver.headers().contains("X-Frame-Options")) {
            $receiver.headers().set("X-Frame-Options", (Object)"SameOrigin");
        }
        $receiver.headers().set("X-Content-Type-Options", (Object)"nosniff");
        $receiver.headers().set("x-xss-protection", (Object)"1; mode=block");
    }

    public static final void send(@NotNull HttpResponse $receiver, @NotNull Channel channel, boolean close2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        if (!channel.isActive()) {
            return;
        }
        ChannelFuture future2 = channel.write((Object)$receiver);
        if (!($receiver instanceof FullHttpResponse)) {
            channel.write((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        }
        channel.flush();
        if (close2) {
            future2.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    @NotNull
    public static final HttpResponse response(@NotNull HttpResponseStatus $receiver, @Nullable HttpRequest request, @Nullable String description) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Responses.createStatusResponse($receiver, request, description);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ HttpResponse response$default(HttpResponseStatus httpResponseStatus, HttpRequest httpRequest, String string, int n, Object object) {
        if ((n & 1) != 0) {
            httpRequest = null;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return Responses.response(httpResponseStatus, httpRequest, string);
    }

    @JvmOverloads
    public static final void send(@NotNull HttpResponseStatus $receiver, @NotNull Channel channel, @Nullable HttpRequest request, @Nullable String description, @Nullable HttpHeaders extraHeaders) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Responses.send(Responses.createStatusResponse($receiver, request, description), channel, request, extraHeaders);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void send$default(HttpResponseStatus httpResponseStatus, Channel channel, HttpRequest httpRequest, String string, HttpHeaders httpHeaders, int n, Object object) {
        if ((n & 2) != 0) {
            httpRequest = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            httpHeaders = null;
        }
        Responses.send(httpResponseStatus, channel, httpRequest, string, httpHeaders);
    }

    @JvmOverloads
    public static final void send(@NotNull HttpResponseStatus $receiver, @NotNull Channel channel, @Nullable HttpRequest request, @Nullable String description) {
        Responses.send$default($receiver, channel, request, description, null, 8, null);
    }

    @JvmOverloads
    public static final void send(@NotNull HttpResponseStatus $receiver, @NotNull Channel channel, @Nullable HttpRequest request) {
        Responses.send$default($receiver, channel, request, null, null, 12, null);
    }

    @JvmOverloads
    public static final void send(@NotNull HttpResponseStatus $receiver, @NotNull Channel channel) {
        Responses.send$default($receiver, channel, null, null, null, 14, null);
    }

    @NotNull
    public static final HttpResponseStatus orInSafeMode(@NotNull HttpResponseStatus $receiver, @NotNull HttpResponseStatus safeStatus) {
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)safeStatus, (String)"safeStatus");
                if (Registry.is((String)"ide.http.server.response.actual.status", (boolean)true)) break block2;
                Application application = ApplicationManager.getApplication();
                if (!(application != null ? application.isUnitTestMode() : false)) break block3;
            }
            return $receiver;
        }
        return safeStatus;
    }

    private static final HttpResponse createStatusResponse(HttpResponseStatus responseStatus, HttpRequest request, String description) {
        if (request != null && request.method() == HttpMethod.HEAD) {
            return (HttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, Unpooled.EMPTY_BUFFER);
        }
        StringBuilder builder2 = new StringBuilder();
        String string = responseStatus.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"responseStatus.toString()");
        String message = string;
        builder2.append("<!doctype html><title>").append(message).append("</title>").append("<h1 style=\"text-align: center\">").append(message).append("</h1>");
        if (description != null) {
            builder2.append("<p>").append(description).append("</p>");
        }
        StringBuilder stringBuilder = builder2.append("<hr/><p style=\"text-align: center\">");
        String string2 = Responses.getServerHeaderValue();
        if (string2 == null) {
            string2 = "";
        }
        stringBuilder.append(string2).append("</p>");
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, ByteBufUtil.encodeString((ByteBufAllocator)ByteBufAllocator.DEFAULT, (CharBuffer)CharBuffer.wrap(builder2), (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html");
        return (HttpResponse)response;
    }
}

