/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.execution.HgPromptChoice;
import org.zmlx.hg4idea.execution.HgPromptHandler;

public class HgDeleteModifyPromptHandler
implements HgPromptHandler {
    private static final Logger LOG = Logger.getInstance((String)"#org.zmlx.hg4idea.execution.HgDeleteModifyPromptHandler");
    private static final Pattern LOCAL_DELETE_REMOTE_MODIFIED_CONFLICT_MESSAGE_PATTERN = Pattern.compile("remote\\schanged(.+)which\\slocal\\sdeleted\\s.+");
    private static final Pattern REMOTE_DELETE_LOCAL_MODIFIED_CONFLICT_MESSAGE_PATTERN = Pattern.compile("\\slocal\\schanged(.+)which\\sremote\\sdeleted\\s.+");

    @Override
    public HgPromptChoice promptUser(@NotNull String message, @NotNull HgPromptChoice[] choices, @NotNull HgPromptChoice defaultChoice) {
        String modifiedMessage;
        if (message == null) {
            HgDeleteModifyPromptHandler.$$$reportNull$$$0(0);
        }
        if (choices == null) {
            HgDeleteModifyPromptHandler.$$$reportNull$$$0(1);
        }
        if (defaultChoice == null) {
            HgDeleteModifyPromptHandler.$$$reportNull$$$0(2);
        }
        Matcher localDelMatcher = LOCAL_DELETE_REMOTE_MODIFIED_CONFLICT_MESSAGE_PATTERN.matcher(message);
        Matcher localModifyMatcher = REMOTE_DELETE_LOCAL_MODIFIED_CONFLICT_MESSAGE_PATTERN.matcher(message);
        if (localDelMatcher.matches()) {
            String filename = localDelMatcher.group(1);
            modifiedMessage = "File " + filename + " is deleted locally, but modified remotely. Do you want to keep the modified version or remove the file?";
        } else if (localModifyMatcher.matches()) {
            String filename = localModifyMatcher.group(1);
            modifiedMessage = "File " + filename + " is deleted remotely, but modified locally. Do you want to keep the modified version or remove the file?";
        } else {
            modifiedMessage = message;
        }
        int[] chosen = new int[]{-1};
        try {
            EventQueue.invokeAndWait(() -> {
                if (choices == null) {
                    HgDeleteModifyPromptHandler.$$$reportNull$$$0(3);
                }
                if (defaultChoice == null) {
                    HgDeleteModifyPromptHandler.$$$reportNull$$$0(4);
                }
                String[] choicePresentationArray = new String[choices.length];
                for (int i = 0; i < choices.length; ++i) {
                    choicePresentationArray[i] = choices[i].toString();
                }
                chosen[0] = Messages.showDialog((String)modifiedMessage, (String)"Delete-Modify Conflict", (String[])choicePresentationArray, (int)defaultChoice.getChosenIndex(), (Icon)Messages.getQuestionIcon());
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOG.error((Throwable)e);
            return defaultChoice;
        }
        return chosen[0] >= 0 ? choices[chosen[0]] : HgPromptChoice.ABORT;
    }

    @Override
    public boolean shouldHandle(@Nullable String message) {
        if (message == null) {
            return false;
        }
        Matcher localDelMatcher = LOCAL_DELETE_REMOTE_MODIFIED_CONFLICT_MESSAGE_PATTERN.matcher(message);
        Matcher localModifyMatcher = REMOTE_DELETE_LOCAL_MODIFIED_CONFLICT_MESSAGE_PATTERN.matcher(message);
        return localDelMatcher.matches() || localModifyMatcher.matches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "choices";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultChoice";
                break;
            }
        }
        objectArray2[1] = "org/zmlx/hg4idea/execution/HgDeleteModifyPromptHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "promptUser";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$promptUser$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

