/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.util.Key;
import git4idea.commands.GitLineHandlerAdapter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GitRebaseLineListener
extends GitLineHandlerAdapter {
    private static final Pattern PROGRESS = Pattern.compile("^Rebasing \\((\\d+)/(\\d+)\\)$");
    private String myProgressLine;

    @Override
    public synchronized void onLineAvailable(String line, Key outputType) {
        if (PROGRESS.matcher(line).matches()) {
            this.myProgressLine = line;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Result getResult() {
        int total;
        int current;
        if (this.myProgressLine != null) {
            Matcher matcher = PROGRESS.matcher(this.myProgressLine);
            if (!matcher.matches()) throw new IllegalStateException("The wrong current result line: " + this.myProgressLine);
            current = Integer.parseInt(matcher.group(1));
            total = Integer.parseInt(matcher.group(2));
            return new Result(total, current);
        } else {
            current = 0;
            total = 0;
        }
        return new Result(total, current);
    }

    public static final class Result {
        public final int total;
        public final int current;

        public Result(int total, int current) {
            this.total = total;
            this.current = current;
        }
    }
}

