/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import git4idea.DialogManager;
import java.awt.Component;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubProjectDefaultAccountHolder;
import org.jetbrains.plugins.github.authentication.ui.GithubLoginDialog;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u001a\u0010\r\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\nJ?\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00102\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0001\u00a2\u0006\u0002\b\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\nJ\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u001bJ\u0006\u0010\u001c\u001a\u00020\bJ\u000e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0010J\u001e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0013J \u0010\"\u001a\u0004\u0018\u00010\u00102\b\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J(\u0010#\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010$\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "", "accountManager", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager;", "(Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager;)V", "clearAccounts", "", "ensureHasAccounts", "", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "ensureHasAccountsWithTokens", "getAccounts", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "getDefaultAccount", "getOrRequestTokenForAccount", "", "account", "modalityStateSupplier", "Lkotlin/Function0;", "Lcom/intellij/openapi/application/ModalityState;", "getOrRequestTokenForAccount$intellij_vcs_github", "getSingleOrDefaultAccount", "getTokenForAccount", "getTokenForAccount$intellij_vcs_github", "hasAccounts", "hasTokenForAccount", "registerAccount", "name", "host", "token", "requestNewAccount", "requestNewToken", "setDefaultAccount", "Companion", "intellij.vcs.github"})
public final class GithubAuthenticationManager {
    private final GithubAccountManager accountManager;
    public static final Companion Companion = new Companion(null);

    public final boolean hasAccounts() {
        Collection collection = this.accountManager.getAccounts();
        return !collection.isEmpty();
    }

    @NotNull
    public final Set<GithubAccount> getAccounts() {
        return this.accountManager.getAccounts();
    }

    @Nullable
    public final String getTokenForAccount$intellij_vcs_github(@NotNull GithubAccount account) {
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        return this.accountManager.getTokenForAccount(account);
    }

    @JvmOverloads
    @Nullable
    public final String getOrRequestTokenForAccount$intellij_vcs_github(@NotNull GithubAccount account, @Nullable Project project, @Nullable Component parentComponent, @NotNull Function0<? extends ModalityState> modalityStateSupplier2) {
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        Intrinsics.checkParameterIsNotNull(modalityStateSupplier2, (String)"modalityStateSupplier");
        String string = this.getTokenForAccount$intellij_vcs_github(account);
        if (string == null) {
            string = (String)ActionsKt.invokeAndWaitIfNeed((ModalityState)((ModalityState)modalityStateSupplier2.invoke()), (Function0)((Function0)new Function0<String>(this, account, project, parentComponent){
                final /* synthetic */ GithubAuthenticationManager this$0;
                final /* synthetic */ GithubAccount $account;
                final /* synthetic */ Project $project;
                final /* synthetic */ Component $parentComponent;

                @Nullable
                public final String invoke() {
                    return GithubAuthenticationManager.access$requestNewToken(this.this$0, this.$account, this.$project, this.$parentComponent);
                }
                {
                    this.this$0 = githubAuthenticationManager;
                    this.$account = githubAccount;
                    this.$project = project;
                    this.$parentComponent = component;
                    super(0);
                }
            }));
        }
        return string;
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ String getOrRequestTokenForAccount$intellij_vcs_github$default(GithubAuthenticationManager githubAuthenticationManager, GithubAccount githubAccount, Project project, Component component, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            project = null;
        }
        if ((n & 4) != 0) {
            component = null;
        }
        if ((n & 8) != 0) {
            function0 = getOrRequestTokenForAccount.1.INSTANCE;
        }
        return githubAuthenticationManager.getOrRequestTokenForAccount$intellij_vcs_github(githubAccount, project, component, (Function0<? extends ModalityState>)function0);
    }

    @JvmOverloads
    @Nullable
    public final String getOrRequestTokenForAccount$intellij_vcs_github(@NotNull GithubAccount account, @Nullable Project project, @Nullable Component parentComponent) {
        return GithubAuthenticationManager.getOrRequestTokenForAccount$intellij_vcs_github$default(this, account, project, parentComponent, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public final String getOrRequestTokenForAccount$intellij_vcs_github(@NotNull GithubAccount account, @Nullable Project project) {
        return GithubAuthenticationManager.getOrRequestTokenForAccount$intellij_vcs_github$default(this, account, project, null, null, 12, null);
    }

    @JvmOverloads
    @Nullable
    public final String getOrRequestTokenForAccount$intellij_vcs_github(@NotNull GithubAccount account) {
        return GithubAuthenticationManager.getOrRequestTokenForAccount$intellij_vcs_github$default(this, account, null, null, null, 14, null);
    }

    private final String requestNewToken(GithubAccount account, Project project, Component parentComponent) {
        GithubLoginDialog githubLoginDialog = new GithubLoginDialog(project, parentComponent, null, null, "Missing access token for " + account, 12, null);
        String string = account.getServer().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"account.server.toString()");
        GithubLoginDialog dialog2 = GithubLoginDialog.withToken$default(GithubLoginDialog.withCredentials$default(githubLoginDialog.withServer(string, false), account.getName(), null, 2, null), null, 1, null);
        DialogManager.show((DialogWrapper)dialog2);
        if (!dialog2.isOK()) {
            return null;
        }
        String token2 = dialog2.getToken();
        account.setName(dialog2.getLogin());
        this.accountManager.updateAccountToken(account, token2);
        return token2;
    }

    static /* bridge */ /* synthetic */ String requestNewToken$default(GithubAuthenticationManager githubAuthenticationManager, GithubAccount githubAccount, Project project, Component component, int n, Object object) {
        if ((n & 4) != 0) {
            component = null;
        }
        return githubAuthenticationManager.requestNewToken(githubAccount, project, component);
    }

    public final boolean hasTokenForAccount(@NotNull GithubAccount account) {
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        return this.getTokenForAccount$intellij_vcs_github(account) != null;
    }

    @JvmOverloads
    @Nullable
    public final GithubAccount requestNewAccount(@Nullable Project project, @Nullable Component parentComponent) {
        Function2<String, GithubServerPath, Boolean> isAccountUnique$ = new Function2<String, GithubServerPath, Boolean>(this){
            final /* synthetic */ GithubAuthenticationManager this$0;

            public final boolean invoke(@NotNull String name, @NotNull GithubServerPath server) {
                boolean bl;
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                    Iterable $receiver$iv = GithubAuthenticationManager.access$getAccountManager$p(this.this$0).getAccounts();
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $receiver$iv) {
                            GithubAccount it = (GithubAccount)element$iv;
                            if (!(Intrinsics.areEqual((Object)it.getName(), (Object)name) && Intrinsics.areEqual((Object)it.getServer(), (Object)server))) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                return bl;
            }
            {
                this.this$0 = githubAuthenticationManager;
                super(2);
            }
        };
        GithubLoginDialog dialog2 = new GithubLoginDialog(project, parentComponent, (Function2)new Function2<String, GithubServerPath, Boolean>(isAccountUnique$){
            final /* synthetic */ requestNewAccount.1 $isAccountUnique$1;

            public final boolean invoke(@NotNull String p1, @NotNull GithubServerPath p2) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                return this.$isAccountUnique$1.invoke(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return null;
            }

            public final String getName() {
                return "isAccountUnique";
            }

            public final String getSignature() {
                return "invoke(Ljava/lang/String;Lorg/jetbrains/plugins/github/api/GithubServerPath;)Z";
            }
            {
                this.$isAccountUnique$1 = var1_1;
                super(2);
            }
        }, null, null, 24, null);
        DialogManager.show((DialogWrapper)dialog2);
        if (!dialog2.isOK()) {
            return null;
        }
        GithubAccount account = GithubAccountManager.Companion.createAccount(dialog2.getLogin(), dialog2.getServer());
        GithubAccountManager githubAccountManager = this.accountManager;
        githubAccountManager.setAccounts(SetsKt.plus(githubAccountManager.getAccounts(), (Object)account));
        this.accountManager.updateAccountToken(account, dialog2.getToken());
        return account;
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ GithubAccount requestNewAccount$default(GithubAuthenticationManager githubAuthenticationManager, Project project, Component component, int n, Object object) {
        if ((n & 2) != 0) {
            component = null;
        }
        return githubAuthenticationManager.requestNewAccount(project, component);
    }

    @JvmOverloads
    @Nullable
    public final GithubAccount requestNewAccount(@Nullable Project project) {
        return GithubAuthenticationManager.requestNewAccount$default(this, project, null, 2, null);
    }

    @NotNull
    public final GithubAccount registerAccount(@NotNull String name, @NotNull String host, @NotNull String token2) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)token2, (String)"token");
        GithubServerPath githubServerPath = GithubServerPath.from(host);
        Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"GithubServerPath.from(host)");
        GithubAccount account = GithubAccountManager.Companion.createAccount(name, githubServerPath);
        GithubAccountManager githubAccountManager = this.accountManager;
        githubAccountManager.setAccounts(SetsKt.plus(githubAccountManager.getAccounts(), (Object)account));
        this.accountManager.updateAccountToken(account, token2);
        return account;
    }

    public final void clearAccounts() {
        for (GithubAccount account : this.accountManager.getAccounts()) {
            this.accountManager.updateAccountToken(account, null);
        }
        this.accountManager.setAccounts(SetsKt.emptySet());
    }

    @Nullable
    public final GithubAccount getDefaultAccount(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Project $receiver$iv = project;
        Object object = ServiceManager.getService((Project)$receiver$iv, GithubProjectDefaultAccountHolder.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
        return ((GithubProjectDefaultAccountHolder)object).getAccount();
    }

    public final void setDefaultAccount(@NotNull Project project, @Nullable GithubAccount account) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Project $receiver$iv = project;
        Object object = ServiceManager.getService((Project)$receiver$iv, GithubProjectDefaultAccountHolder.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
        ((GithubProjectDefaultAccountHolder)object).setAccount(account);
    }

    @JvmOverloads
    public final boolean ensureHasAccounts(@Nullable Project project, @Nullable Component parentComponent) {
        return this.hasAccounts() || this.requestNewAccount(project, parentComponent) != null;
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ boolean ensureHasAccounts$default(GithubAuthenticationManager githubAuthenticationManager, Project project, Component component, int n, Object object) {
        if ((n & 2) != 0) {
            component = null;
        }
        return githubAuthenticationManager.ensureHasAccounts(project, component);
    }

    @JvmOverloads
    public final boolean ensureHasAccounts(@Nullable Project project) {
        return GithubAuthenticationManager.ensureHasAccounts$default(this, project, null, 2, null);
    }

    public final boolean ensureHasAccountsWithTokens(@Nullable Project project, @Nullable Component parentComponent) {
        if (!this.ensureHasAccounts(project, parentComponent)) {
            return false;
        }
        boolean atLeastOneHasToken = false;
        for (GithubAccount account : this.getAccounts()) {
            atLeastOneHasToken = GithubAuthenticationManager.getOrRequestTokenForAccount$intellij_vcs_github$default(this, account, project, null, null, 12, null) != null;
        }
        return atLeastOneHasToken;
    }

    @Nullable
    public final GithubAccount getSingleOrDefaultAccount(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Object $receiver$iv = project;
        Object object = ServiceManager.getService((Project)$receiver$iv, GithubProjectDefaultAccountHolder.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
        GithubAccount githubAccount = ((GithubProjectDefaultAccountHolder)object).getAccount();
        if (githubAccount != null) {
            Object it = $receiver$iv = githubAccount;
            return it;
        }
        Set<GithubAccount> accounts = this.accountManager.getAccounts();
        if (accounts.size() == 1) {
            return (GithubAccount)CollectionsKt.first((Iterable)accounts);
        }
        return null;
    }

    public GithubAuthenticationManager(@NotNull GithubAccountManager accountManager) {
        Intrinsics.checkParameterIsNotNull((Object)accountManager, (String)"accountManager");
        this.accountManager = accountManager;
    }

    @Nullable
    public static final /* synthetic */ String access$requestNewToken(GithubAuthenticationManager $this, @NotNull GithubAccount account, @Nullable Project project, @Nullable Component parentComponent) {
        return $this.requestNewToken(account, project, parentComponent);
    }

    @NotNull
    public static final /* synthetic */ GithubAccountManager access$getAccountManager$p(GithubAuthenticationManager $this) {
        return $this.accountManager;
    }

    @JvmStatic
    @NotNull
    public static final GithubAuthenticationManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final GithubAuthenticationManager getInstance() {
            Object object = ServiceManager.getService(GithubAuthenticationManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
            return (GithubAuthenticationManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

