/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath;

import java.security.PrivilegedExceptionAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServiceProviderLoadingAction<P>
implements PrivilegedExceptionAction<P> {
    private final Class<P> spi;
    private final String providerName;
    private final ClassLoader loader;

    ServiceProviderLoadingAction(Class<P> spi, String providerName, ClassLoader loader) {
        if (spi == null || providerName == null || loader == null) {
            throw new IllegalArgumentException();
        }
        this.spi = spi;
        this.providerName = providerName;
        this.loader = loader;
    }

    @Override
    public P run() throws Exception {
        Class<?> loadedClass = this.loader.loadClass(this.providerName);
        Object serviceProvider = loadedClass.newInstance();
        if (!this.spi.isInstance(serviceProvider)) {
            throw new ClassCastException(this.spi.getName());
        }
        return (P)serviceProvider;
    }
}

