/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.dgc;

import gnu.java.rmi.dgc.LeaseRenewingTask;
import gnu.java.rmi.server.UnicastServer;
import gnu.java.rmi.server.UnicastServerRef;
import java.rmi.RemoteException;
import java.rmi.dgc.DGC;
import java.rmi.dgc.Lease;
import java.rmi.dgc.VMID;
import java.rmi.server.ObjID;
import java.rmi.server.RMISocketFactory;
import java.util.Collection;
import java.util.TimerTask;

public class DGCImpl
extends UnicastServerRef
implements DGC {
    private static final long serialVersionUID = 1L;
    static final long LEASE_VALUE = 600000L;

    public DGCImpl() throws RemoteException {
        super(new ObjID(2), 0, RMISocketFactory.getSocketFactory());
    }

    public Lease dirty(ObjID[] ids, long sequenceNum, Lease lease) throws RemoteException {
        long leaseValue = lease.getValue();
        if (leaseValue <= 0L) {
            leaseValue = 600000L;
        }
        new RefProtector(ids, leaseValue);
        lease = new Lease(lease.getVMID(), leaseValue);
        return lease;
    }

    public void clean(ObjID[] ids, long sequenceNum, VMID vmid, boolean strong) throws RemoteException {
    }

    class RefProtector
    extends TimerTask {
        Collection[] references;

        RefProtector(ObjID[] ids, long timeToLive) {
            this.references = new Collection[ids.length];
            int i = 0;
            while (i < ids.length) {
                this.references[i] = UnicastServer.getExported(ids[i]);
                ++i;
            }
            LeaseRenewingTask.timer.schedule((TimerTask)this, timeToLive);
        }

        public void run() {
            int i = 0;
            while (i < this.references.length) {
                this.references[i].clear();
                this.references[i] = null;
                ++i;
            }
        }
    }
}

