/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.gif;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class GIFFile {
    private static final byte[] nsBlock = new byte[]{78, 69, 84, 83, 67, 65, 80, 69, 50, 46, 48};
    private static final int EXTENSION = 33;
    private static final int LOCAL = 44;
    private static final int TERMINATOR = 59;
    private static final int EXTENSION_COMMENT = 254;
    private static final int EXTENSION_GCONTROL = 249;
    private static final int EXTENSION_APPLICATION = 255;
    private static final int UNDRAW_OVERWRITE = 1;
    private static final int UNDRAW_RESTORE_BACKGROUND = 2;
    private static final int UNDRAW_RESTORE_PREVIOUS = 3;
    private int x;
    private int y;
    private int width;
    private int height;
    private int globalWidth;
    private int globalHeight;
    private byte bgIndex;
    private int nColors;
    private byte[] globalPalette;
    private boolean hasGlobalColorMap;
    private byte[] localPalette;
    private boolean interlaced;
    private boolean hasTransparency;
    private int undraw;
    private int transparentIndex;
    private byte[] raster;
    private byte[] compressedData;
    private int duration;
    private int dataBlockIndex;
    private String comment;
    private int remainingBits = 0;
    private int currentBits = 0;
    private boolean isLooped = false;
    private int loops;
    private Vector animationFrames;

    public GIFFile(InputStream in) throws IOException, GIFException {
        if (!GIFFile.readSignature(in)) {
            throw new GIFException("Invalid GIF signature.");
        }
        byte[] data = new byte[7];
        if (in.read(data) != 7) {
            throw new IOException("Couldn't read global descriptor.");
        }
        this.globalWidth = (data[1] & 0xFF) << 8 | data[0] & 0xFF;
        this.globalHeight = (data[3] & 0xFF) << 8 | data[2] & 0xFF;
        byte flags = data[4];
        this.bgIndex = data[5];
        this.nColors = 1 << (flags & 7) + 1;
        boolean bl = this.hasGlobalColorMap = (flags & 0x80) != 0;
        if (this.hasGlobalColorMap) {
            this.globalPalette = new byte[this.nColors * 3];
            if (in.read(this.globalPalette) != this.nColors * 3) {
                throw new IOException("Couldn't read color map.");
            }
        }
        int c = in.read();
        while (c == 33) {
            this.readExtension(in);
            c = in.read();
        }
        if (c != 44) {
            throw new GIFException("Extension blocks not followed by a local descriptor (" + c + ")");
        }
        this.loadImage(in);
        c = in.read();
        if (c == 59) {
            return;
        }
        this.animationFrames = new Vector();
        try {
            while (c != 59) {
                this.animationFrames.add(new GIFFile(this, in, c));
                c = in.read();
            }
        }
        catch (IOException iOException) {
        }
        catch (GIFException gIFException) {}
    }

    private GIFFile(GIFFile parent, InputStream in, int c) throws IOException, GIFException {
        this.globalWidth = parent.globalWidth;
        this.globalHeight = parent.globalHeight;
        this.nColors = parent.nColors;
        this.globalPalette = parent.globalPalette;
        this.hasGlobalColorMap = parent.hasGlobalColorMap;
        this.interlaced = parent.interlaced;
        this.comment = parent.comment;
        this.isLooped = parent.isLooped;
        this.loops = parent.loops;
        while (c == 33) {
            this.readExtension(in);
            c = in.read();
        }
        if (c != 44) {
            throw new GIFException("Extension blocks not followed by a local descriptor (" + c + ")");
        }
        this.loadImage(in);
    }

    public static boolean readSignature(InputStream in) throws IOException {
        byte[] data = new byte[6];
        if (in.read(data) != 6) {
            throw new IOException("Couldn't read signature.");
        }
        if (data[0] != 71 || data[1] != 73 || data[2] != 70 || data[3] != 56) {
            return false;
        }
        return (data[4] == 57 || data[4] == 55) && (data[5] == 97 || data[5] == 98);
    }

    private void loadImage(InputStream in) throws IOException, GIFException {
        this.readLocal(in);
        try {
            this.decodeRaster(in);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new GIFException("Error decompressing image.");
        }
        if (this.interlaced) {
            this.deinterlace();
        }
        this.packPixels();
    }

    private void packPixels() {
        if (this.nColors != 2 && this.nColors != 4 && this.nColors != 16) {
            return;
        }
        int nbits = 1;
        int ppbyte = 8;
        if (this.nColors == 4) {
            nbits = 2;
            ppbyte = 4;
        } else if (this.nColors == 16) {
            nbits = 4;
            ppbyte = 2;
        }
        int rem = this.width & ppbyte - 1;
        int w = rem == 0 ? this.width / ppbyte : (this.width + ppbyte - rem) / ppbyte;
        byte[] nr = new byte[w * this.height];
        int j = 0;
        while (j < this.height) {
            int i = 0;
            while (i < this.width - ppbyte) {
                int k = 0;
                while (k < ppbyte) {
                    int n = j * w + i / ppbyte;
                    nr[n] = (byte)(nr[n] | (byte)(this.raster[this.width * j + i + k] << 8 - nbits * (1 + k)));
                    ++k;
                }
                i += ppbyte;
            }
            i = 0;
            while (i < rem) {
                int n = j * w + w - 1;
                nr[n] = (byte)(nr[n] | (byte)(this.raster[this.width * j + this.width - rem + i] << nbits * (rem - i)));
                ++i;
            }
            ++j;
        }
        this.raster = nr;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNColors() {
        return this.nColors;
    }

    public boolean hasTransparency() {
        return this.hasTransparency;
    }

    public int getTransparentIndex() {
        return this.transparentIndex;
    }

    public String getComment() {
        return this.comment;
    }

    public int getDuration() {
        return this.duration;
    }

    private void deinterlace() {
        byte[] nr = new byte[this.width * this.height];
        int n = 0;
        int i = 0;
        while (i < this.height + 7 >> 3) {
            System.arraycopy(this.raster, n, nr, this.width * i * 8, this.width);
            n += this.width;
            ++i;
        }
        i = 0;
        while (i < this.height + 3 >> 3) {
            System.arraycopy(this.raster, n, nr, this.width * (8 * i + 4), this.width);
            n += this.width;
            ++i;
        }
        i = 0;
        while (i < this.height >> 2) {
            System.arraycopy(this.raster, n, nr, this.width * (4 * i + 2), this.width);
            n += this.width;
            ++i;
        }
        i = 0;
        while (i < this.height >> 1) {
            System.arraycopy(this.raster, n, nr, this.width * (2 * i + 1), this.width);
            n += this.width;
            ++i;
        }
        this.raster = nr;
    }

    private void readLocal(InputStream in) throws IOException {
        byte[] data = new byte[9];
        if (in.read(data) != 9) {
            throw new IOException("Couldn't read local descriptor.");
        }
        this.x = (data[1] & 0xFF) << 8 | data[0] & 0xFF;
        this.y = (data[3] & 0xFF) << 8 | data[2] & 0xFF;
        this.width = (data[5] & 0xFF) << 8 | data[4] & 0xFF;
        this.height = (data[7] & 0xFF) << 8 | data[6] & 0xFF;
        byte flags = data[8];
        boolean bl = this.interlaced = (flags & 0x40) != 0;
        if ((flags & 0x80) != 0) {
            int nLocalColors = 1 << (flags & 7) + 1;
            if (!this.hasGlobalColorMap) {
                this.nColors = nLocalColors;
            }
            this.localPalette = new byte[nLocalColors * 3];
            if (in.read(this.localPalette) != nLocalColors * 3) {
                throw new IOException("Couldn't read color map.");
            }
        }
    }

    public byte[] getRawPalette() {
        return this.hasGlobalColorMap ? this.globalPalette : this.localPalette;
    }

    public GIFFile getImage(int index) {
        if (index == 0) {
            return this;
        }
        if (this.animationFrames == null) {
            throw new ArrayIndexOutOfBoundsException("Only one image in file");
        }
        return (GIFFile)this.animationFrames.elementAt(index - 1);
    }

    public byte[] getRawImage() {
        return this.raster;
    }

    public int nImages() {
        if (this.animationFrames != null) {
            return 1 + this.animationFrames.size();
        }
        return 1;
    }

    private void readExtension(InputStream in) throws IOException, GIFException {
        int functionCode = in.read();
        byte[] data = this.readData(in);
        switch (functionCode) {
            case 254: {
                this.comment = new String(data, "8859_1");
                break;
            }
            case 249: {
                this.undraw = (data[0] & 0x1C) >> 2;
                if (this.undraw < 1 && this.undraw > 3) {
                    this.undraw = 1;
                }
                this.hasTransparency = (data[0] & 1) == 1;
                this.transparentIndex = data[3] & 0xFF;
                this.duration = (data[2] & 0xFF) << 8 | data[1] & 0xFF;
                break;
            }
            case 255: {
                boolean isNS = true;
                int i = 0;
                while (i < nsBlock.length) {
                    if (nsBlock[i] != data[i]) {
                        isNS = false;
                    }
                    ++i;
                }
                if (!isNS) break;
                this.isLooped = true;
                this.loops = (data[12] & 0xFF) << 8 | data[13] & 0xFF;
                break;
            }
        }
    }

    private byte[] readData(InputStream in) throws IOException {
        Vector<byte[]> v = new Vector<byte[]>();
        int totalBytes = 0;
        int n = in.read();
        do {
            totalBytes += n;
            byte[] block = new byte[n];
            in.read(block);
            v.add(block);
        } while ((n = in.read()) > 0);
        n = 0;
        byte[] bigBuffer = new byte[totalBytes];
        int i = 0;
        while (i < v.size()) {
            byte[] block = (byte[])v.elementAt(i);
            System.arraycopy(block, 0, bigBuffer, n, block.length);
            n += block.length;
            ++i;
        }
        return bigBuffer;
    }

    private void decodeRaster(InputStream in) throws IOException {
        int initialCodeSize = in.read();
        this.compressedData = this.readData(in);
        this.dataBlockIndex = 0;
        int rasterIndex = 0;
        int clearCode = 1 << initialCodeSize;
        int endCode = clearCode + 1;
        this.raster = new byte[this.width * this.height];
        int codeSize = initialCodeSize + 1;
        int code = this.getBits(codeSize);
        int nextCode = endCode + 1;
        short[][] dictionary = new short[4096][4];
        int i = 0;
        while (i < this.nColors) {
            dictionary[i][0] = i;
            dictionary[i][1] = -1;
            dictionary[i][2] = i;
            dictionary[i][3] = 1;
            i = (short)(i + 1);
        }
        code = this.getBits(codeSize);
        this.raster[rasterIndex++] = (byte)dictionary[code][0];
        int old = code;
        code = this.getBits(codeSize);
        do {
            if (code == clearCode) {
                codeSize = initialCodeSize + 1;
                nextCode = endCode + 1;
                code = this.getBits(codeSize);
                this.raster[rasterIndex++] = (byte)dictionary[code][0];
                old = code;
                continue;
            }
            dictionary[nextCode][1] = (short)old;
            dictionary[nextCode][2] = dictionary[old][2];
            dictionary[nextCode][3] = (short)(dictionary[old][3] + 1);
            if (code < nextCode) {
                dictionary[nextCode][0] = dictionary[code][2];
                old = code;
            } else {
                dictionary[nextCode][0] = dictionary[old][2];
                old = nextCode;
            }
            int c = old;
            short depth = dictionary[c][3];
            int i2 = depth - 1;
            while (i2 >= 0) {
                this.raster[rasterIndex + i2] = (byte)dictionary[c][0];
                c = dictionary[c][1];
                --i2;
            }
            rasterIndex += depth;
            if (codeSize >= 12 || ++nextCode < 1 << codeSize) continue;
            ++codeSize;
        } while ((code = this.getBits(codeSize)) != endCode && this.dataBlockIndex < this.compressedData.length);
        this.compressedData = null;
    }

    private int getBits(int nbits) {
        while (nbits > this.remainingBits) {
            int c = (this.compressedData[this.dataBlockIndex++] & 0xFF) << this.remainingBits;
            this.currentBits |= c;
            this.remainingBits += 8;
        }
        int rval = this.currentBits & (1 << nbits) - 1;
        this.currentBits >>= nbits;
        this.remainingBits -= nbits;
        return rval;
    }

    public static class GIFException
    extends Exception {
        public GIFException(String message) {
            super(message);
        }
    }
}

