/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.print.ipp;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.javax.print.ipp.IppException;
import gnu.javax.print.ipp.IppResponse;
import gnu.javax.print.ipp.attribute.CharsetSyntax;
import gnu.javax.print.ipp.attribute.NaturalLanguageSyntax;
import gnu.javax.print.ipp.attribute.RequestedAttributes;
import gnu.javax.print.ipp.attribute.job.AttributesCharset;
import gnu.javax.print.ipp.attribute.job.AttributesNaturalLanguage;
import gnu.javax.print.ipp.attribute.job.JobId;
import gnu.javax.print.ipp.attribute.job.JobUri;
import gnu.javax.print.ipp.attribute.printer.DocumentFormat;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.DateTimeSyntax;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.IntegerSyntax;
import javax.print.attribute.ResolutionSyntax;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.print.attribute.TextSyntax;
import javax.print.attribute.URISyntax;
import javax.print.attribute.standard.Compression;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.Finishings;
import javax.print.attribute.standard.JobHoldUntil;
import javax.print.attribute.standard.JobImpressions;
import javax.print.attribute.standard.JobKOctets;
import javax.print.attribute.standard.JobMediaSheets;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobOriginatingUserName;
import javax.print.attribute.standard.JobPriority;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MultipleDocumentHandling;
import javax.print.attribute.standard.NumberUp;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.PrinterURI;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;

public class IppRequest {
    private static final int timeout = 1000;
    static final Logger logger = SystemLogger.SYSTEM;
    private static int requestIdCounter = 1;
    private static final short VERSION = 257;
    private boolean alreadySent = false;
    private short operation_id;
    private final int request_id = this.incrementRequestIdCounter();
    private AttributeSet operationAttributes;
    private AttributeSet printerAttributes;
    private AttributeSet jobAttributes;
    private Object data;
    private URI requestUri;
    private HttpURLConnection connection;

    public IppRequest(URI uri, String user, String password) {
        this.requestUri = uri;
        try {
            URL url = new URL("http", user == null ? uri.getHost() : String.valueOf(user) + ":" + password + "@" + uri.getHost(), uri.getPort(), uri.getPath());
            this.connection = (HttpURLConnection)url.openConnection();
            this.connection.setRequestMethod("POST");
            this.connection.setDoOutput(true);
            this.connection.setRequestProperty("Content-type", "application/ipp");
            this.connection.setRequestProperty("Accept", "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2");
        }
        catch (IOException e) {
            logger.log((Level)Component.IPP, "Unexpected IOException", e);
        }
        logger.log(Component.IPP, "[IppConnection] Host: " + uri.getHost() + " Port: " + uri.getPort() + " Path: " + uri.getPath());
    }

    private synchronized int incrementRequestIdCounter() {
        return requestIdCounter++;
    }

    public int getRequestID() {
        return this.request_id;
    }

    public void setData(InputStream stream) {
        this.data = stream;
    }

    public void setData(byte[] bytes) {
        this.data = bytes;
    }

    public void setOperationID(short id) {
        this.operation_id = id;
    }

    public void setOperationAttributeDefaults() {
        if (this.operationAttributes == null) {
            this.operationAttributes = new HashAttributeSet();
        }
        this.operationAttributes.add(AttributesCharset.UTF8);
        this.operationAttributes.add(AttributesNaturalLanguage.EN);
    }

    public void addJobAttribute(Attribute attribute) {
        if (this.jobAttributes == null) {
            this.jobAttributes = new HashAttributeSet();
        }
        this.jobAttributes.add(attribute);
    }

    public void addPrinterAttributes(Attribute attribute) {
        if (this.printerAttributes == null) {
            this.printerAttributes = new HashAttributeSet();
        }
        this.printerAttributes.add(attribute);
    }

    public void addOperationAttribute(Attribute attribute) {
        if (this.operationAttributes == null) {
            this.operationAttributes = new HashAttributeSet();
        }
        this.operationAttributes.add(attribute);
    }

    public void addAndFilterJobOperationAttributes(AttributeSet set) {
        if (this.operationAttributes == null) {
            this.operationAttributes = new HashAttributeSet();
        }
        Attribute[] tmp = set.toArray();
        int i = 0;
        while (i < tmp.length) {
            if (tmp[i].getCategory().equals(JobName.class) || tmp[i].getCategory().equals(Fidelity.class) || tmp[i].getCategory().equals(JobImpressions.class) || tmp[i].getCategory().equals(JobKOctets.class) || tmp[i].getCategory().equals(JobMediaSheets.class) || tmp[i].getCategory().equals(Compression.class) || tmp[i].getCategory().equals(DocumentName.class) || tmp[i].getCategory().equals(RequestingUserName.class)) {
                this.operationAttributes.add(tmp[i]);
            }
            ++i;
        }
    }

    public void addAndFilterJobTemplateAttributes(AttributeSet set) {
        if (this.jobAttributes == null) {
            this.jobAttributes = new HashAttributeSet();
        }
        Attribute[] tmp = set.toArray();
        int i = 0;
        while (i < tmp.length) {
            if (tmp[i].getCategory().equals(JobPriority.class) || tmp[i].getCategory().equals(JobHoldUntil.class) || tmp[i].getCategory().equals(JobSheets.class) || tmp[i].getCategory().equals(MultipleDocumentHandling.class) || tmp[i].getCategory().equals(Copies.class) || tmp[i].getCategory().equals(Finishings.class) || tmp[i].getCategory().equals(PageRanges.class) || tmp[i].getCategory().equals(NumberUp.class) || tmp[i].getCategory().equals(OrientationRequested.class) || tmp[i].getCategory().equals(Media.class) || tmp[i].getCategory().equals(PrinterResolution.class) || tmp[i].getCategory().equals(PrintQuality.class) || tmp[i].getCategory().equals(SheetCollate.class) || tmp[i].getCategory().equals(Sides.class)) {
                this.jobAttributes.add(tmp[i]);
            }
            ++i;
        }
    }

    public IppResponse send() throws IppException, IOException {
        if (this.alreadySent) {
            throw new IllegalStateException("Request is already sent");
        }
        this.alreadySent = true;
        OutputStream stream = this.connection.getOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        out.writeShort(257);
        out.writeShort(this.operation_id);
        out.writeInt(this.request_id);
        logger.log(Component.IPP, "OperationID: " + Integer.toHexString(this.operation_id) + " RequestID: " + this.request_id);
        logger.log(Component.IPP, "Operation Attributes");
        RequestWriter writer = new RequestWriter(out);
        writer.writeOperationAttributes(this.operationAttributes);
        if (this.jobAttributes != null) {
            logger.log(Component.IPP, "Job Attributes");
            out.write(2);
            writer.writeAttributes(this.jobAttributes);
        }
        if (this.printerAttributes != null) {
            logger.log(Component.IPP, "Printer Attributes");
            out.write(4);
            writer.writeAttributes(this.printerAttributes);
        }
        out.write(3);
        if (this.data instanceof InputStream) {
            byte[] readbuf = new byte[2048];
            int len = 0;
            while ((len = ((InputStream)this.data).read(readbuf)) > 0) {
                out.write(readbuf, 0, len);
            }
        } else if (this.data != null) {
            out.write((byte[])this.data);
        }
        out.flush();
        stream.flush();
        this.connection.setConnectTimeout(1000);
        int responseCode = this.connection.getResponseCode();
        if (responseCode == 200) {
            IppResponse response = new IppResponse(this.requestUri, this.operation_id);
            response.setResponseData(this.connection.getInputStream());
            return response;
        }
        logger.log(Component.IPP, "HTTP-Statuscode: " + responseCode);
        throw new IppException("Request failed got HTTP status code " + responseCode);
    }

    class RequestWriter {
        private DataOutputStream out;

        RequestWriter(DataOutputStream stream) {
            this.out = stream;
        }

        private void write(IntegerSyntax attribute) throws IOException {
            String name = ((Attribute)((Object)attribute)).getName();
            this.out.writeByte(33);
            this.out.writeShort(name.length());
            this.out.write(name.getBytes());
            this.out.writeShort(4);
            this.out.writeInt(attribute.getValue());
        }

        private void write(EnumSyntax attribute) throws IOException {
            String name = ((Attribute)((Object)attribute)).getName();
            if (attribute instanceof Finishings || attribute instanceof OrientationRequested || attribute instanceof PrintQuality) {
                this.out.writeByte(35);
                this.out.writeShort(name.length());
                this.out.write(name.getBytes());
                this.out.writeShort(4);
                this.out.writeInt(attribute.getValue());
            } else if (attribute instanceof Fidelity) {
                this.out.writeByte(34);
                this.out.writeShort(name.length());
                this.out.write(name.getBytes());
                this.out.writeShort(1);
                this.out.writeByte(attribute.getValue() == 0 ? 0 : 1);
            } else {
                String keyword = attribute.toString();
                this.out.writeByte(68);
                this.out.writeShort(name.length());
                this.out.write(name.getBytes());
                this.out.writeShort(keyword.length());
                this.out.write(keyword.getBytes());
            }
        }

        private void write(SetOfIntegerSyntax attribute) throws IOException {
            String name = ((Attribute)((Object)attribute)).getName();
            int[][] ranges = attribute.getMembers();
            int i = 0;
            while (i < ranges.length) {
                this.out.writeByte(51);
                if (i == 0) {
                    this.out.writeShort(name.length());
                    this.out.write(name.getBytes());
                } else {
                    this.out.writeShort(0);
                }
                this.out.writeShort(8);
                this.out.writeInt(ranges[i][0]);
                this.out.writeInt(ranges[i][1]);
                ++i;
            }
        }

        private void write(ResolutionSyntax attribute) throws IOException {
            String name = ((Attribute)((Object)attribute)).getName();
            this.out.writeByte(50);
            this.out.writeShort(name.length());
            this.out.write(name.getBytes());
            this.out.writeShort(9);
            this.out.writeInt(attribute.getCrossFeedResolution(100));
            this.out.writeInt(attribute.getFeedResolution(100));
            this.out.writeByte(100);
        }

        private void write(DateTimeSyntax attribute) throws IOException {
            String name = ((Attribute)((Object)attribute)).getName();
            this.out.writeByte(49);
            this.out.writeShort(name.length());
            this.out.write(name.getBytes());
            this.out.writeShort(11);
            Date date = attribute.getValue();
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            this.out.writeShort(cal.get(1));
            this.out.writeByte(cal.get(2));
            this.out.writeByte(cal.get(5));
            this.out.writeByte(cal.get(11));
            this.out.writeByte(cal.get(12));
            int second = cal.get(13);
            this.out.writeByte(second == 0 ? 60 : second);
            this.out.writeByte(cal.get(14) / 100);
            int offsetInMillis = cal.get(15);
            int directionFromUTC = 43;
            if (offsetInMillis < 0) {
                directionFromUTC = 45;
                offsetInMillis *= -1;
            }
            this.out.writeByte(directionFromUTC);
            this.out.writeByte(offsetInMillis / 3600000);
            this.out.writeByte(offsetInMillis % 3600000 / 60000);
        }

        private void write(TextSyntax attribute) throws IOException {
            String name = ((Attribute)((Object)attribute)).getName();
            if (attribute instanceof RequestingUserName || attribute instanceof JobName || attribute instanceof DocumentName || attribute instanceof JobOriginatingUserName) {
                this.out.writeByte(66);
            } else if (attribute instanceof DocumentFormat) {
                this.out.writeByte(73);
            } else {
                this.out.writeByte(65);
            }
            this.out.writeShort(name.length());
            this.out.write(name.getBytes());
            this.out.writeShort(attribute.getValue().length());
            this.out.write(attribute.getValue().getBytes());
        }

        private void write(URISyntax attribute) throws IOException {
            String name = ((Attribute)((Object)attribute)).getName();
            String uriAscii = attribute.getURI().toASCIIString();
            this.out.writeByte(69);
            this.out.writeShort(name.length());
            this.out.write(name.getBytes());
            this.out.writeShort(uriAscii.length());
            this.out.write(uriAscii.getBytes());
        }

        private void write(CharsetSyntax attribute) throws IOException {
            String name = ((Attribute)((Object)attribute)).getName();
            this.out.writeByte(71);
            this.out.writeShort(name.length());
            this.out.write(name.getBytes());
            this.out.writeShort(attribute.getValue().length());
            this.out.write(attribute.getValue().getBytes());
        }

        private void write(NaturalLanguageSyntax attribute) throws IOException {
            String name = ((Attribute)((Object)attribute)).getName();
            this.out.writeByte(72);
            this.out.writeShort(name.length());
            this.out.write(name.getBytes());
            this.out.writeShort(attribute.getValue().length());
            this.out.write(attribute.getValue().getBytes());
        }

        private void write(RequestedAttributes attribute) throws IOException {
            String[] values = attribute.getValues();
            String name = attribute.getName();
            this.out.writeByte(68);
            this.out.writeShort(name.length());
            this.out.write(name.getBytes());
            this.out.writeShort(values[0].length());
            this.out.write(values[0].getBytes());
            int i = 1;
            while (i < values.length) {
                this.out.writeByte(68);
                this.out.writeShort(0);
                this.out.writeShort(values[i].length());
                this.out.write(values[i].getBytes());
                ++i;
            }
        }

        public void writeOperationAttributes(AttributeSet attributes) throws IOException, IppException {
            this.out.write(1);
            Attribute att = attributes.get(AttributesCharset.class);
            this.write((CharsetSyntax)((Object)att));
            logger.log(Component.IPP, "Attribute: Name: <" + att.getCategory().getName() + "> Value: <" + att.toString() + ">");
            attributes.remove(AttributesCharset.class);
            att = attributes.get(AttributesNaturalLanguage.class);
            this.write((NaturalLanguageSyntax)((Object)att));
            attributes.remove(AttributesNaturalLanguage.class);
            logger.log(Component.IPP, "Attribute: Name: <" + att.getCategory().getName() + "> Value: <" + att.toString() + ">");
            PrinterURI printerUri = (PrinterURI)attributes.get(PrinterURI.class);
            JobUri jobUri = (JobUri)attributes.get(JobUri.class);
            JobId jobId = (JobId)attributes.get(JobId.class);
            RequestedAttributes reqAttrs = (RequestedAttributes)attributes.get(RequestedAttributes.class);
            if (printerUri != null && jobId == null && jobUri == null) {
                this.write(printerUri);
                attributes.remove(PrinterURI.class);
                logger.log(Component.IPP, "Attribute: Name: <" + printerUri.getCategory().getName() + "> Value: <" + printerUri.toString() + ">");
            } else if (jobUri != null && jobId == null && printerUri == null) {
                this.write(jobUri);
                attributes.remove(JobUri.class);
                logger.log(Component.IPP, "Attribute: Name: <" + jobUri.getCategory().getName() + "> Value: <" + jobUri.toString() + ">");
            } else if (printerUri != null && jobId != null && jobUri == null) {
                this.write(printerUri);
                this.write(jobId);
                attributes.remove(PrinterURI.class);
                attributes.remove(JobId.class);
                logger.log(Component.IPP, "Attribute: Name: <" + printerUri.getCategory().getName() + "> Value: <" + printerUri.toString() + ">");
                logger.log(Component.IPP, "Attribute: Name: <" + jobId.getCategory().getName() + "> Value: <" + jobId.toString() + ">");
            } else if (jobUri != null && jobId != null) {
                this.write(jobUri);
                attributes.remove(JobUri.class);
                attributes.remove(JobId.class);
                logger.log(Component.IPP, "Attribute: Name: <" + jobUri.getCategory().getName() + "> Value: <" + jobUri.toString() + ">");
            } else if (reqAttrs != null) {
                this.write(reqAttrs);
                attributes.remove(RequestedAttributes.class);
                logger.log(Component.IPP, "RequestedAttributes: <" + reqAttrs + ">");
            } else {
                throw new IppException("Unknown target operation attribute combination.");
            }
            this.writeAttributes(attributes);
        }

        public void writeAttributes(AttributeSet attributes) throws IOException, IppException {
            Attribute[] attributeArray = attributes.toArray();
            int i = 0;
            while (i < attributeArray.length) {
                logger.log(Component.IPP, "Attribute: Name: <" + attributeArray[i].getCategory().getName() + "> Value: <" + attributeArray[i].toString() + ">");
                if (attributeArray[i] instanceof IntegerSyntax) {
                    this.write((IntegerSyntax)((Object)attributeArray[i]));
                } else if (attributeArray[i] instanceof TextSyntax) {
                    this.write((TextSyntax)((Object)attributeArray[i]));
                } else if (attributeArray[i] instanceof DateTimeSyntax) {
                    this.write((DateTimeSyntax)((Object)attributeArray[i]));
                } else if (attributeArray[i] instanceof ResolutionSyntax) {
                    this.write((ResolutionSyntax)((Object)attributeArray[i]));
                } else if (attributeArray[i] instanceof SetOfIntegerSyntax) {
                    this.write((SetOfIntegerSyntax)((Object)attributeArray[i]));
                } else if (attributeArray[i] instanceof EnumSyntax) {
                    this.write((EnumSyntax)((Object)attributeArray[i]));
                } else if (attributeArray[i] instanceof URISyntax) {
                    this.write((URISyntax)((Object)attributeArray[i]));
                } else if (attributeArray[i] instanceof CharsetSyntax) {
                    this.write((CharsetSyntax)((Object)attributeArray[i]));
                } else if (attributeArray[i] instanceof NaturalLanguageSyntax) {
                    this.write((NaturalLanguageSyntax)((Object)attributeArray[i]));
                } else if (attributeArray[i] instanceof RequestedAttributes) {
                    this.write((RequestedAttributes)attributeArray[i]);
                } else {
                    throw new IppException("Unknown syntax type");
                }
                ++i;
            }
        }
    }
}

