/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Boolean
implements Serializable,
Comparable<Boolean> {
    private static final long serialVersionUID = -3665804199014368530L;
    public static final Boolean TRUE = new Boolean(true);
    public static final Boolean FALSE = new Boolean(false);
    public static final Class<Boolean> TYPE = VMClassLoader.getPrimitiveClass('Z');
    private final boolean value;

    public Boolean(boolean value) {
        this.value = value;
    }

    public Boolean(String s) {
        this.value = "true".equalsIgnoreCase(s);
    }

    public boolean booleanValue() {
        return this.value;
    }

    public static Boolean valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static Boolean valueOf(String s) {
        return "true".equalsIgnoreCase(s) ? TRUE : FALSE;
    }

    public static String toString(boolean b) {
        return b ? "true" : "false";
    }

    public String toString() {
        return this.value ? "true" : "false";
    }

    public int hashCode() {
        return this.value ? 1231 : 1237;
    }

    public boolean equals(Object obj) {
        return obj instanceof Boolean && this.value == ((Boolean)obj).value;
    }

    public static boolean getBoolean(String name) {
        if (name == null || "".equals(name)) {
            return false;
        }
        return "true".equalsIgnoreCase(System.getProperty(name));
    }

    @Override
    public int compareTo(Boolean other) {
        return this.value == other.value ? 0 : (this.value ? 1 : -1);
    }

    public static int compare(boolean x, boolean y) {
        return Boolean.valueOf(x).compareTo(y);
    }

    public static boolean parseBoolean(String b) {
        return "true".equalsIgnoreCase(b);
    }
}

