/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.management.IntrospectionException;
import javax.management.MBeanFeatureInfo;

public class MBeanAttributeInfo
extends MBeanFeatureInfo
implements Cloneable {
    private static final long serialVersionUID = 8644704819898565848L;
    private String attributeType;
    private boolean isWrite;
    private boolean isRead;
    private boolean is;

    public MBeanAttributeInfo(String name, String desc, Method getter, Method setter) throws IntrospectionException {
        super(name, desc);
        if (getter == null && setter == null) {
            throw new IntrospectionException("Both the getter and setter methods can not be null.");
        }
        if (getter == null) {
            Type t = setter.getGenericParameterTypes()[0];
            this.attributeType = t instanceof Class ? ((Class)t).getName() : t.toString();
            this.isRead = false;
            this.is = false;
        } else {
            Type t = getter.getGenericReturnType();
            this.attributeType = t instanceof Class ? ((Class)t).getName() : t.toString();
            this.isRead = true;
            this.is = getter.getName().startsWith("is");
        }
        if (setter != null) {
            this.isWrite = true;
        }
    }

    public MBeanAttributeInfo(String name, String type, String desc, boolean isReadable, boolean isWritable, boolean isIs) {
        super(name, desc);
        if (!isReadable && !isWritable) {
            throw new IllegalArgumentException("The attribute can not be both unreadable and unwritable.");
        }
        this.attributeType = type;
        this.isRead = isReadable;
        this.isWrite = isWritable;
        this.is = isIs;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("clone() called on non-cloneable object.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MBeanAttributeInfo)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MBeanAttributeInfo o = (MBeanAttributeInfo)obj;
        return this.attributeType.equals(o.getType()) && this.isRead == o.isReadable() && this.isWrite == o.isWritable() && this.is == o.isIs();
    }

    public String getType() {
        return this.attributeType;
    }

    public int hashCode() {
        return super.hashCode() + this.attributeType.hashCode() + Boolean.valueOf(this.isRead).hashCode() + 2 * Boolean.valueOf(this.isWrite).hashCode() + 4 * Boolean.valueOf(this.is).hashCode();
    }

    public boolean isIs() {
        return this.is;
    }

    public boolean isReadable() {
        return this.isRead;
    }

    public boolean isWritable() {
        return this.isWrite;
    }

    public String toString() {
        if (this.string == null) {
            super.toString();
            this.string = String.valueOf(this.string.substring(0, this.string.length() - 1)) + ",type=" + this.attributeType + ",isReadable=" + (this.isRead ? "yes" : "no") + ",isWritable=" + (this.isWrite ? "yes" : "no") + ",isIs=" + (this.is ? "yes" : "no") + "]";
        }
        return this.string;
    }
}

