/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.ldap.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControlFactory {
    protected ControlFactory() {
    }

    public abstract Control getControlInstance(Control var1) throws NamingException;

    public static Control getControlInstance(Control control, Context ctx, Hashtable<?, ?> env) throws NamingException {
        String path = (String)env.get("java.naming.factory.control");
        String path2 = null;
        if (ctx != null) {
            path2 = (String)ctx.getEnvironment().get("java.naming.factory.control");
        }
        if (path == null) {
            path = path2;
        } else if (path2 != null) {
            path = String.valueOf(path) + ":" + path2;
        }
        StringTokenizer tokens = new StringTokenizer(path, ":");
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken();
            try {
                Class<?> k = Class.forName(name);
                ControlFactory cf = (ControlFactory)k.newInstance();
                Control ctrl = cf.getControlInstance(control);
                if (ctrl == null) continue;
                return ctrl;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ClassCastException classCastException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return control;
    }
}

