/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultButtonModel
implements ButtonModel,
Serializable {
    private static final long serialVersionUID = -5342609566534980231L;
    public static final int ARMED = 1;
    public static final int ENABLED = 8;
    public static final int PRESSED = 4;
    public static final int ROLLOVER = 16;
    public static final int SELECTED = 2;
    protected int stateMask = 8;
    protected EventListenerList listenerList = new EventListenerList();
    protected ChangeEvent changeEvent = new ChangeEvent(this);
    protected ButtonGroup group;
    protected int mnemonic = 0;
    protected String actionCommand;

    @Override
    public Object[] getSelectedObjects() {
        return null;
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.listenerList.add(ItemListener.class, l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.listenerList.remove(ItemListener.class, l);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(ItemListener.class);
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireItemStateChanged(ItemEvent e) {
        ItemListener[] ll = this.getItemListeners();
        int i = 0;
        while (i < ll.length) {
            ll[i].itemStateChanged(e);
            ++i;
        }
    }

    protected void fireActionPerformed(ActionEvent e) {
        ActionListener[] ll = this.getActionListeners();
        int i = 0;
        while (i < ll.length) {
            ll[i].actionPerformed(e);
            ++i;
        }
    }

    protected void fireStateChanged() {
        ChangeListener[] ll = this.getChangeListeners();
        int i = 0;
        while (i < ll.length) {
            ll[i].stateChanged(this.changeEvent);
            ++i;
        }
    }

    @Override
    public boolean isArmed() {
        return (this.stateMask & 1) == 1;
    }

    @Override
    public void setArmed(boolean a) {
        if (a && this.isArmed() || !a && !this.isArmed()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.stateMask = a ? (this.stateMask |= 1) : (this.stateMask &= 0xFFFFFFFE);
        this.fireStateChanged();
    }

    @Override
    public boolean isEnabled() {
        return (this.stateMask & 8) == 8;
    }

    @Override
    public void setEnabled(boolean e) {
        if (e && this.isEnabled() || !e && !this.isEnabled()) {
            return;
        }
        this.stateMask = e ? (this.stateMask |= 8) : this.stateMask & 0xFFFFFFF7 & 0xFFFFFFFE & 0xFFFFFFFB;
        this.fireStateChanged();
    }

    @Override
    public void setPressed(boolean p) {
        if (p && this.isPressed() || !p && !this.isPressed()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.stateMask = p ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
        if (!p && this.isArmed()) {
            this.fireActionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
        this.fireStateChanged();
    }

    @Override
    public boolean isPressed() {
        return (this.stateMask & 4) == 4;
    }

    @Override
    public void setRollover(boolean r) {
        if (r == this.isRollover()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.stateMask = r ? (this.stateMask |= 0x10) : (this.stateMask &= 0xFFFFFFEF);
        this.fireStateChanged();
    }

    @Override
    public void setSelected(boolean s) {
        if (s && this.isSelected() || !s && !this.isSelected()) {
            return;
        }
        this.stateMask = s ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
        this.fireStateChanged();
        if (s) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this, 1));
            if (this.group != null) {
                this.group.setSelected(this, true);
            }
        } else {
            this.fireItemStateChanged(new ItemEvent(this, 701, this, 2));
            if (this.group != null) {
                this.group.setSelected(this, false);
            }
        }
    }

    @Override
    public boolean isSelected() {
        return (this.stateMask & 2) == 2;
    }

    @Override
    public boolean isRollover() {
        return (this.stateMask & 0x10) == 16;
    }

    @Override
    public int getMnemonic() {
        return this.mnemonic;
    }

    @Override
    public void setMnemonic(int key) {
        if (this.mnemonic != key) {
            this.mnemonic = key;
            this.fireStateChanged();
        }
    }

    @Override
    public void setActionCommand(String s) {
        if (this.actionCommand != s) {
            this.actionCommand = s;
            this.fireStateChanged();
        }
    }

    @Override
    public String getActionCommand() {
        return this.actionCommand;
    }

    @Override
    public void setGroup(ButtonGroup g) {
        this.group = g;
    }

    public ButtonGroup getGroup() {
        return this.group;
    }
}

