/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class DefaultDesktopManager
implements DesktopManager,
Serializable {
    private static final long serialVersionUID = 4657624909838017887L;
    static final String WAS_ICON_ONCE_PROPERTY = "wasIconOnce";
    private int currentDragMode = 0;
    private transient Rectangle dragCache = new Rectangle();
    private transient Container pane;
    private transient Rectangle[] iconRects;

    public void openFrame(JInternalFrame frame) {
        Container c = frame.getParent();
        if (c == null) {
            c = frame.getDesktopIcon().getParent();
        }
        if (c == null) {
            return;
        }
        c.remove(frame.getDesktopIcon());
        c.add(frame);
        frame.setVisible(true);
    }

    public void closeFrame(JInternalFrame frame) {
        Container c = frame.getParent();
        if (c != null) {
            if (frame.isIcon()) {
                c.remove(frame.getDesktopIcon());
            } else {
                c.remove(frame);
            }
            c.repaint();
        }
    }

    public void maximizeFrame(JInternalFrame frame) {
        if (frame.isIcon()) {
            return;
        }
        frame.setNormalBounds(frame.getBounds());
        Container p = frame.getParent();
        if (p != null) {
            Rectangle pBounds = p.getBounds();
            Insets insets = p.getInsets();
            pBounds.width -= insets.left + insets.right;
            pBounds.height -= insets.top + insets.bottom;
            this.setBoundsForFrame(frame, 0, 0, pBounds.width, pBounds.height);
        }
        if (p instanceof JDesktopPane) {
            ((JDesktopPane)p).setSelectedFrame(frame);
        } else {
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    public void minimizeFrame(JInternalFrame frame) {
        Rectangle normalBounds = frame.getNormalBounds();
        JDesktopPane p = frame.getDesktopPane();
        if (p != null) {
            p.setSelectedFrame(frame);
        } else {
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        this.setBoundsForFrame(frame, normalBounds.x, normalBounds.y, normalBounds.width, normalBounds.height);
    }

    public void iconifyFrame(JInternalFrame frame) {
        JDesktopPane p = frame.getDesktopPane();
        JInternalFrame.JDesktopIcon icon = frame.getDesktopIcon();
        if (p != null && p.getSelectedFrame() == frame) {
            p.setSelectedFrame(null);
        } else {
            try {
                frame.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        Container c = frame.getParent();
        if (!this.wasIcon(frame)) {
            Rectangle r = this.getBoundsForIconOf(frame);
            icon.setBounds(r);
            this.setWasIcon(frame, Boolean.TRUE);
        }
        if (c != null) {
            if (icon != null) {
                c.add(icon);
                icon.setVisible(true);
            }
            Rectangle b = frame.getBounds();
            c.remove(frame);
            c.repaint(b.x, b.y, b.width, b.height);
        }
    }

    public void deiconifyFrame(JInternalFrame frame) {
        JInternalFrame.JDesktopIcon icon = frame.getDesktopIcon();
        Container c = icon.getParent();
        this.removeIconFor(frame);
        c.add(frame);
        frame.setVisible(true);
        if (!frame.isSelected()) {
            JDesktopPane p = frame.getDesktopPane();
            if (p != null) {
                p.setSelectedFrame(frame);
            } else {
                try {
                    frame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }
        c.invalidate();
    }

    public void activateFrame(JInternalFrame frame) {
        JDesktopPane p = frame.getDesktopPane();
        JInternalFrame active = null;
        if (p != null) {
            active = p.getSelectedFrame();
        }
        if (active == null) {
            if (p != null) {
                p.setSelectedFrame(frame);
            }
        } else if (active != frame) {
            if (active.isSelected()) {
                try {
                    active.setSelected(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
            if (p != null) {
                p.setSelectedFrame(frame);
            }
        }
        frame.toFront();
    }

    public void deactivateFrame(JInternalFrame frame) {
        JDesktopPane p = frame.getDesktopPane();
        if (p != null) {
            if (p.getSelectedFrame() == frame) {
                p.setSelectedFrame(null);
            }
        } else {
            try {
                frame.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    public void beginDraggingFrame(JComponent component) {
        this.pane = component instanceof JInternalFrame.JDesktopIcon ? ((JInternalFrame.JDesktopIcon)component).getInternalFrame().getDesktopPane() : ((JInternalFrame)component).getDesktopPane();
        if (this.pane == null) {
            return;
        }
        this.dragCache = component.getBounds();
        this.currentDragMode = !(this.pane instanceof JDesktopPane) ? 0 : ((JDesktopPane)this.pane).getDragMode();
    }

    public void dragFrame(JComponent component, int newX, int newY) {
        if (this.currentDragMode != 1) {
            Rectangle b = component.getBounds();
            if (component instanceof JInternalFrame.JDesktopIcon) {
                component.setBounds(newX, newY, b.width, b.height);
            } else {
                this.setBoundsForFrame((JInternalFrame)component, newX, newY, b.width, b.height);
            }
        }
    }

    public void endDraggingFrame(JComponent component) {
        if (this.currentDragMode == 1) {
            this.setBoundsForFrame((JInternalFrame)component, this.dragCache.x, this.dragCache.y, this.dragCache.width, this.dragCache.height);
            this.pane = null;
            this.dragCache = null;
            component.repaint();
        }
    }

    public void beginResizingFrame(JComponent component, int direction) {
        this.pane = ((JInternalFrame)component).getDesktopPane();
        if (this.pane == null) {
            return;
        }
        this.dragCache = component.getBounds();
        this.currentDragMode = !(this.pane instanceof JDesktopPane) ? 0 : ((JDesktopPane)this.pane).getDragMode();
    }

    public void resizeFrame(JComponent component, int newX, int newY, int newWidth, int newHeight) {
        this.dragCache.setBounds(newX, newY, newWidth, newHeight);
        if (this.currentDragMode != 1) {
            this.setBoundsForFrame(component, this.dragCache.x, this.dragCache.y, this.dragCache.width, this.dragCache.height);
        }
    }

    public void endResizingFrame(JComponent component) {
        if (this.currentDragMode == 1) {
            this.setBoundsForFrame((JInternalFrame)component, this.dragCache.x, this.dragCache.y, this.dragCache.width, this.dragCache.height);
            this.pane = null;
            this.dragCache = null;
            component.repaint();
        }
    }

    public void setBoundsForFrame(JComponent component, int newX, int newY, int newWidth, int newHeight) {
        component.setBounds(newX, newY, newWidth, newHeight);
    }

    protected void removeIconFor(JInternalFrame frame) {
        JInternalFrame.JDesktopIcon icon = frame.getDesktopIcon();
        Container c = icon.getParent();
        if (c != null && icon != null) {
            Rectangle b = icon.getBounds();
            c.remove(icon);
            c.repaint(b.x, b.y, b.width, b.height);
        }
    }

    protected Rectangle getBoundsForIconOf(JInternalFrame frame) {
        JDesktopPane desktopPane = frame.getDesktopPane();
        if (desktopPane == null) {
            return frame.getDesktopIcon().getBounds();
        }
        Rectangle paneBounds = desktopPane.getBounds();
        Insets insets = desktopPane.getInsets();
        Dimension pref = frame.getDesktopIcon().getPreferredSize();
        Component[] frames = desktopPane.getComponents();
        int count = 0;
        int i = 0;
        while (i < frames.length) {
            if (frames[i] instanceof JInternalFrame.JDesktopIcon || frames[i] instanceof JInternalFrame && ((JInternalFrame)frames[i]).getWasIcon() && frames[i] != frame) {
                ++count;
            }
            ++i;
        }
        this.iconRects = new Rectangle[count];
        i = 0;
        while (i < frames.length) {
            if (frames[i] instanceof JInternalFrame.JDesktopIcon) {
                this.iconRects[--count] = frames[i].getBounds();
            } else if (frames[i] instanceof JInternalFrame && ((JInternalFrame)frames[i]).getWasIcon() && frames[i] != frame) {
                this.iconRects[--count] = ((JInternalFrame)frames[i]).getDesktopIcon().getBounds();
            }
            ++i;
        }
        int startingX = insets.left;
        int startingY = paneBounds.height - insets.bottom - pref.height;
        Rectangle ideal = new Rectangle(startingX, startingY, pref.width, pref.height);
        boolean clear = true;
        while (this.iconRects.length > 0) {
            clear = true;
            int i2 = 0;
            while (i2 < this.iconRects.length) {
                if (this.iconRects[i2] != null && this.iconRects[i2].intersects(ideal)) {
                    clear = false;
                    break;
                }
                ++i2;
            }
            if (clear) {
                return ideal;
            }
            if ((startingX += pref.width) + pref.width > paneBounds.width - insets.right) {
                startingX = insets.left;
                startingY -= pref.height;
            }
            ideal.setBounds(startingX, startingY, pref.width, pref.height);
        }
        return ideal;
    }

    protected void setPreviousBounds(JInternalFrame frame, Rectangle rect) {
        frame.setNormalBounds(rect);
    }

    protected Rectangle getPreviousBounds(JInternalFrame frame) {
        return frame.getNormalBounds();
    }

    protected void setWasIcon(JInternalFrame frame, Boolean value) {
        frame.setWasIcon(value, WAS_ICON_ONCE_PROPERTY);
    }

    protected boolean wasIcon(JInternalFrame frame) {
        return frame.getWasIcon();
    }
}

