/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public class IconView
extends View {
    public IconView(Element element) {
        super(element);
    }

    public void paint(Graphics g, Shape a) {
        Icon icon = StyleConstants.getIcon(this.getElement().getAttributes());
        Rectangle b = a.getBounds();
        icon.paintIcon(this.getContainer(), g, b.x, b.y);
    }

    public float getPreferredSpan(int axis) {
        float span;
        Icon icon = StyleConstants.getIcon(this.getElement().getAttributes());
        if (axis == 0) {
            span = icon.getIconWidth();
        } else if (axis == 1) {
            span = icon.getIconHeight();
        } else {
            throw new IllegalArgumentException();
        }
        return span;
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        Element el = this.getElement();
        Rectangle r = a.getBounds();
        Icon icon = StyleConstants.getIcon(el.getAttributes());
        return new Rectangle(r.x, r.y, icon.getIconWidth(), icon.getIconHeight());
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] b) {
        Element el = this.getElement();
        return el.getStartOffset();
    }

    public float getAlignment(int axis) {
        float align = axis == 1 ? 1.0f : super.getAlignment(axis);
        return align;
    }
}

